#!/usr/bin/env bash


if [ "$1" == "--help" ]; then
  echo "Script used to easily create collection of libraries needed"
  echo "to generate a Free Pascal IDE with debugger support."
  echo "Usage: Copy this script to the directory where you just compile"
  echo "a specific GNU debugger (for a specific target)"
  echo "and run ./$0 in that directory"
  echo "After, you will need to run a second script, copy-libs.sh"
  echo "with a single parameter specifying to which directory the libraries"
  echo "should be copied."
  echo "Possible parameters for this script:"
  echo "implicitlibs=\"space separated list if system librairies used\""

fi

if [ "${1#implicitlibs=}" != "$1" ]; then
  implicitlibs=${1#implicitlibs=}
  echo "Also adding implicit libs \"$implicitlibs\""
fi
if [ "${PATHEXT}" != "" ]; then
  EXEEXT=.exe
  if [ "${DJDIR}" != "" ]; then
    libdir=${DJDIR}/lib
  else
    libdir=/lib
  fi
else
  EXEEXT=
  libdir=/lib
fi

echo "Deleting gdb${EXEEXT} to force recompile"
rm -f gdb${EXEEXT}
echo "Rebuilding gdb${EXEEXT}"
MAKE=`which gmake 2> /dev/null`

if [ "${MAKE}" == "" ]; then
  MAKE=make
fi

${MAKE} gdb${EXEEXT} | tee make.log

gdb_full_version=`sed -n "s:.*version.*\"\(.*\)\".*:\1:p" version.c`
gdbcvs=`sed -n "s:.*version.*\"\(.*\)cvs\(.*\)\".*:\1cvs\2:p" version.c`
gdb_version1=`sed -n "s:.*version.*\"\([0-9]*\)\.\([0-9]*\).*:\1:p" version.c`
gdb_version2=`sed -n "s:.*version.*\"\([0-9]*\)\.\([0-9]*\).*:\2:p" version.c`
gdb_version=`sed -n "s:.*version.*\"\([0-9]*\)\.\([0-9]*\).*:\1.\2:p" version.c`

echo found full version is ${gdb_full_version}
echo found version is ${gdb_version}
if [ ${gdb_version2} -lt 10 ]; then
  gdbversion=${gdb_version1}0${gdb_version2}
else
  gdbversion=${gdb_version1}${gdb_version2}
fi

cat make.log | gawk '
BEGIN {
doprint=0
}
# We look for the compilation line
# either gcc or cc
/cc / { doprint=1; }

{
if ( doprint == 1 ) {
  print $0
}
}

! /\\$/ { doprint=0; }
' | tee comp-cmd.log

gcccompiler=`sed -n "s:\([A-Za-z0-9_-]*gcc\) .*:\1:p" comp-cmd.log`
if [ "$gcccompiler" != "" ]; then
  gcclibs=`$gcccompiler -print-search-dirs | sed -n "s#.*libraries: =\(.*\)#\1#p" `
  if [ "$gcclibs" != "" ]; then
    libdir=${gcclibs//:/ }
    echo "gcc libs are \"$libdir\""
  fi
fi

# Try to locate all libraries
echo Creating ./copy-libs.sh script
cat comp-cmd.log | gawk -v libdir="${libdir}" -v implibs="${implicitlibs}" '
BEGIN {
  print "#!/usr/bin/env bash"
  print "# copy-libs.sh generated by awk script"
  print "INSTALL=`which ginstall 2> /dev/null `"
  print "if [ "$INSTALL" == "" ]; then"
  print "  INSTALL=install"
  print "fi"
  print "if [ \"$1\" != \"\" ]; then"
  print "  destdir=$1"
  print "  $INSTALL  -d ${destdir}"
  print "else"
  print "  echo $0 destdir"
  print "  echo destdir should be the location where libgdb.a"
  print "  echo and all other archives should be copied"
  print "  exit"
  print "fi"
  print "# Copy gdblib.inc file"
  print "cp gdblib.inc ${destdir}"
}

{
  nb = split ($0,list);

  for (i=1; i<=nb; i++) {
    if ( list[i] ~ /lib[^ ]*\.a/ ) {
      staticlib = gensub (/([^ ]*)(lib[^ ]*\.a)/,"\\1\\2 ","g",list[i]);
      print "cp " staticlib " ${destdir}";
    }
    if ( list[i] ~ /lib[^ ]*\.so/ ) {
      dynamiclib = gensub (/([^ ]*)(lib[^ ]*\.so)/,"\\1\\2 ","g",list[i]);
      print "echo " dynamiclib " found";
    }
    if ( list[i] ~ /-l/ ) {
      systemlib = gensub (/-l([^ ]*)/,"lib\\1.a ","g",list[i]);
      print "systemlib=`find " libdir " -name " systemlib " 2> /dev/null `" ;
      print "if [ \"${systemlib}\" != \"\" ]; then";
      print "  echo System lib found: ${systemlib}";
      print "  cp ${systemlib} ${destdir}";
      print "else";
      print "  echo Library " systemlib " not found, shared library assumed";
      print "fi";
  }
  }
}
END {
  nb = split (implibs,list);
  for (i=1;i<=nb; i++) {
    systemlib = "lib" list[i] ".a";
    print "echo Adding system library " systemlib;
    print "systemlib=`find " libdir " -name " systemlib " 2> /dev/null `" ;
    print "if [ \"${systemlib}\" != \"\" ]; then";
    print "  echo System lib found: ${systemlib}";
    print "  cp ${systemlib} ${destdir}";
    print "else";
    print "  echo Library " systemlib " not found, shared library assumed";
    print "fi";
  }
}
' | tee copy-libs.sh
chmod u+x ./copy-libs.sh
# For later

echo Creating ./gdblib.inc file
# Generate gdblib.inc file
cat comp-cmd.log |gawk -v gdbcvs=${gdbcvs} -v implibs="${implicitlibs}" \
  -v gdbversion=${gdbversion} '
BEGIN {
  use_mingw=0;
  print "{ libgdb.inc file generated by awk script }"
  print "{$define GDB_V" gdbversion " }"
  if (gdbcvs) {
    print "{$define GDB_CVS}"
  }
  print "{$ifdef COMPILING_GDBINT_UNIT }"
}

{
  nb = split ($0,list);

  for (i=1; i<=nb; i++) {
  if ( list[i] ~ /lib[^ ]*\.a/ ) {
    staticlib = gensub (/([^ ]*)(lib[^ ]*\.a)/,"{$LINKLIB \\2} { found in \\1 }","g",list[i]);
    print staticlib;
    if ( list[i] ~/mingw/ ) {
    use_mingw=1
    }
  }
  if ( list[i] ~ /-D__USE_MINGW_/ ) {
    use_mingw=1
  }
  if ( list[i] ~ /lib[^ ]*\.so/ ) {
    dynamiclib = gensub (/([^ ]*)(lib[^ ]*\.so)/,"{$LINKLIB \\2} { found in \\1 }","g",list[i]);
    librarypath = gensub (/([^ ]*)(lib[^ ]*\.so)/,"{$LIBRARYPATH \\1} { for \\2 }","g",list[i]);
    print dynamiclib;
    print librarypath;
  }
  if ( list[i] ~ /-l/ ) {
    systemlib = gensub (/-l([^ ]*)/,"{$LINKLIB \\1} { with -l gcc option}","g",list[i]);
    print systemlib;
  }
  }
}
END {
  nb = split (implibs,list);
  for (i=1;i<=nb; i++) {
    print "{$LINKLIB " list[i] "} { implicit library } "
  }
  print "{$endif COMPILING_GDBINT_UNIT }"
  print "{$undef NotImplemented}"
  if ( use_mingw == 1 ) {
    print "{$define USE_MINGW_GDB}"
  }
}
' | tee  gdblib.inc


