#include <libebook/e-book.h>
#include <libedataserver/e-source-group.h>
#include <glib.h>
#include <locale.h>

static gchar *id = NULL;
static gchar *full_name = NULL;
static gchar *nickname = NULL;
static gchar *company = NULL;
static gchar **phones = NULL;
static gchar **emails = NULL;

static GOptionEntry entries[] = 
{
	{ "id", 0, 0, G_OPTION_ARG_STRING, &id, "ID of element to modify, new or new-vcard", "ID" },
	{ "full-name", 0, 0, G_OPTION_ARG_STRING, &full_name, "Full name of person", "full_name" },
	{ "nickname", 0, 0, G_OPTION_ARG_STRING, &nickname, "Nickname of person", "nick" },
	{ "company", 0, 0, G_OPTION_ARG_STRING, &company, "Company of person", "company" },
	{ "phones", 0, 0, G_OPTION_ARG_STRING_ARRAY, &phones, "Phone numbers (all)", "phone" },
	{ "emails", 0, 0, G_OPTION_ARG_STRING_ARRAY, &emails, "Email addresses (all)", "email" },

	{ NULL }
};

/*
Addresses List of        `bbdb-record-addresses'    List of address vectors
          Vectors        `bbdb-record-set-addresses'
Net       List of        `bbdb-record-net'          List of network
address   Strings        `bbdb-record-set-net'      addresses
Notes     String or      `bbdb-record-raw-notes'    String or Association
          Alist          `bbdb-record-set-raw-notes'list of note fields
                                                    (strings)
*/

int main(int argc, char **argv)
{
	EBook *book;
	ESourceList *source_list;
	ESourceGroup *group;
	ESource *source;
	GSList *groups;
	EBookQuery *query;
	GList *contacts;
	GSList *sources;
	GSList *g, *s;
	GList *c;
	GError *error = NULL;
	GOptionContext *optioncontext;

	setlocale (LC_ALL, "");

	g_type_init();

	optioncontext = g_option_context_new ("- whack address book");
	g_option_context_add_main_entries (optioncontext, entries, NULL);
	g_option_context_parse (optioncontext, &argc, &argv, &error);

	if (error != NULL) {
		fprintf(stderr, "%s\n", error->message);
		exit(1);
	}

	e_book_get_addressbooks(&source_list, &error);

	if (error != NULL) {
		fprintf(stderr, "%s\n", error->message);
		exit(1);
	}

	if (id == NULL) {
		fprintf(stderr, "You must provide a filter\n");
		exit(1);
	}

	if (strcmp (id, "new-vcard") == 0 || strcmp(id, "new") == 0) {
		EContact *c;
		GString *vcard = g_string_new("");
		char buf[1024];
		ssize_t r;

		if (strcmp (id, "new-vcard") == 0) {
			while ((r = read(0, buf, 1023)) > 0) {
				buf[r] = '\0';
				vcard = g_string_append(vcard, buf);
			}
			c = e_contact_new_from_vcard(vcard->str);

			if (! c) {
				fprintf(stderr, "Error parsing vcard\n");
				return 1;
			}
		} else if (strcmp (id, "new") == 0) {
			c = e_contact_new ();

			if (full_name) {
				g_object_set(c, "full-name", full_name, NULL);
			}

			if (nickname)
				g_object_set(c, "nickname", nickname, NULL);

			if (emails) {
				gchar **head = emails;
				GList *el = NULL;
				while (*head != NULL) {
					el = g_list_prepend(el, *head);
					head++;
				}
				g_object_set(c, "email", el, NULL);
			}
		}

		book = e_book_new_system_addressbook (&error);
		if (error != NULL) {
			fprintf(stderr, "%s\n", error->message);
			return 1;
		}

		e_book_open (book, TRUE, &error);
		if (error != NULL) {
			fprintf(stderr, "%s\n", error->message);
			return 1;
		}

		e_book_add_contact (book, c, &error);
		if (error != NULL) {
			fprintf(stderr, "%s\n", error->message);
			return 1;
		}
	} else {
		char *qu = g_strdup_printf ("(is \"id\" \"%s\")", id);
		query = e_book_query_from_string(qu);
		
		groups = e_source_list_peek_groups(source_list);
		for (g = groups; g; g = g->next) {
			
			group = E_SOURCE_GROUP (g->data);
			sources = e_source_group_peek_sources(group);
			
			for (s = sources ; s; s = s->next) {
				source = E_SOURCE(s->data);
				book = e_book_new(source, &error);
				e_book_open(book, TRUE, &error);
				e_book_get_contacts(book, query, &contacts, &error);

				for (c = contacts; c; c = c->next) {
					if (full_name)
						g_object_set(E_CONTACT(c->data), "full-name", full_name, NULL);

					if (nickname)
						g_object_set(E_CONTACT(c->data), "nickname", nickname, NULL);

					if (emails != NULL) {
						gchar **head = emails;
						GList *el = NULL;

						if (*head[0] == '\0') {
							printf("removing all emails\n");
							head++;
						} else {
							g_object_get(E_CONTACT(c->data), "email", &el, NULL);
						}

						while (*head != NULL) {
							printf("appending %s\n", *head);
							el = g_list_prepend(el, *head);
							head++;
						}
						g_object_set(E_CONTACT(c->data), "email", el, NULL);
					}
					e_book_commit_contact(book, E_CONTACT(c->data), &error);
				}
			}
		}
		e_book_query_unref (query);
		g_free(qu);
	}
	return 0;
}
