C
C**** "ouspace.h"
C
C     PURPOSE
C     _______
C
C     This file contains the work space array definitions for the
C     arrays to hold the unpacked real data from GRIB fields.
C
C     INTERFACE
C     _________
C
C     #include "ouspace.h"
C
C     Common block usage
C     __________________
C
C     GRIB_SPACE
C
C     NIFELD       - POINTER to array RIFELD.
C     NOFELD       - POINTER to array ROFELD.
C
C     RIFELD       - Dynamic array of length (NIWE * NINS)
C                    (see nifld.common) which holds the expanded
C                    input field.
C     ROFELD       - Dynamic array of length (NOWE * NONS)
C                    (see nofld.common) which holds the expanded
C                    output field.
C
C     METHOD
C     ______
C
C     NONE
C
C     REFERENCE
C     _________
C
C     NONE
C
C     COMMENTS
C     ________
C
C     Contains sections 1
C
C     AUTHOR
C     ______
C
C     K. Fielding      *ECMWF*      Apr 1994
C
C     MODIFICATIONS
C     _____________
C
C     NONE
C
C
C     _______________________________________________________
C
C
C*    Section 1. Pointer and array combination
C                Array dimensions are in nifld.common and
C                nofld.common
C     _______________________________________________________
C
      COMMON /GRIB_SPACE/
     1   NIFELD, NOFELD
C
      SAVE /GRIB_SPACE/
C
      REAL RIFELD, ROFELD
C
C     RIFELD is actually only the accumulated field length for a
C     quasi regular input field
C
      POINTER (NIFELD, RIFELD (NIWE * NINS) )
      POINTER (NOFELD, ROFELD (NOWE * NONS) )
