/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

/**************************************************************************
.TITLE    ECMWF Utility
.NAME     GRIBEX
.SECTION  L
.AUTHOR   Otto Pesonen
.DATE     05-JUN-1996 / 05-JUN-1996 / OP
.VERSION  1.0
.LANGUAGE ANSI-C
.FILE     cgsloop.c
.OS       FUJITSU
*
*  Vector loops of gsbite.f coded in C
*
*  C has unsigned datatypes
*
************************************o*************************************/

#include <stdio.h>

#pragma global noalias
#pragma global novrec

gsdecode_(
  unsigned int *in,
  unsigned int *out,
  int *ist_, int *ost_, int *len_, unsigned int *mask_, int *ish_)
{
  int oidx = 0;
  int iidx = 0;

           int ist  = *ist_;
           int ost  = *ost_; 
           int len  = *len_;
  unsigned int mask = *mask_;
           int ish  = *ish_;

  int factor;

  if( ish < 0 )
  { 
    ish = (-ish);

    factor = 1<<ish;

#pragma loop novrec
    for( ; len ; len-- )
    {
      out[oidx] = out[oidx] | (in[iidx] & mask) / factor;
      oidx +=  ost;
      iidx +=  ist;
    }
  }
  else
  {
    factor = 1<<ish;

#pragma loop novrec
    for( ; len ; len-- )
    {
      out[oidx] = out[oidx] | (in[iidx] & mask) * factor;
      oidx +=  ost;
      iidx +=  ist;
    }
  }
}

gsencode_(
  unsigned int *in,
  unsigned int *out,
  int *ist_, int *ost_, int *len_, unsigned int *mask_, int *ish_)
{
  int oidx = 0;
  int iidx = 0;

           int ist  = *ist_;
           int ost  = *ost_; 
           int len  = *len_;
  unsigned int mask = *mask_;
           int ish  = *ish_;

  int factor;

  ish = (-ish);

  if( ish < 0 )
  { 
    ish = (-ish);

    factor = 1<<ish;
#pragma loop novrec
    for( ; len ; len-- )
    {
      out[oidx] = ((in[iidx] / factor) & mask) |
                  (out[oidx] & (~mask)) ;
      oidx +=  ost;
      iidx +=  ist;
    }
  }
  else
  {
    factor = 1<<ish;

#pragma loop novrec
    for( ; len ; len-- )
    {
      out[oidx] = ((in[iidx] * factor) & mask) |
                  (out[oidx] & (~mask)) ;
      oidx +=  ost;
      iidx +=  ist;
    }
  }
}

