% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote.R
\docType{class}
\name{SQL}
\alias{SQL}
\alias{SQL-class}
\alias{dbQuoteIdentifier}
\alias{dbQuoteString}
\title{SQL quoting}
\usage{
SQL(x)

dbQuoteIdentifier(conn, x, ...)

dbQuoteString(conn, x, ...)
}
\arguments{
\item{x}{A character vector to label as being escaped SQL.}

\item{conn}{A subclass of \code{\linkS4class{DBIConnection}}, representing
an active connection to an DBMS.}

\item{...}{Other arguments passed on to methods. Not otherwise used.}
}
\value{
An object of class \code{SQL}.
}
\description{
This set of classes and generics make it possible to flexibly deal with SQL
escaping needs. By default, any user supplied input to a query should be
escaped using either \code{dbQuoteIdentifier} or \code{dbQuoteString}
depending on whether it refers to a table or variable name, or is a literal
string.
These functions return an object of the \code{SQL} class,
which tells DBI functions that a character string does not need to be escaped
anymore, to prevent double escaping.
The \code{SQL} class has associated the \code{SQL()} constructor function.
}
\section{Implementation notes}{


DBI provides default generics for SQL-92 compatible quoting. If the database
uses a different convention, you will need to provide your own methods.
Note that because of the way that S4 dispatch finds methods and because
SQL inherits from character, if you implement (e.g.) a method for
\code{dbQuoteString(MyConnection, character)}, you will also need to
implement \code{dbQuoteString(MyConnection, SQL)} - this should simply
return \code{x} unchanged.

If you implement your own method, make sure to convert NA to NULL (unquoted).
}
\examples{
# Quoting ensures that arbitrary input is safe for use in a query
name <- "Robert'); DROP TABLE Students;--"
dbQuoteString(ANSI(), name)
dbQuoteIdentifier(ANSI(), name)

# NAs become NULL
dbQuoteString(ANSI(), c("x", NA))

# SQL vectors are always passed through as is
var_name <- SQL("select")
var_name

dbQuoteIdentifier(ANSI(), var_name)
dbQuoteString(ANSI(), var_name)

# This mechanism is used to prevent double escaping
dbQuoteString(ANSI(), dbQuoteString(ANSI(), name))
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}}

Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsValid}}
}

