  /*
  * Copyright (C) 2009 Intel Corp.
  * Author: Weian Chen <weian.chen@intel.com>
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2 of the License, or (at your option) any later version.
  *
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the
  * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  * Boston, MA 02111-1307, USA.
  */

#ifndef _GESTURE_RECOG_H_
#define _GESTURE_RECOG_H_ 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <glib.h>
#include "config.h"
#include "plugin.h"

#define MAX_P_LEN 100
#define MAX_S_LEN 10
#define LINE_THRD 0.003
#define OLS_LINE_THRD 0.75
#define PARA_THRD 0.53 // the angle <  PI/6, we think they are para or in the same line
#define P_NUM_THRD 3
#define DIS_THRD   2.0 //NEED ADJUSTMENT
#define X_AXIS_THRD 0.10
#define Y_AXIS_THRD 10.0 // PI/32
#define ARCH_THRD   2.0

typedef enum {
    STROKE_DOT = 0,
    STROKE_LINE,
    STROKE_CURVE
}stroke_type;

typedef struct coord coor;

typedef struct
{
    float x;
    float y;
    double angle;
}point;

typedef struct
{
    point *p;
    double ex_angle;
    double var_angle;
    double ols_a;
    double ols_b;
    double ols_r;
    double ols_angle;
    int   num_p;
    int   max_num_p;
    stroke_type type_s;
}stroke;


typedef struct
{
    stroke s[MAX_S_LEN];
    int num_s;
    int max_num_s;
}gesture;

stroke *stroke_new (int n);
void stroke_del (stroke *s);
void add_point (stroke *s, point p);
void add_point_list (stroke *s, point *p, int n);
void compute_angle (stroke *s);
void compute_ex_var (stroke *s);
void compute_ols (stroke *s);
stroke_type compute_stroke_type (stroke *s);

gesture *gesture_new (int n);
void gesture_del (gesture *g);
void add_stroke_into_gesture (gesture *g, stroke *s);
void handle_pinch (gesture *g, gesture_info *g_info);
void handle_rotate (gesture *g, gesture_info *g_info);
void gesture_recog (gesture *g, gesture_info *g_info);


void gesture_process (GSList *list1, GSList *list2, gesture_info *g_info);
#ifdef GESTURE_DEBUG
#define engine_debug(format, args...) do {\
  fprintf(stderr, format, ##args); \
} while(0)
#else
#define engine_debug(format, ...) 
#endif




#endif
