// ;-*-C++-*-
/*
 *       File name:  ui/modelrun-facility.hh
 *         Project:  Aghermann
 *          Author:  Andrei Zavada <johnhommer@gmail.com>
 * Initial version:  2011-05-14
 *
 *         Purpose:  modelrun facility class and declarations
 *
 *         License:  GPL
 */

#ifndef _AGH_UI_MODELRUN_FACILITY_H
#define _AGH_UI_MODELRUN_FACILITY_H

#include "../core/tunable.hh"
#include "expdesign.hh"

#if HAVE_CONFIG_H && !defined(VERSION)
#  include "config.h"
#endif

using namespace std;

namespace aghui {

struct SModelrunFacility {

	agh::CModelRun&
		csimulation;
	agh::CSubject&
		csubject;

	double	cf;
	double snapshot()
		{
			return cf = csimulation.snapshot();
		}

	double	SWA_max;
	float	display_factor;
	int	zoomed_episode;
	static size_t
		swa_smoothover;  // one side

	bool	_suppress_Vx_value_changed:1,
		_tunables_header_printed:1,
		highlight_nrem:1,
		highlight_rem:1,
		highlight_wake:1;

	SGeometry
		GeometryModRunFac;

	SModelrunFacility( agh::CModelRun&, SExpDesignUI&);
       ~SModelrunFacility();

	static void MF_siman_param_printer( void *xp);
	void siman_param_printer( void*);

	void draw_episode( cairo_t*, size_t ep,
			   size_t ep_start, size_t ep_end,
			   size_t tl_start, size_t tl_end);
	void draw_ticks( cairo_t*, size_t start, size_t end);
	void draw_timeline( cairo_t*);

	void update_infobar();

      // widgets
	GtkBuilder
		*builder;
	int construct_widgets();

	GtkWindow
		*wModelrunFacility;

	GtkDrawingArea
		*daMFProfile;
	GtkTextView
		*lMFLog;
	GtkLabel
		*lMFCostFunction;
	GtkSpinButton
		*eMFSmoothOver;
	GtkCheckButton
		*eMFLiveUpdate,
		*eMFHighlightWake,
		*eMFHighlightNREM,
		*eMFHighlightREM;
	map<GtkSpinButton*, agh::TTunable>
		eMFVx;
	GtkCheckButton
		*eMFDB1,
		*eMFDB2,
		*eMFAZ1,
		*eMFAZ2;
	GtkHBox
		*cMFControls;
	GtkButton
		*bMFRun,
		*bMFReset;
	GtkToolButton
		*bMFAccept;

	GtkTextBuffer
		*log_text_buffer;

	int	da_wd, da_ht;
	static const int tl_pad = 20;
	static const int lgd_margin = 20;
	static const int hypn_depth = 35;
	int da_wd_actual() const
		{
			return da_wd - 2 * tl_pad;
		}

	SExpDesignUI&
		_p;
};


// gsl siman param printer bottleneck
extern SModelrunFacility*
	__MF;
void MF_siman_param_printer( void *xp);


extern "C" {

gboolean daMFProfile_configure_event_cb( GtkWidget*, GdkEventConfigure*, gpointer);
gboolean daMFProfile_draw_cb( GtkWidget*, cairo_t*, gpointer);
gboolean daMFProfile_button_press_event_cb( GtkWidget*, GdkEventButton*, gpointer);
gboolean daMFProfile_scroll_event_cb( GtkWidget*, GdkEventScroll*, gpointer);
void eMFSmoothOver_value_changed_cb( GtkSpinButton*, gpointer);
void eMFHighlightNREM_toggled_cb( GtkCheckButton*, gpointer);
void eMFHighlightREM_toggled_cb( GtkCheckButton*, gpointer);
void eMFHighlightWake_toggled_cb( GtkCheckButton*, gpointer);

void bMFRun_clicked_cb( GtkButton*, gpointer);
void bMFReset_clicked_cb( GtkButton*, gpointer);
void bMFAccept_clicked_cb( GtkToolButton*, gpointer);

void eMFDB1_toggled_cb( GtkCheckButton*, gpointer);
void eMFDB2_toggled_cb( GtkCheckButton*, gpointer);
void eMFAZ1_toggled_cb( GtkCheckButton*, gpointer);
void eMFAZ2_toggled_cb( GtkCheckButton*, gpointer);
void eMFVx_value_changed_cb( GtkSpinButton*, gpointer);

gboolean wModelrunFacility_delete_event_cb( GtkWidget*, GdkEvent*, gpointer);

} // extern "C"

} // namespace aghui

#endif // _AGH_MODELRUN_FACILITY_H

// eof
