/***************************************************************************
                     verkauf_gebRechnung.cpp  -  description
                     ---------------------------------------
    begin                : Tue Jan 23 2001
    version              : $Id: verkauf_gebrechnung.cpp,v 1.8 2001/01/24 20:43:13 joerg_bemme Exp $
    copyright            : (C) 2001 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpushbutton.h>
#include <qmessagebox.h>

#include "verkauf_gebrechnung.h"

Verkauf_GebRechnung::Verkauf_GebRechnung(QWidget *parent, const char *name,
															SQLQuerier *sql_ptr, PrintSystem *print_ptr )
	: QWidget(parent,name)
{
	print = print_ptr;

	QBoxLayout *topLayout = new QVBoxLayout( this, 5 );

	dialog = new QDBMenuDialog( this, 0, sql_ptr, false,
									"SELECT * FROM deb_rech_kopf ORDER BY nummer",
									"nummer", "deb_rech_kopf",
									"GebRechnung.kdevdlg" );

	tableKopf = dialog->dialog->table;
	dialog->menuBar->insertItem( "&Drucken", this, SLOT(sPrint()) );

	dialog->dialog->Page1->navP1->bUpdate->setEnabled( false );
	dialog->dialog->Page1->navP1->bUndo->setEnabled( false );
	dialog->dialog->Page1->navP1->bNew->setEnabled( false );
	dialog->dialog->Page1->navP1->bDelete->setEnabled( false );

	topLayout->addWidget( dialog, 5 );

	// If the position was changed, update the display.
	connect( dialog->dialog->Page1,
		SIGNAL(posChanged()), SLOT(sCalcPositions()) );
	// If the position was changed in the table, update the display.
	connect( dialog->dialog->TableP2,
		SIGNAL(selectionChanged()), SLOT(sCalcPositions()) );

	initPositions();
}

Verkauf_GebRechnung::~Verkauf_GebRechnung(){
}

void Verkauf_GebRechnung::sPrint()
{
	QString s;
	QStringList list;

	if (print != 0) {
		s = "SELECT * FROM deb_rech_kopf WHERE nummer=";
		s.append( tableKopf->getValue( tableKopf->pos, "nummer") );
		list << s; // add to list

		s = "SELECT * FROM deb_rech_zeile WHERE belegnr=";
		s.append( tableKopf->getValue( tableKopf->pos, "nummer") );
		list << s;

		print->reportGenerator( "Debitor_Rechnung", &list );
	}
}

void Verkauf_GebRechnung::initPositions()
{
	QString query = "SELECT * FROM deb_rech_zeile WHERE belegnr = '";
	QString nr;
	QString test;

	zeilen = new QWidget( this );
  topLayoutZeilen = new QVBoxLayout( zeilen, 10 );

	nr.append( tableKopf->getValue( tableKopf->pos, "nummer") );
	query.append( nr );
	query.append( "' ORDER BY belegnr,lfd_nr" );

	// Only for test
	//QMessageBox::information( 0, "QtTudo Test", query.copy() );

	tableZeilen =	new SQLTable( query.ascii(), "belegnr,lfd_nr" );
	if (tableZeilen->execute() != SUCCESS_RESULTS)
		QMessageBox::warning( this, "QtTudo Zeilen generieren", tableZeilen->ErrorText );

	positions = new QDBTableEdit(
		zeilen, 0, &sql, tableZeilen, 0, "deb_rech_zeile", false );

	// Special column headers (labels)
	positions->colName[tableZeilen->fNumber("art")]->append( "Art" );
	positions->colSize[tableZeilen->fNumber("art")] = 70;
	positions->colName[tableZeilen->fNumber("text")]->append( "Text" );
	positions->colSize[tableZeilen->fNumber("text")] = 170;
	positions->colName[tableZeilen->fNumber("lokationscode")]->append( "Lok." );
	positions->colSize[tableZeilen->fNumber("lokationscode")] = 86;
	positions->colName[tableZeilen->fNumber("buch_gr")]->append( "Buch.Gr." );
	positions->colName[tableZeilen->fNumber("mwst_code")]->append( "MwSt." );
	positions->colName[tableZeilen->fNumber("nummer")]->append( "Nummer" );
	positions->colSize[tableZeilen->fNumber("nummer")] = 70;
	positions->colName[tableZeilen->fNumber("menge")]->append( "Menge" );
	positions->colSize[tableZeilen->fNumber("menge")] = 50;
	positions->colName[tableZeilen->fNumber("stueckpreis")]->append( "Stckpreis" );
	positions->colSize[tableZeilen->fNumber("stueckpreis")] = 70;
	positions->colName[tableZeilen->fNumber("nettobetrag")]->append( "Nettobetr." );
	positions->colSize[tableZeilen->fNumber("nettobetrag")] = 70;
	positions->colName[tableZeilen->fNumber("bruttobetrag")]->append( "Bruttobetr." );
	positions->colSize[tableZeilen->fNumber("bruttobetrag")] = 70;
	positions->colName[tableZeilen->fNumber("einstandspreis_mw")]->append( "Einst.Pr.MW" );
	positions->colSize[tableZeilen->fNumber("einstandspreis_mw")] = 70;
	positions->colName[tableZeilen->fNumber("einstandspreis")]->append( "Einst.Pr." );
	positions->colSize[tableZeilen->fNumber("einstandspreis")] = 70;
	positions->colName[tableZeilen->fNumber("mwst_prozent")]->append( "MwSt. %" );

	// Don't show the first 3 fields and activate colName's,
	// because not important for the user.
	for (int i = 3; i < tableZeilen->getnFields(); i++ ) {
		test = tableZeilen->fName( i );
		// Don't show this fields
		if ((test.find("text_2") == -1) &&
				(test.find("lieferdatum") == -1) &&
				(test.find("einheit") == -1) &&
				(test.find("restmenge") == -1) &&
				(test.find("zu_fakturieren") == -1) &&
				(test.find("zu_liefern") == -1) &&
				(test.find("seriennr") == -1) &&
				(test.find("geliefert") == -1) &&
				(test.find("fakturiert") == -1) &&
				(test.find("lieferungsnr") == -1) &&
				(test.find("gewinn_prozent") == -1) &&
				(test.find("art_des_geschaeftes") == -1) &&
				(test.find("verkehrszweig") == -1) &&
				(test.find("einladehafen") == -1) &&
				(test.find("verfahren") == -1) &&
				(test.find("ursprungsregion") == -1)
			 )
		{
			positions->makeVisible( i );
			positions->addCol( i );
		}
	}

	topLayoutZeilen->addWidget( positions, 10 );

	dialog->dialog->addTab( zeilen, "&Zeilen" );

	sCalcPositions();
}

void Verkauf_GebRechnung::sCalcPositions()
{
	int i;
	double f;
	QString s;
	QString query = "SELECT * FROM deb_rech_zeile WHERE belegnr = '";
	QString nr;

	nr.append( tableKopf->getValue( tableKopf->pos, "nummer") );
	query.append( nr );
	query.append( "' ORDER BY belegnr,lfd_nr" );

	tableZeilen->sQuery = query.copy();

	// Only for test
	//QMessageBox::information( 0, "QtTudo Test", tableZeilen->sQuery.copy() );

	if ( tableZeilen->execute() == SUCCESS_RESULTS )
	{
		dialog->dialog->Page1->setValue( "bruttobetrag", &s );

		f = 0;
		for ( i = 0; i < tableZeilen->getnTuples(); i++ ) {
			s = tableZeilen->getValue( i, tableZeilen->fNumber("nettobetrag"));
			f += s.toDouble();
		}
		s.setNum(f);
		dialog->dialog->Page1->setValue( "nettobetrag", &s );
		f = 0;
		for ( i = 0; i < tableZeilen->getnTuples(); i++ ) {
			s = tableZeilen->getValue( i, tableZeilen->fNumber("bruttobetrag"));
			f += s.toDouble();
		}
		s.setNum(f);
		dialog->dialog->Page1->setValue( "bruttobetrag", &s );

		positions->update(false);
	}
}
