/***************************************************************************
                          qdbdialog.cpp  -  description
                             -------------------                                         
    begin                : 29.02.2000
    version              : $Id: qdbdialog.cpp,v 1.12 2001/03/26 06:45:17 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qmessagebox.h>
#include <qpushbutton.h>

#include <math.h>

#include "qdbdialog.h"
#include "qdbsuchen.h"

// In insert mode the user shouldn't use page 2 and 3.
void QDBDialog::deactivatePages()
{
	if (!insMode) {
		insMode = true;
		setTabEnabled( Page2, false );
		setTabEnabled( Page3, false );
	}
}

// Activate page 2 and 3
void QDBDialog::activatePages()
{
	if (insMode) {
		insMode = false;
		setTabEnabled( Page2, true );
		setTabEnabled( Page3, true );
	}
}

// If the selection or filter was changed,
// page 1 and 2 must updated from database.
void QDBDialog::updateView() {
	Page1->Neue_DBPos( table->getnTuples()-1 );
	TableP2->update( table );
}

bool QDBDialog::close( bool forceKill )
{
// Diese Funktion wird noch nicht verwendet. Das kommt spter ...
//===============================================================
//	const char ueberschrift[21] = "Information";

	if (sql->conn != NULL ) {
		// Das Schlieen des Cursors darf eigentlich erst nach dem Destroy
		// des Fensters passieren. Das mu also nochmal umgebaut werden.
//  	if (sql->ExecuteQuery( DBclose->copy() ) != SUCCESS_NO_RESULTS)
//			QMessageBox::information( this, "Test", "Test" );
	}
	return QWidget::close( forceKill );
}

void QDBDialog::apply()
{
// Diese Funktion wird noch nicht verwendet. Das kommt spter ...
//===============================================================
	close();
}

void QDBDialog::DataRebuild()
{
	if ( sql->conn != NULL )
		if ( TableP2->currentItem() != 0 )
			if ( table->pos != TableP2->currentItem()->DBPos ) {
				Page1->Neue_DBPos( TableP2->currentItem()->DBPos );
			}
}

// If the page was changed, we have to change the focus too,
// because the defined keys on each page have different
// meanings.
void QDBDialog::setFocus( QWidget *page )
{
	if ( strstr( page->name(), "page1" ) != NULL )
		Page1->navP1->bFind->setFocus();
	if ( strstr( page->name(), "page2" ) != NULL )
		TableP2->setFocus();
}

QDBDialog::QDBDialog( QWidget * parent, const char * name,
											SQLQuerier *sql_ptr, bool MakeFields,
											const char *SelectPtr, const char *PrimaryKeyPtr,
											const char *tableName, const char *filename )
  : QTabWidget( parent, name )
{
	// Is the variable true, then
	// we must close this objekt.
	killMe = false;
	insMode = false;

	if ((SelectPtr==0) || (PrimaryKeyPtr==0) || (tableName==0) || (sql_ptr==0))
		QMessageBox::warning( this, "QtTudo", "QDBDialog: Einer der bergabeparameter fehlt!" );

	// Here is the result of the query
  table = new SQLTable( SelectPtr, PrimaryKeyPtr );

	sql					= sql_ptr;
	table->pos	= 0;

  // make database connection
	if ( sql->conn != NULL ) {
	  if ( table->execute() != SUCCESS_RESULTS )
			QMessageBox::warning( this, "QtTudo", table->ErrorText );
	}	else {
		QMessageBox::critical( this, "QtTudo", "Keine Datenbankverbindung aktiv!" );
		return;
	}

	if (table->table == 0)
		QMessageBox::warning( this, "QtTudo", "Kein Ergebnis von der Datenbank erhalten!" );

  Page2       = new QWidget( this, "page2" );
  Page3       = new QWidget( this, "page3" );
	frSortP3		= new QFrame( Page3 );
  topLayoutP2 = new QVBoxLayout( Page2, 10 );
  topLayoutP3 = new QVBoxLayout( Page3, 10 );

	// Sorting
  frSortP3->setFrameStyle( QFrame::Box | QFrame::Sunken );

	// generate table
	if (table->table == 0)
		QMessageBox::warning( this, "QtTudo", "Tabelle kann nicht erzeugt werden!" );
	else {
		TableP2 = new QDBTableView( Page2, "Tabelle", sql, table );
		topLayoutP2->addWidget( TableP2, 10 );

		Page1 = new QDBEingabemaske( this, "page1", sql, table, tableName, TableP2,
																MakeFields, filename );
		// if the database is empty, call fNew
		//if (table->pos < 0)
			//Page1->fNew();
		setMinimumSize( Page1->sizeHint() );
		setMinimumSize( width()+50, Page1->height()+100 );

		frSortP3->setMinimumSize( Page3->sizeHint() );
		SortP3 = new QDBSortFilter( frSortP3, "Filter", sql, table );
		topLayoutP3->addWidget( frSortP3, 10 );
	}

	connect( Page1, SIGNAL(tupleChanged()), SLOT(activatePages()) );
	connect( TableP2, SIGNAL(selectionChanged()), SLOT(DataRebuild()) );
	connect( SortP3, SIGNAL(updateView() ), SLOT(updateView()) );
	connect( Page1, SIGNAL(sigNew()), SLOT(deactivatePages()) );
	connect( Page1, SIGNAL(sigUndo()), SLOT(activatePages()) );
	connect( this, SIGNAL(currentChanged(QWidget *)), SLOT(setFocus(QWidget *)) );

	addTab( Page1, "&Eingabe" );
	addTab( Page2, "&Tabelle" );
	addTab( Page3, "&Selektion" );
}
