/* GtkSQL -- an interactive graphical query tool for PostgreSQL
 * Copyright (C) 1998  Lionel ULMER
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "common.h"

#include "dialogs.h"
#include "queries.h"

static int tables_in_list = 0;
static GtkWidget *notebook;

static GtkWidget *container;
static GtkWidget *editor;

static editor_displayed = 0;

static GtkWidget *create_table_info(DBTableDef *tbd) {
  GtkWidget *info_clist;
  GtkWidget *info_scroll;
  int i;
  char *col_titles[] = {
    "Field", "Type", "Length"
  };
  
  /* CList initialisation */
  info_scroll = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(info_scroll),
				 GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  

  info_clist = gtk_clist_new_with_titles(3, col_titles);
  gtk_widget_show(info_clist);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(info_scroll), info_clist);
  
  gtk_clist_set_column_width(GTK_CLIST(info_clist), 0, 130);
  gtk_clist_set_column_width(GTK_CLIST(info_clist), 1, 130);
  
  
  for (i = 0; i < tbd->field_num; i++) {
    char *line[3];

    line[0] = tbd->field_def[i].name;
    line[1] = tbd->field_def[i].type;
    line[2] = tbd->field_def[i].length;
      
    gtk_clist_append(GTK_CLIST(info_clist), line);
  }

  gtk_widget_show(info_scroll);
  return info_scroll;
}

void TablesNewConnection() {
  if (conn->DBget_table_def(conn) < 0) {
    GtkWidget *dialog;

    dialog = CreateStandardDialog("Error retrieving table list",
				  "Error retrieving table list",
				  1, NULL,
				  "Ok", NULL,
				  NULL, NULL,
				  NULL);
    gtk_widget_show(dialog);   
  } else {
    int i;
    
    tables_in_list = conn->DBget_table_num(conn);
  
    for (i = 0; i < tables_in_list; i++) {
      DBTableDef *tbd = conn->DBget_table(conn, i);
      GtkWidget *label;
      
      label = gtk_label_new(tbd->name);
      gtk_widget_show(label);
      gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
			       create_table_info(tbd),
			       label);
    }
  }

  gtk_widget_set_sensitive(editor, TRUE);
}

void TablesConnectionClosed() {
  int i;

  conn->DBfree_table_def(conn);
  for (i = 0; i < tables_in_list; i++) {
    gtk_notebook_remove_page(GTK_NOTEBOOK(notebook), 0);
  }

  gtk_widget_set_sensitive(editor, FALSE);
}

int DisplayTableNamed(char *tablename) {
  int i;

  for (i = 0; i < tables_in_list; i++) {
    char *name;
    GtkWidget *label = gtk_notebook_get_tab_label(GTK_NOTEBOOK(notebook),
						  gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
									    i));

    gtk_label_get(GTK_LABEL(label),
		  &name);

    if (!strcmp(name, tablename)) {
      gtk_notebook_set_page(GTK_NOTEBOOK(notebook), i);
      return 1;
    }
  }

  return 0;
}

void DisplayEditor() {
  if (!editor_displayed) {
    gtk_widget_show(editor);
  } else {
    gtk_widget_hide(editor);
  }

  editor_displayed = !editor_displayed;
}

static GtkWidget *create_editor() {
  GtkWidget *ret;

  ret = gtk_label_new("Test");
  
  return ret;
}

GtkWidget *InitTablesPane() {
  container = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(container);
  
  notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
  gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);
  gtk_notebook_popup_enable(GTK_NOTEBOOK(notebook));
  gtk_widget_show(notebook);

  editor = create_editor();
  
  gtk_box_pack_start(GTK_BOX(container), notebook,
		     TRUE, TRUE, 0);
  gtk_box_pack_end(GTK_BOX(container), editor,
		   FALSE, FALSE, 0);
  
  return container;
}
