/* GtkSQL -- an interactive graphical query tool for PostgreSQL
 * Copyright (C) 1998  Lionel ULMER
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __QUERIES_H__
#define __QUERIES_H__

#define KEYWORD_SQL   0
#define KEYWORD_TABLE 1
#define KEYWORD_FIELD 2

/* This is the maximum result column width  */
#define MAXCOLWID 25 

typedef struct _keyword {
  char *key;
  int type;

  struct _keyword *next;
} Keyword;

#include "db_conn.h"

void AddKeyword(DBConnection *conn, char *key, int type) ;
void RemoveKeywords(DBConnection *conn, int type) ;
void RemoveAllKeywords(DBConnection *conn) ;

void InitQueries() ;
void SendQuery() ;
void AddQuery() ;
int DeleteQuery() ;
void RenameQuery() ;
int NbQueries() ;
void SaveQueryDialog() ;
void LoadQueryDialog() ;

void QueriesNewConnection();
void QueriesConnectionClosed();

GtkWidget *InitQueryPane() ;
GtkWidget *InitResultPane() ;

GtkWidget *GetCurrentQuery();
void *GetCurrentQueryResult() ;
void *GetQueryResult(GtkWidget *query) ;
char *GetCurrentQueryName() ;

#endif  __QUERIES_H__
