/*

    File: geometry.c

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#include <stdarg.h>
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <ctype.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include "types.h"
#include "common.h"
#include "intrf.h"
#include "chgtype.h"

void change_geometry(t_param_disk *disk_car)
{
  int done = FALSE;
  char def[LINE_LENGTH];
  char response[LINE_LENGTH];
  int tmp_val;
  int command;
  int default_option=4;
  int modified=0;

  while (done==FALSE) {
	static struct MenuItem menuGeometry[]=
	{
	  { 'c', "Cylinders", "Change cylinder geometry" },
	  { 'h', "Heads", "Change head geometry" },
	  { 's', "Sectors", "Change sector geometry" },
	  { 'n', "Sector Size", "Change sector size (WARNING: VERY DANGEROUS!)" },
	  { 'q', "Quit", "Done with changing geometry" },
	  { 0, NULL, NULL }
	};
	aff_copy(stdscr);
	wmove(stdscr,5,0);
	wdoprintf(stdscr,"%s, sector size=%u\n",disk_car->description(disk_car),disk_car->sector_size);
	wmove(stdscr,COMMAND_LINE_Y, COMMAND_LINE_X);
	wclrtoeol(stdscr);
	wrefresh(stdscr);
	command=wmenuSimple(stdscr,menuGeometry, default_option);
	command=toupper(command);
	switch (command) {
	  case 'C':
		sprintf(def, "%u", disk_car->CHS.cylinder+1);
		mvwaddstr(stdscr,COMMAND_LINE_Y, COMMAND_LINE_X, "Enter the number of cylinders: ");
		if (get_string(response, LINE_LENGTH, def) > 0) {
		  tmp_val = atoi(response);
		  if (tmp_val > 0 && tmp_val <= MAX_CYLINDERS) {
			disk_car->CHS.cylinder = tmp_val-1;
		  } else
			wdoprintf(stdscr,"Illegal cylinders value");
		}
		default_option=1;
		modified=1;
		break;
	  case 'H':
		sprintf(def, "%u", disk_car->CHS.head+1);
		mvwaddstr(stdscr,COMMAND_LINE_Y, COMMAND_LINE_X, "Enter the number of heads: ");
		if (get_string(response, LINE_LENGTH, def) > 0) {
		  tmp_val = atoi(response);
		  if (tmp_val > 0 && tmp_val <= MAX_HEADS) {
		    disk_car->CHS.head = tmp_val-1;
		    if(modified==0)
		    {
		      disk_car->CHS.cylinder=(disk_car->disk_size/disk_car->sector_size/(disk_car->CHS.head+1))/disk_car->CHS.sector-1;
		    }
		  } else
		    wdoprintf(stdscr,"Illegal heads value");
		}
		default_option=2;
		break;
	  case 'S':
		sprintf(def, "%u", disk_car->CHS.sector);
		mvwaddstr(stdscr,COMMAND_LINE_Y, COMMAND_LINE_X, "Enter the number of sectors per track (1-63): ");
		if (get_string(response, LINE_LENGTH, def) > 0) {
		  tmp_val = atoi(response);
		  /* SUN partition can have more than 63 sectors */
		  if (tmp_val > 0) {
			disk_car->CHS.sector = tmp_val;
			if(modified==0)
			{
			  disk_car->CHS.cylinder=(disk_car->disk_size/disk_car->sector_size/(disk_car->CHS.head+1))/disk_car->CHS.sector-1;
			}
		  } else
			wdoprintf(stdscr,"Illegal sectors value");
		}
		default_option=3;
		break;
	  case 'N':
		sprintf(def, "%u", disk_car->sector_size);
		mvwaddstr(stdscr,COMMAND_LINE_Y, COMMAND_LINE_X, "Enter the sector size (512, 1024, 2048, 4096): ");
		if (get_string(response, LINE_LENGTH, def) > 0) {
		  tmp_val = atoi(response);
		  /* FIXME using 3*512=1536 as sector size and */
		  /* 63/3=21 for number of sectors is an easy way to test */
		  if (tmp_val==512 || tmp_val==1024 || tmp_val==2048 || tmp_val==4096 || tmp_val==3*512) {
		    disk_car->sector_size = tmp_val;
		    if(modified==0)
		    {
		      disk_car->CHS.cylinder=(disk_car->disk_size/disk_car->sector_size/(disk_car->CHS.head+1))/disk_car->CHS.sector-1;
		    }
		  } else
		    wdoprintf(stdscr,"Illegal sector size");
		}
		default_option=4;
		break;
	  case key_ESC:
  	  case 'Q':
		done = TRUE;
		break;
	}
  }
  disk_car->disk_size=(uint64_t)(disk_car->CHS.cylinder+1)*(disk_car->CHS.head+1)*disk_car->CHS.sector*disk_car->sector_size;
  ecrit_rapport("New geometry\n%s sector_size=%u\n", disk_car->description(disk_car), disk_car->sector_size);
}

