import XmlDocumentClient
from Ft.Server.FtRpc import Commands

class RdfDocumentClient(XmlDocumentClient.XmlDocumentClient):
    """
    An RDF Document is a document that represents a set of RDF triples.
    Nothing is actually stored in the Repo as far as an XML file goes.
    """
    def complete(self, subject=None, predicate=None, object=None):
        """Perform a complete within this scope"""
        raise NotImplementedError("complete")

    def deserializeAndAdd(self, src):
        """
        Deserialize a source document and add the resulting statements to a scope
        """
        Commands.RemoteMethodCommand(
            'deserializeAndAdd', self._path,
            (src,)
            ).send(self._connection).results

        return self.fetchResource(self._path)

    def deserializeAndRemove(self, src):
        """
        Deserialize a source document and remove the resulting statements from the scope
        """
        Commands.RemoteMethodCommand(
            'deserializeAndRemove', self._path,
            (src,)
            ).send(self._connection).results

        return self.fetchResource(self._path)

