from Ft.Lib.DistExt import Localization, Script, Extension

name = "4Ods"
version = '1.0a3'
description = "An object database system"
author = "Fourthought, Inc."
author_email='support@fourthought.com'
url = "http://4suite.org/"
long_description = "An implementation of the ODMG Object Data Standard v3.0"


packages = ['Ft.Ods',
            'Ft.Ods.Collections',
            'Ft.Ods.MetaData',
            'Ft.Ods.Parsers',
            'Ft.Ods.Parsers.Odl',
            'Ft.Ods.Parsers.Oif',
            'Ft.Ods.Parsers.Oql',
            'Ft.Ods.StorageManager',
            'Ft.Ods.StorageManager.Adapters',
            'Ft.Ods.StorageManager.Adapters.Dbm',
            'Ft.Ods.StorageManager.Adapters.Sql',
            'Ft.Ods.StorageManager.Adapters.Postgres',
            'Ft.Ods.StorageManager.Adapters.Oracle',
            'Ft.Ods.Tools',
            ]

tests = ['Ods',
         'Ods.Collections',
         'Ods.MetaData',
         'Ods.Borrowed',
         'Ods.Adapters',
         'Ods.Parsers',
         'Ods.StorageManager',
         'Ods.System',
         ]
         
data_files = [
    ('Ft.Share.Data', ['Ft/Ods/Share/Data/README']),
    ('Ft.Share.Data.DbmDatabases', ['Ft/Ods/Share/Data/DbmDatabases/README']),
    ]


ext_modules = [
    Extension('Ft.Ods.Parsers.Oql.OqlParserc',
              sources=['Ft/Ods/Parsers/Oql/OqlParser.c'],
              ),
    #Extension('Ft.Ods.Parsers.Oif.OifParserc',
    #          sources=['Ft/Ods/Parsers/Oif/OifParser.c'],
    #          ),
    ]

scripts = [
    Script('4odb', 'Ft.Ods.Tools._4odb.OdsCommandLineApp'),
    ]

# restore when BisonGen uses gettext in C parsers
#l10n = [Localization(package='Ft.Ods.Parsers.Odl',
#                     domain='4Suite',
#                     sources=['Ft/Ods/Parsers/Odl/OdlParser.py']),
#        Localization(package='Ft.Ods.Parsers.Oql',
#                     domain='4Suite',
#                     sources=['Ft/Ods/Parsers/Oql/OqlParser.py']),
#        Localization(package='Ft.Ods.Parsers.Oif',
#                     domain='4Suite',
#                     sources=['Ft/Ods/Parsers/Oif/OifParser.py']),
#        ]

bgen_files = ['Ft/Ods/Parsers/Odl/Odl.bgen',
              'Ft/Ods/Parsers/Odl/IfExpr.bgen',
              'Ft/Ods/Parsers/Oql/Oql.bgen',
              'Ft/Ods/Parsers/Oif/Oif.bgen',
              ]

doc_files = []

dependencies = [('4Lib','1.0a3'),
                ]

# Cleanup local namespace
del Script
del Localization
del Extension
