#!/usr/bin/env python
############################################################################
#  
#  Copyright (c)2000 Fourthought, Inc.
#  http://ftsuite.com/4ODS
#
############################################################################
#
# File Name: 		create.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Tools/4odb_create.py.html
#


#Create a new database ready to accept ODL

import sys

__doc__  = """The create command is used to create a new 4ODS database"""


def Run(options,args,quite=0):
    from Ft.Ods.StorageManager import Adapters
    dbName = args['dbName']
    mang = Adapters.GetManager(options.get('adapter')) 
    adapter = Adapters.GetAdapter(options.get('adapter')) 

    if mang.exists(dbName):
        sys.stderr.write("Database %s already exists\n" % dbName)
        return
    mang.new(dbName, adapter)
    if not quite:
        print "Database %s created" % dbName



def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('create',
                          'Create a new 4ODS database',
                          ' test',                          
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('dbName',
                                                                  'The name of the database.',
                                                                  str),
                                       ],
                                                               
                          )
    return cmd


