/***************************************************************************
 *   Copyright (C) 2003 by Yann Bouan                                      *
 *   <yann@bouan.net>                                                      *
 *                                                                         *
 *   Copyright (C) 2003 by Claudio J. Chiabai                              *
 *   <chiabai@users.sourceforge.net>                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _PICWIZ_H_
#define _PICWIZ_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// archivos include para Qt
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qwidget.h>
#include <qvbox.h>
#include <qvbuttongroup.h>
#include <qlabel.h>
#include <qimage.h>

// archivos include para KDE
#include <kwizard.h>
#include <knuminput.h>
#include <kcombobox.h>
#include <klistbox.h>
#include <kprogress.h>

/**
 * @short Application Main Window
 * @author Claudio J. Chiabai <chiabai@users.sourceforge.net>
 * @version 0.1
 */
class PicWiz : public KWizard
{
    Q_OBJECT
  public:
    PicWiz();
    virtual ~PicWiz();

  private:
    int height, width;
    QImage *m_img;

    // Page 1 ==========================
    QButtonGroup* page1;
    void setupPage1();
    // Standard ---------------------
    QRadioButton* m_standardSize;
    KComboBox* m_sizeCombo;

    // Custom ------------------------
    QRadioButton* m_customSize;
    QLabel* lblHeight;
    KIntNumInput* m_height;
    QLabel* lblWidth;
    KIntNumInput* m_width;

    QCheckBox* m_overwrite;

    // Page 2 ==========================
    QVBox* page2;
    void setupPage2();
    KListBox *m_results;
    KProgress* m_progress;

  protected slots:
    void sizeSelection(int id);
    void changeMode();

  private slots:
    void resize(const QString &);
    void about();
};

#endif // _PICWIZ_H_
