/* 
 * PrefController.m created by probert on 2001-11-15 20:24:08 +0000
 *
 * Project ImageViewer
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: PrefController.m,v 1.7.2.1 2003/08/01 15:30:49 probert Exp $
 */

#include "PrefController.h"
#include "PrefController+InterfaceCreation.h"

#include "ImageCache.h"

@implementation PrefController

- (id)init
{
    if( self = [super init] ) 
    {
        [self _createUI];
    }
    return self;
}

- (void)dealloc
{
    RELEASE(preferences);
    RELEASE(prefDict);

    [super dealloc];
}

- (void)show
{
    NSString *string = nil;

    if (![preferences isVisible]) 
    { 
        [preferences setFrameUsingName:@"Preferences"];
    }

    string = [[NSUserDefaults standardUserDefaults] objectForKey:@"CacheSize"];
    if( string != nil )
    {
        [cacheSizeField setStringValue:string];
    }
    else
    {
        [cacheSizeField setStringValue:@"50"];
        [prefDict setObject:@"50" forKey:@"CacheSize"];
    }


    /*string = [prefDict objectForKey:@"OpenRec"]; */
    string = [[NSUserDefaults standardUserDefaults] objectForKey:@"OpenRec"];
    [openRecursive setState:([string isEqualToString:@"YES"]) ? 
                                                    NSOnState : NSOffState];
    if( string == nil )
    {
        [prefDict setObject:@"NO" forKey:@"OpenRec"];
    }

    RETAIN(prefDict);
    [preferences makeKeyAndOrderFront:self];
}

- (void)setCacheSize:(id)sender
{
    NSString *val = [cacheSizeField stringValue];

    [prefDict setObject:val forKey:@"CacheSize"];
    [preferences setDocumentEdited:YES];
}

- (void)setOpenRecursive:(id)sender
{
    switch ([[sender selectedCell] state]) 
      {
        case 0:
            [prefDict setObject:@"NO" forKey:@"OpenRec"];
            break;
        case 1:
            [prefDict setObject:@"YES" forKey:@"OpenRec"];
            break;
      }
    [preferences setDocumentEdited:YES];
}

- (void)buttonsPressed:(id)sender
{
    switch ([[sender selectedCell] tag]) 
      {
        case 0:
	    [self resetPreferences];
            break;
	case 1:
	    [self setPreferences];
	    break;
      }

    [preferences setDocumentEdited:NO];
    //[preferences orderOut:self];
}

- (void)resetPreferences
{
    NSString *string;

    string = [[NSUserDefaults standardUserDefaults]  objectForKey:@"CacheSize"];
    [cacheSizeField setStringValue:(string) ? string : @"50"];

    [openRecursive setState:
             ([[[NSUserDefaults standardUserDefaults] objectForKey:@"OpenRec"] 
                            isEqualToString:@"YES"]) ? NSOnState : NSOffState];
}

- (void)setPreferences
{
    NSString *string = [prefDict objectForKey:@"CacheSize"];

    [[NSUserDefaults standardUserDefaults] setObject:string
    forKey:@"CacheSize"]; 

    [[ImageCache sharedCache] setMaxImages:[string intValue]];

    string = [prefDict objectForKey:@"OpenRec"];
    [[NSUserDefaults standardUserDefaults] setObject:string
                                              forKey:@"OpenRec"];
}

@end
