/* 
 * ImagesWindow.h created by phr on 2000-10-21 09:33:57 +0000
 *
 * Project ImageViewer
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: ImagesWindow.h,v 1.6 2003/06/29 17:28:34 probert Exp $
 */

#ifndef _IMAGESWINDOW_H_
#define _IMAGESWINDOW_H_

#include <AppKit/AppKit.h>
#include "ImageShowing.h"

@class BrowserController;

@interface ImagesWindow : NSObject <ImageShowing>
{
  id delegate;
  NSWindow *window;
  BrowserController *browserController;
  NSBrowser *browser;
}

- (id)initWithContentsAtPath:(NSString *)path;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

- (void)windowWillClose:(NSNotification *)notif;
- (void)windowDidBecomeKey:(NSNotification *)aNotification;

- (NSString *)path;
- (NSString *)imagePath;
- (NSString *)imageName;
- (NSString *)imageType;
- (NSString *)imageSize;
- (NSString *)imageFileModificationDate;
- (NSString *)imageFilePermissions;
- (NSString *)imageFileOwner;
- (NSString *)imageResolution;
- (NSString *)bitsPerSample;
- (NSString *)colorSpaceName;
- (NSString *)hasAlpha;
- (NSString *)imageReps;

@end

@interface NSObject (ImagesWindowDelegates)

- (void)imagesWindowWillClose:(id)sender;

@end

#endif // _IMAGESWINDOW_H__
