/*
 * Decompiled with CFR 0.152.
 */
package hughai.ui;

import hughai.PlayerObjects;
import hughai.utils.Formatting;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExceptionList {
    PlayerObjects playerObjects;
    JPanel panel;
    JScrollPane scrollpane;
    JTextArea exceptionsText;
    boolean exceptionReportedAlready = false;

    public ExceptionList(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.panel = new JPanel();
        this.scrollpane = new JScrollPane();
        this.panel.add(this.scrollpane);
        this.exceptionsText = new JTextArea();
        this.scrollpane.add(this.exceptionsText);
        playerObjects.getMainUI().addPanelToTabbedPanel("Exceptions", this.panel);
    }

    public void reportException(Exception exception) {
        if (!this.exceptionReportedAlready) {
            this.playerObjects.getMainUI().showInfo("Something went wrong :-/  Please send the team log in the AI directory to hughperkins@gmail.com.  Techie info follows: " + Formatting.exceptionToStackTrace(exception));
            this.exceptionReportedAlready = true;
        }
        this.exceptionsText.setText(this.exceptionsText.getText() + Formatting.exceptionToStackTrace(exception) + "\n");
        this.panel.validate();
    }
}

