/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.OptionalInt;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClientBase;
import org.apache.solr.client.solrj.response.HealthCheckResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class HealthCheckRequest
extends SolrRequest<HealthCheckResponse> {
    public static final String PARAM_MAX_GENERATION_LAG = "maxGenerationLag";
    private OptionalInt maxLagAllowed = OptionalInt.empty();

    public HealthCheckRequest() {
        this(SolrRequest.METHOD.GET, "/admin/info/health");
    }

    private HealthCheckRequest(SolrRequest.METHOD m, String path) {
        super(m, path);
    }

    public void setMaxGenerationLag(int maxLagAllowed) {
        this.maxLagAllowed = OptionalInt.of(maxLagAllowed);
    }

    @Override
    public SolrParams getParams() {
        if (this.maxLagAllowed.isPresent()) {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set(PARAM_MAX_GENERATION_LAG, this.maxLagAllowed.getAsInt());
            return params;
        }
        return null;
    }

    @Override
    protected HealthCheckResponse createResponse(SolrClient client) {
        assert (client instanceof BaseHttpSolrClient || client instanceof HttpSolrClientBase);
        return new HealthCheckResponse();
    }

    @Override
    public String getRequestType() {
        return SolrRequest.SolrRequestType.ADMIN.toString();
    }
}

