/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security.cert;

import java.lang.invoke.MethodHandles;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SUBJECT_DN_PREFIX = "subject.dn";
    public static final String ISSUER_DN_PREFIX = "issuer.dn";
    public static final String SAN_PREFIX = "san.";

    public static Optional<String> extractFieldFromX500Principal(X500Principal principal, String path) {
        if (principal == null || path == null || path.isEmpty()) {
            return Optional.empty();
        }
        String dn = principal.getName("RFC2253");
        try {
            LdapName ln = new LdapName(dn);
            if (path.equalsIgnoreCase(SUBJECT_DN_PREFIX) || path.equalsIgnoreCase(ISSUER_DN_PREFIX)) {
                List rdns = ln.getRdns().stream().map(rdn -> rdn.getType().trim() + "=" + rdn.getValue().toString().trim()).sorted().collect(Collectors.toList());
                dn = String.join((CharSequence)",", rdns);
                return Optional.of(dn);
            }
            String field = null;
            if (path.startsWith("subject.dn.")) {
                field = path.substring("subject.dn.".length());
            } else if (path.startsWith("issuer.dn.")) {
                field = path.substring("issuer.dn.".length());
            }
            if (field != null) {
                String fieldF = field;
                return ln.getRdns().stream().filter(rdn -> rdn.getType().equalsIgnoreCase(fieldF)).findFirst().map(Rdn::getValue).map(Object::toString);
            }
        }
        catch (InvalidNameException e) {
            log.warn("Invalid DN in LdapName instantiation. DN={}", (Object)dn);
        }
        return Optional.empty();
    }

    public static Optional<String> extractFromSubjectDN(X509Certificate certificate, String path) {
        return CertUtil.extractFieldFromX500Principal(certificate.getSubjectX500Principal(), path);
    }

    public static Optional<String> extractFromIssuerDN(X509Certificate certificate, String path) {
        return CertUtil.extractFieldFromX500Principal(certificate.getIssuerX500Principal(), path);
    }

    public static Optional<List<String>> extractFromSAN(X509Certificate certificate, String path, Predicate<String> valueMatcher) throws CertificateParsingException {
        Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
        if (altNames == null) {
            return Optional.empty();
        }
        List filteredSANValues = altNames.stream().filter(entry -> entry != null && entry.size() >= 2).filter(entry -> {
            SANType sanType = SANType.fromValue((Integer)entry.get(0));
            return sanType != null && sanType.pathLowerCase().equals(path);
        }).map(entry -> (String)entry.get(1)).filter(valueMatcher).collect(Collectors.toList());
        return Optional.of(filteredSANValues);
    }

    public static enum SANType {
        OTHER_NAME(0),
        EMAIL(1),
        DNS(2),
        X400_ADDRESS(3),
        DIRECTORY_NAME(4),
        EDI_PARTY_NAME(5),
        URI(6),
        IP_ADDRESS(7),
        REGISTERED_ID(8);

        private static final Map<Integer, SANType> lookup;
        private final int value;

        private SANType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SANType fromValue(int value) {
            return lookup.get(value);
        }

        public String path() {
            return "SAN." + this.name();
        }

        public String pathLowerCase() {
            return this.path().toLowerCase(Locale.ROOT);
        }

        static {
            lookup = EnumSet.allOf(SANType.class).stream().collect(Collectors.toMap(SANType::getValue, sanType -> sanType));
        }
    }
}

