/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.Timer;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.core.SolrCoreMetric;

public class SolrCoreSearcherMetric
extends SolrCoreMetric {
    public static final String CORE_SEARCHER_METRICS = "solr_metrics_core_searcher_documents";
    public static final String CORE_SEARCHER_TIMES = "solr_metrics_core_searcher_warmup_time_ms";

    public SolrCoreSearcherMetric(Metric dropwizardMetric, String metricName) {
        super(dropwizardMetric, metricName);
    }

    @Override
    public SolrCoreMetric parseLabels() {
        String[] parsedMetric = this.metricName.split("\\.");
        if (!(this.dropwizardMetric instanceof Counter)) {
            this.labels.put("type", parsedMetric[2]);
        }
        return this;
    }

    @Override
    public void toPrometheus(SolrPrometheusFormatter formatter) {
        if (this.dropwizardMetric instanceof Gauge) {
            if (this.metricName.endsWith("liveDocsCache")) {
                formatter.exportGauge("solr_metrics_core_cache", (Gauge)this.dropwizardMetric, this.getLabels());
            } else {
                formatter.exportGauge(CORE_SEARCHER_METRICS, (Gauge)this.dropwizardMetric, this.getLabels());
            }
        } else if (this.dropwizardMetric instanceof Timer) {
            formatter.exportTimer(CORE_SEARCHER_TIMES, (Timer)this.dropwizardMetric, this.getLabels());
        }
    }
}

