/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.DATE;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class DateTimeCommonAccessor
extends Accessor {
    static final int GREGORIAN_CUTOVER_YEAR = 1582;
    static final long GREGORIAN_CUTOVER = -12219292800000L;
    static final int JAN_1_1_JULIAN_DAY = 1721426;
    static final int EPOCH_JULIAN_DAY = 2440588;
    static final int ONE_SECOND = 1000;
    static final int ONE_MINUTE = 60000;
    static final int ONE_HOUR = 3600000;
    static final long ONE_DAY = 86400000L;
    static final int[] NUM_DAYS;
    static final int[] LEAP_NUM_DAYS;
    static final int ORACLE_CENTURY = 0;
    static final int ORACLE_YEAR = 1;
    static final int ORACLE_MONTH = 2;
    static final int ORACLE_DAY = 3;
    static final int ORACLE_HOUR = 4;
    static final int ORACLE_MIN = 5;
    static final int ORACLE_SEC = 6;
    static final int ORACLE_NANO1 = 7;
    static final int ORACLE_NANO2 = 8;
    static final int ORACLE_NANO3 = 9;
    static final int ORACLE_NANO4 = 10;
    static final int ORACLE_TZ1 = 11;
    static final int ORACLE_TZ2 = 12;
    static final int SIZE_DATE = 7;
    static int OFFSET_HOUR;
    static int OFFSET_MINUTE;
    static byte REGIONIDBIT;
    static final int MAX_TIMESTAMP_LENGTH = 11;
    protected final byte[] tmpBytes;
    static TimeZone epochTimeZone;
    static long epochTimeZoneOffset;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;

    static int setHighOrderbits(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int ID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$0, null, n2);
            }
            int n3 = (ID & 0x1FC0) >> 6;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$0, null, n3);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$0, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    static int setLowOrderbits(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int ID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$1, null, n2);
            }
            int n3 = (ID & 0x3F) << 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$1, null, n3);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$1, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    static int getHighOrderbits(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int ID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$2, null, n2);
            }
            int n3 = (ID & 0x7F) << 6;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$2, null, n3);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$2, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    static int getLowOrderbits(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int ID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$3, null, n2);
            }
            int n3 = (ID & 0xFC) >> 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$3, null, n3);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$3, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    DateTimeCommonAccessor(Representation _representation, OracleStatement _statement, int _representationMaxLength, boolean forBind) {
        super(_representation, _statement, _representationMaxLength, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$38, null, _representation, _statement, _representationMaxLength, forBind);
            }
            this.tmpBytes = new byte[this.representationMaxLength];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$38, null);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$38, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$38, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Date getDate(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$4, this, n2);
            }
            Date date = this.getDate((int)currentRow, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$4, this, date);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$4, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Date getDate(int n2, Calendar calendar) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            Date result;
            void cal;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$5, this, n2, calendar);
            }
            if (this.isNull((int)currentRow)) {
                Date date = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$5, this, date);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            Calendar cal2 = cal == null ? this.statement.getDefaultCalendar() : (Calendar)cal.clone();
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            int year = this.oracleYear(this.tmpBytes);
            cal2.clear();
            cal2.set(1, year);
            cal2.set(2, this.oracleMonth(this.tmpBytes));
            cal2.set(5, this.oracleDay(this.tmpBytes));
            if (OracleDriver.getSystemPropertyDateZeroTime()) {
                cal2.set(11, 0);
                cal2.set(12, 0);
                cal2.set(13, 0);
            } else {
                cal2.set(11, this.oracleHour(this.tmpBytes));
                cal2.set(12, this.oracleMin(this.tmpBytes));
                cal2.set(13, this.oracleSec(this.tmpBytes));
            }
            cal2.set(14, 0);
            if (year > 0 && cal2.isSet(0)) {
                cal2.set(0, 1);
            }
            Date date = result = new Date(cal2.getTimeInMillis());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$5, this, date);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$5, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    LocalDate getLocalDate(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$6, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                LocalDate localDate = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$6, this, localDate);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$6, this, null);
                }
                return null;
            }
            for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
                this.tmpBytes[i2] = 0;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            LocalDate localDate = LocalDate.of(this.oracleYear(this.tmpBytes), this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$6, this, localDate);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$6, this, null);
            }
            return localDate;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    LocalDateTime getLocalDateTime(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$7, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                LocalDateTime localDateTime = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$7, this, localDateTime);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$7, this, null);
                }
                return null;
            }
            for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
                this.tmpBytes[i2] = 0;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            LocalDateTime localDateTime = LocalDateTime.of(this.oracleYear(this.tmpBytes), this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes), this.oracleHour(this.tmpBytes), this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), this.tmpBytes.length > 7 ? this.oracleNanos(this.tmpBytes) : 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$7, this, localDateTime);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$7, this, null);
            }
            return localDateTime;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    LocalTime getLocalTime(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$8, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                LocalTime localTime = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$8, this, localTime);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$8, this, null);
                }
                return null;
            }
            for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
                this.tmpBytes[i2] = 0;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            LocalTime localTime = LocalTime.of(this.oracleHour(this.tmpBytes), this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), this.tmpBytes.length > 7 ? this.oracleNanos(this.tmpBytes) : 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$8, this, localTime);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$8, this, null);
            }
            return localTime;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OffsetDateTime getOffsetDateTime(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$9, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                OffsetDateTime offsetDateTime = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$9, this, offsetDateTime);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$9, this, null);
                }
                return null;
            }
            for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
                this.tmpBytes[i2] = 0;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            LocalDateTime ldt = LocalDateTime.of(this.oracleYear(this.tmpBytes), this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes), this.oracleHour(this.tmpBytes), this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), this.tmpBytes.length > 7 ? this.oracleNanos(this.tmpBytes) : 0);
            OffsetDateTime utc = OffsetDateTime.of(ldt, ZoneOffset.UTC);
            if (this.tmpBytes.length > 11) {
                ZoneOffset zoneOffset;
                if ((this.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
                    int regionID = 0;
                    regionID = DateTimeCommonAccessor.getHighOrderbits(this.oracleTZ1(this.tmpBytes));
                    long millis = utc.toInstant().toEpochMilli();
                    TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
                    if (tzTab.checkID(regionID += DateTimeCommonAccessor.getLowOrderbits(this.oracleTZ2(this.tmpBytes)))) {
                        tzTab.updateTable(this.statement.connection, regionID);
                    }
                    int offsetInMillis = tzTab.getOffset(millis, regionID);
                    zoneOffset = ZoneOffset.ofTotalSeconds(offsetInMillis / 1000);
                } else {
                    int offHour = this.oracleTZ1(this.tmpBytes) - OFFSET_HOUR;
                    int offMinute = Math.abs(this.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
                    zoneOffset = ZoneOffset.ofHoursMinutes(offHour, (int)Math.signum(offHour) * offMinute);
                }
                OffsetDateTime offsetDateTime = utc.withOffsetSameInstant(zoneOffset);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$9, this, offsetDateTime);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$9, this, null);
                }
                return offsetDateTime;
            }
            OffsetDateTime offsetDateTime = utc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$9, this, offsetDateTime);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$9, this, null);
            }
            return offsetDateTime;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    OffsetTime getOffsetTime(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$10, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                OffsetTime offsetTime = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$10, this, offsetTime);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$10, this, null);
                }
                return null;
            }
            for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
                this.tmpBytes[i2] = 0;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            LocalTime lt = LocalTime.of(this.oracleHour(this.tmpBytes), this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), this.tmpBytes.length > 7 ? this.oracleNanos(this.tmpBytes) : 0);
            OffsetTime utc = OffsetTime.of(lt, ZoneOffset.UTC);
            if (this.tmpBytes.length > 11) {
                ZoneOffset zoneOffset;
                if ((this.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
                    int regionID = 0;
                    regionID = DateTimeCommonAccessor.getHighOrderbits(this.oracleTZ1(this.tmpBytes));
                    long millis = utc.atDate(LocalDate.now()).toInstant().toEpochMilli();
                    TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
                    if (tzTab.checkID(regionID += DateTimeCommonAccessor.getLowOrderbits(this.oracleTZ2(this.tmpBytes)))) {
                        tzTab.updateTable(this.statement.connection, regionID);
                    }
                    int offsetInMillis = tzTab.getOffset(millis, regionID);
                    zoneOffset = ZoneOffset.ofTotalSeconds(offsetInMillis / 1000);
                } else {
                    int offHour = this.oracleTZ1(this.tmpBytes) - OFFSET_HOUR;
                    int offMinute = Math.abs(this.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
                    zoneOffset = ZoneOffset.ofHoursMinutes(offHour, (int)Math.signum(offHour) * offMinute);
                }
                OffsetTime offsetTime = utc.withOffsetSameInstant(zoneOffset);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$10, this, offsetTime);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$10, this, null);
                }
                return offsetTime;
            }
            OffsetTime offsetTime = utc;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$10, this, offsetTime);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$10, this, null);
            }
            return offsetTime;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    ZonedDateTime getZonedDateTime(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            ZoneId timeZone;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$11, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                ZonedDateTime zonedDateTime = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$11, this, zonedDateTime);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$11, this, null);
                }
                return null;
            }
            for (int i2 = 0; i2 < this.tmpBytes.length; ++i2) {
                this.tmpBytes[i2] = 0;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            LocalDateTime ldt = LocalDateTime.of(this.oracleYear(this.tmpBytes), this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes), this.oracleHour(this.tmpBytes), this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), this.tmpBytes.length > 7 ? this.oracleNanos(this.tmpBytes) : 0);
            OffsetDateTime utc = OffsetDateTime.of(ldt, ZoneOffset.UTC);
            if (this.tmpBytes.length <= 11) {
                timeZone = utc.getOffset();
            } else if ((this.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
                int regionID = DateTimeCommonAccessor.getHighOrderbits(this.oracleTZ1(this.tmpBytes)) + DateTimeCommonAccessor.getLowOrderbits(this.oracleTZ2(this.tmpBytes));
                try {
                    timeZone = ZoneId.of(ZONEIDMAP.getRegion(regionID));
                }
                catch (DateTimeException ignored) {
                    long millis = utc.toInstant().toEpochMilli();
                    TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
                    if (tzTab.checkID(regionID)) {
                        tzTab.updateTable(this.statement.connection, regionID);
                    }
                    int offsetInMillis = tzTab.getOffset(millis, regionID);
                    timeZone = ZoneOffset.ofTotalSeconds(offsetInMillis / 1000);
                }
            } else {
                int offHour = this.oracleTZ1(this.tmpBytes) - OFFSET_HOUR;
                int offMinute = Math.abs(this.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
                timeZone = ZoneOffset.ofHoursMinutes(offHour, (int)Math.signum(offHour) * offMinute);
            }
            ZonedDateTime zonedDateTime = utc.atZoneSameInstant(timeZone);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$11, this, zonedDateTime);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$11, this, null);
            }
            return zonedDateTime;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Time getTime(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$12, this, n2);
            }
            Time result = null;
            if (this.isNull((int)currentRow)) {
                Time time = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$12, this, time);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$12, this, null);
                }
                return null;
            }
            TimeZone zone = this.statement.getDefaultTimeZone();
            if (zone != epochTimeZone) {
                epochTimeZoneOffset = DateTimeCommonAccessor.calculateEpochOffset(zone);
                epochTimeZone = zone;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            Time time = result = new Time((long)this.oracleTime(this.tmpBytes) - epochTimeZoneOffset);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$12, this, time);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$12, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Time getTime(int n2, Calendar calendar) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$13, this, n2, calendar);
            }
            if (this.isNull((int)currentRow)) {
                Time time = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$13, this, time);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$13, this, null);
                }
                return null;
            }
            if (cal == null) {
                Time time = this.getTime((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$13, this, time);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$13, this, null);
                }
                return time;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            int year = this.oracleYear(this.tmpBytes);
            Calendar cal2 = (Calendar)cal.clone();
            cal2.clear();
            cal2.set(1, 1970);
            cal2.set(2, 0);
            cal2.set(5, 1);
            cal2.set(11, this.oracleHour(this.tmpBytes));
            cal2.set(12, this.oracleMin(this.tmpBytes));
            cal2.set(13, this.oracleSec(this.tmpBytes));
            cal2.set(14, 0);
            if (year > 0 && cal2.isSet(0)) {
                cal2.set(0, 1);
            }
            Time time = new Time(cal2.getTimeInMillis());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$13, this, time);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$13, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$14, this, n2);
            }
            Timestamp timestamp = this.getTimestamp((int)currentRow, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$14, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$14, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$15, this, n2, calendar);
            }
            if (this.isNull((int)currentRow)) {
                Timestamp timestamp = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$15, this, timestamp);
                    ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$15, this, null);
                }
                return null;
            }
            Calendar cal2 = cal == null ? this.statement.getDefaultCalendar() : (Calendar)cal.clone();
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            int year = this.oracleYear(this.tmpBytes);
            cal2.clear();
            cal2.set(1, year);
            cal2.set(2, this.oracleMonth(this.tmpBytes));
            cal2.set(5, this.oracleDay(this.tmpBytes));
            cal2.set(11, this.oracleHour(this.tmpBytes));
            cal2.set(12, this.oracleMin(this.tmpBytes));
            cal2.set(13, this.oracleSec(this.tmpBytes));
            cal2.set(14, 0);
            if (year > 0 && cal2.isSet(0)) {
                cal2.set(0, 1);
            }
            Timestamp result = new Timestamp(cal2.getTimeInMillis());
            if (this.getLength((int)currentRow) >= 11) {
                result.setNanos(this.oracleNanos(this.tmpBytes));
            }
            Timestamp timestamp = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$15, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$15, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    DATE getDATE(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$16, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                DATE dATE = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$16, this, dATE);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$16, this, null);
                }
                return null;
            }
            byte[] data = new byte[7];
            this.rowData.get(this.getOffset((int)currentRow), data, 0, 7);
            DATE dATE = new DATE(data);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$16, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$16, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$17, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                TIMESTAMP tIMESTAMP = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$17, this, tIMESTAMP);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$17, this, null);
                }
                return null;
            }
            TIMESTAMP tIMESTAMP = new TIMESTAMP(this.getBytesInternal((int)currentRow));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$17, this, tIMESTAMP);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$17, this, null);
            }
            return tIMESTAMP;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    java.util.Date getJavaUtilDate(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            java.util.Date result;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$18, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                java.util.Date date = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$18, this, date);
                    ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$18, this, null);
                }
                return null;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            int year = this.oracleYear(this.tmpBytes);
            Calendar cal2 = this.statement.getDefaultCalendar();
            cal2.set(1, year);
            cal2.set(2, this.oracleMonth(this.tmpBytes));
            cal2.set(5, this.oracleDay(this.tmpBytes));
            cal2.set(11, this.oracleHour(this.tmpBytes));
            cal2.set(12, this.oracleMin(this.tmpBytes));
            cal2.set(13, this.oracleSec(this.tmpBytes));
            cal2.set(14, 0);
            if (year > 0 && cal2.isSet(0)) {
                cal2.set(0, 1);
            }
            java.util.Date date = result = cal2.getTime();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$18, this, date);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$18, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Calendar getCalendar(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$19, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                Calendar calendar = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$19, this, calendar);
                    ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$19, this, null);
                }
                return null;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            int year = this.oracleYear(this.tmpBytes);
            Calendar cal2 = (Calendar)this.statement.getDefaultCalendar().clone();
            cal2.clear();
            cal2.set(1, year);
            cal2.set(2, this.oracleMonth(this.tmpBytes));
            cal2.set(5, this.oracleDay(this.tmpBytes));
            cal2.set(11, this.oracleHour(this.tmpBytes));
            cal2.set(12, this.oracleMin(this.tmpBytes));
            cal2.set(13, this.oracleSec(this.tmpBytes));
            if (this.getLength((int)currentRow) >= 11) {
                cal2.set(14, this.oracleNanos(this.tmpBytes) / 1000000);
            } else {
                cal2.set(14, 0);
            }
            if (year > 0 && cal2.isSet(0)) {
                cal2.set(0, 1);
            }
            Calendar calendar = cal2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$19, this, calendar);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$19, this, null);
            }
            return calendar;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int oracleYear(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            int year;
            int n2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$20, this, new Object[]{byArray});
            }
            int n3 = n2 = (year = ((bytes[0] & 0xFF) - 100) * 100 + (bytes[1] & 0xFF) - 100) < 0 ? year + 1 : year;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$20, this, n2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$20, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int oracleMonth(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$21, this, new Object[]{byArray});
            }
            void var3_3 = bytes[2] - true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$21, this, (int)var3_3);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$21, this, null);
            }
            return (int)var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int oracleDay(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$22, this, new Object[]{byArray});
            }
            void var3_3 = bytes[3];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$22, this, (int)var3_3);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$22, this, null);
            }
            return (int)var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int oracleHour(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$23, this, new Object[]{byArray});
            }
            void var3_3 = bytes[4] - true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$23, this, (int)var3_3);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$23, this, null);
            }
            return (int)var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int oracleMin(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$24, this, new Object[]{byArray});
            }
            void var3_3 = bytes[5] - true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$24, this, (int)var3_3);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$24, this, null);
            }
            return (int)var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int oracleSec(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$25, this, new Object[]{byArray});
            }
            void var3_3 = bytes[6] - true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$25, this, (int)var3_3);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$25, this, null);
            }
            return (int)var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int oracleTZ1(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$26, this, new Object[]{byArray});
            }
            void var3_3 = bytes[11];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$26, this, (int)var3_3);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$26, this, null);
            }
            return (int)var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int oracleTZ2(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$27, this, new Object[]{byArray});
            }
            void var3_3 = bytes[12];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$27, this, (int)var3_3);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$27, this, null);
            }
            return (int)var3_3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int oracleTime(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$28, this, new Object[]{byArray});
            }
            int millisInDay = this.oracleHour((byte[])bytes);
            millisInDay *= 60;
            millisInDay += this.oracleMin((byte[])bytes);
            millisInDay *= 60;
            millisInDay += this.oracleSec((byte[])bytes);
            int n2 = millisInDay *= 1000;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$28, this, n2);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$28, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int oracleNanos(byte[] byArray) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$29, this, new Object[]{byArray});
            }
            int nanos = (bytes[7] & 0xFF) << 24;
            nanos |= (bytes[8] & 0xFF) << 16;
            nanos |= (bytes[9] & 0xFF) << 8;
            int n2 = nanos |= bytes[10] & 0xFF & 0xFF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$29, this, n2);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$29, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final long computeJulianDay(boolean bl, int n2, int n3, int n4) {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void month;
            void date;
            boolean isGregorian;
            void year;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$30, null, bl, n2, n3, n4);
            }
            boolean isLeap = year % 4 == false;
            void y2 = year - true;
            long julianDay = 365L * (long)y2 + DateTimeCommonAccessor.floorDivide((long)y2, 4L) + 1721423L;
            if (isGregorian) {
                isLeap = isLeap && (year % 100 != false || year % 400 == false);
                julianDay += DateTimeCommonAccessor.floorDivide((long)y2, 400L) - DateTimeCommonAccessor.floorDivide((long)y2, 100L) + 2L;
            }
            long l2 = julianDay + (long)date + (long)(isLeap ? LEAP_NUM_DAYS[month] : NUM_DAYS[month]);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$30, null, l2);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$30, null, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$30, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final long floorDivide(long l2, long l3) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void denominator;
            long numerator;
            long l4;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$31, null, l2, l3);
            }
            long l5 = l4 = numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$31, null, l4);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$31, null, null);
            }
            return l5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    static final long julianDayToMillis(long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            long julian;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$32, null, l2);
            }
            long l3 = (julian - 2440588L) * 86400000L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$32, null, l3);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$32, null, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$32, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static final long zoneOffset(TimeZone timeZone, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void millisInDay;
            void dow;
            void day;
            void month;
            void year;
            TimeZone zone;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$33, null, timeZone, n2, n3, n4, n5, n6);
            }
            long l2 = zone.getOffset(year < 0 ? 0 : 1, (int)year, (int)month, (int)day, (int)dow, (int)millisInDay);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$33, null, l2);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$33, null, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$33, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    static long getMillis(int n2, int n3, int n4, int n5, TimeZone timeZone) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void zone;
            void millisInDay;
            void day;
            void month;
            long julianDay;
            long millis;
            int year;
            boolean isGregorian;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$34, null, n2, n3, n4, n5, timeZone);
            }
            if ((isGregorian = year >= 1582) != (millis = ((julianDay = DateTimeCommonAccessor.computeJulianDay(isGregorian, year, (int)month, (int)day)) - 2440588L) * 86400000L) >= -12219292800000L) {
                julianDay = DateTimeCommonAccessor.computeJulianDay(!isGregorian, year, (int)month, (int)day);
                millis = (julianDay - 2440588L) * 86400000L;
            }
            long l2 = (millis += (long)millisInDay) - DateTimeCommonAccessor.zoneOffset((TimeZone)zone, year, (int)month, (int)day, DateTimeCommonAccessor.julianDayToDayOfWeek(julianDay), (int)millisInDay);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$34, null, l2);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$34, null, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$34, null, throwable2);
            }
            throw throwable;
        }
    }

    static final int julianDayToDayOfWeek(long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            long julian;
            int dayOfWeek;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$35, null, l2);
            }
            int n2 = dayOfWeek + ((dayOfWeek = (int)((julian + 1L) % 7L)) < 0 ? 8 : 1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$35, null, n2);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$35, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    static long calculateEpochOffset(TimeZone timeZone) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            TimeZone zone;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$36, null, timeZone);
            }
            long l2 = DateTimeCommonAccessor.zoneOffset(zone, 1970, 0, 1, 5, 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$36, null, l2);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$36, null, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$36, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String toText(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, String string) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void zone;
            void nanos;
            void sec;
            void min;
            void hour;
            void day;
            void month;
            void year;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$37, this, n2, n3, n4, n5, n6, n7, n8, bl, string);
            }
            String string2 = oracle.sql.TIMESTAMPTZ.toString((int)year, (int)month, (int)day, (int)hour, (int)min, (int)sec, (int)nanos, (String)zone);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$37, this, string2);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$37, this, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DateTimeCommonAccessor.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$38 = DateTimeCommonAccessor.class.getDeclaredConstructor(Representation.class, OracleStatement.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = DateTimeCommonAccessor.class.getDeclaredMethod("toText", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = DateTimeCommonAccessor.class.getDeclaredMethod("calculateEpochOffset", TimeZone.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = DateTimeCommonAccessor.class.getDeclaredMethod("julianDayToDayOfWeek", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = DateTimeCommonAccessor.class.getDeclaredMethod("getMillis", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, TimeZone.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = DateTimeCommonAccessor.class.getDeclaredMethod("zoneOffset", TimeZone.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = DateTimeCommonAccessor.class.getDeclaredMethod("julianDayToMillis", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = DateTimeCommonAccessor.class.getDeclaredMethod("floorDivide", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = DateTimeCommonAccessor.class.getDeclaredMethod("computeJulianDay", Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleNanos", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleTime", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleTZ2", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleTZ1", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleSec", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleMin", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleHour", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleDay", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleMonth", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = DateTimeCommonAccessor.class.getDeclaredMethod("oracleYear", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = DateTimeCommonAccessor.class.getDeclaredMethod("getCalendar", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = DateTimeCommonAccessor.class.getDeclaredMethod("getJavaUtilDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = DateTimeCommonAccessor.class.getDeclaredMethod("getTIMESTAMP", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = DateTimeCommonAccessor.class.getDeclaredMethod("getDATE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = DateTimeCommonAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = DateTimeCommonAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = DateTimeCommonAccessor.class.getDeclaredMethod("getTime", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = DateTimeCommonAccessor.class.getDeclaredMethod("getTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = DateTimeCommonAccessor.class.getDeclaredMethod("getZonedDateTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = DateTimeCommonAccessor.class.getDeclaredMethod("getOffsetTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = DateTimeCommonAccessor.class.getDeclaredMethod("getOffsetDateTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = DateTimeCommonAccessor.class.getDeclaredMethod("getLocalTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = DateTimeCommonAccessor.class.getDeclaredMethod("getLocalDateTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = DateTimeCommonAccessor.class.getDeclaredMethod("getLocalDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = DateTimeCommonAccessor.class.getDeclaredMethod("getDate", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = DateTimeCommonAccessor.class.getDeclaredMethod("getDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = DateTimeCommonAccessor.class.getDeclaredMethod("getLowOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = DateTimeCommonAccessor.class.getDeclaredMethod("getHighOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = DateTimeCommonAccessor.class.getDeclaredMethod("setLowOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = DateTimeCommonAccessor.class.getDeclaredMethod("setHighOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
        OFFSET_HOUR = 20;
        OFFSET_MINUTE = 60;
        REGIONIDBIT = (byte)-128;
    }
}

