/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.dataflow.scope.impl;

import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.dataflow.DFALimitExceededException;
import com.intellij.codeInsight.dataflow.map.DFAMap;
import com.intellij.codeInsight.dataflow.map.DFAMapEngine;
import com.intellij.codeInsight.dataflow.map.DfaMapInstance;
import com.intellij.codeInsight.dataflow.map.MapSemilattice;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.python.PyLanguageFacadeKt;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.PyReachingDefsDfaInstance;
import com.jetbrains.python.codeInsight.dataflow.PyReachingDefsSemilattice;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeVariable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.PyCodeFragmentWithHiddenImports;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyTypeCheckedElementVisitor;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopeImpl
implements Scope {
    private volatile Instruction[] myFlow;
    private volatile List<DFAMap<ScopeVariable>> myCachedScopeVariables;
    private volatile Set<String> myGlobals;
    private volatile Set<String> myNonlocals;
    private volatile List<Scope> myNestedScopes;
    private final ScopeOwner myFlowOwner;
    private volatile Map<String, Collection<PsiNamedElement>> myNamedElements;
    private volatile List<PyImportedNameDefiner> myImportedNameDefiners;
    private volatile Set<String> myAugAssignments;
    private List<PyTargetExpression> myTargetExpressions;

    public ScopeImpl(ScopeOwner flowOwner) {
        this.myFlowOwner = flowOwner;
    }

    private synchronized void computeFlow() {
        if (this.myFlow == null) {
            this.myFlow = ControlFlowCache.getControlFlow(this.myFlowOwner).getInstructions();
        }
    }

    @Override
    public ScopeVariable getDeclaredVariable(@NotNull PsiElement anchorElement, @NotNull String name, @NotNull TypeEvalContext typeEvalContext) throws DFALimitExceededException {
        if (anchorElement == null) {
            ScopeImpl.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ScopeImpl.$$$reportNull$$$0(1);
        }
        if (typeEvalContext == null) {
            ScopeImpl.$$$reportNull$$$0(2);
        }
        this.computeScopeVariables(typeEvalContext);
        for (int i = 0; i < this.myFlow.length; ++i) {
            Instruction instruction = this.myFlow[i];
            PsiElement element = instruction.getElement();
            if (element != anchorElement) continue;
            return (ScopeVariable)this.myCachedScopeVariables.get(i).get(name);
        }
        return null;
    }

    private synchronized void computeScopeVariables(@NotNull TypeEvalContext typeEvalContext) throws DFALimitExceededException {
        if (typeEvalContext == null) {
            ScopeImpl.$$$reportNull$$$0(3);
        }
        this.computeFlow();
        if (this.myCachedScopeVariables == null) {
            PyReachingDefsDfaInstance dfaInstance = new PyReachingDefsDfaInstance(typeEvalContext);
            PyReachingDefsSemilattice semilattice = new PyReachingDefsSemilattice();
            DFAMapEngine engine = new DFAMapEngine(this.myFlow, (DfaMapInstance)dfaInstance, (MapSemilattice)semilattice);
            this.myCachedScopeVariables = engine.performDFA();
        }
    }

    @Override
    public boolean hasGlobals() {
        if (this.myGlobals == null || this.myNestedScopes == null) {
            this.collectDeclarations();
        }
        if (!this.myGlobals.isEmpty()) {
            return true;
        }
        return this.myNestedScopes.stream().anyMatch(scope -> scope.hasGlobals());
    }

    @Override
    public boolean isGlobal(String name) {
        if (this.myGlobals == null || this.myNestedScopes == null) {
            this.collectDeclarations();
        }
        if (this.myGlobals.contains(name)) {
            return true;
        }
        for (Scope scope : this.myNestedScopes) {
            if (!scope.isGlobal(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNonLocals() {
        if (this.myNonlocals == null || this.myNestedScopes == null) {
            this.collectDeclarations();
        }
        if (!this.myNonlocals.isEmpty()) {
            return true;
        }
        return this.myNestedScopes.stream().anyMatch(scope -> scope.hasNonLocals());
    }

    @Override
    public boolean isNonlocal(String name) {
        if (this.myNonlocals == null || this.myNestedScopes == null) {
            this.collectDeclarations();
        }
        return this.myNonlocals.contains(name);
    }

    private boolean isAugAssignment(String name) {
        if (this.myAugAssignments == null || this.myNestedScopes == null) {
            this.collectDeclarations();
        }
        return this.myAugAssignments.contains(name);
    }

    @Override
    public boolean containsDeclaration(String name) {
        if (this.myNamedElements == null || this.myImportedNameDefiners == null) {
            this.collectDeclarations();
        }
        if (this.isNonlocal(name)) {
            return false;
        }
        if (!this.getNamedElements(name, this.myFlowOwner instanceof PyFile).isEmpty()) {
            return true;
        }
        if (this.isAugAssignment(name)) {
            return true;
        }
        for (PyImportedNameDefiner definer : this.getImportedNameDefiners()) {
            if (definer.multiResolveName(name).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<PyImportedNameDefiner> getImportedNameDefiners() {
        if (this.myImportedNameDefiners == null) {
            this.collectDeclarations();
        }
        List<PyImportedNameDefiner> list = this.myImportedNameDefiners;
        if (list == null) {
            ScopeImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<PsiNamedElement> getNamedElements(String name, boolean includeNestedGlobals) {
        if (this.myNamedElements == null || this.myNestedScopes == null) {
            this.collectDeclarations();
        }
        ArrayList<PsiNamedElement> elements = new ArrayList<PsiNamedElement>(this.myNamedElements.getOrDefault(name, List.of()));
        if (includeNestedGlobals) {
            for (Scope scope : this.myNestedScopes) {
                ((ScopeImpl)scope).collectGlobals(name, elements);
            }
        }
        elements.forEach(PyPsiUtils::assertValid);
        ArrayList<PsiNamedElement> arrayList = elements;
        if (arrayList == null) {
            ScopeImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private void collectGlobals(String name, @NotNull Collection<PsiNamedElement> results) {
        if (results == null) {
            ScopeImpl.$$$reportNull$$$0(6);
        }
        if (this.myGlobals == null || this.myNamedElements == null || this.myNestedScopes == null) {
            this.collectDeclarations();
        }
        if (this.myGlobals.contains(name)) {
            results.addAll(this.myNamedElements.getOrDefault(name, List.of()));
        }
        for (Scope scope : this.myNestedScopes) {
            ((ScopeImpl)scope).collectGlobals(name, results);
        }
    }

    @Override
    @NotNull
    public Collection<PsiNamedElement> getNamedElements() {
        if (this.myNamedElements == null) {
            this.collectDeclarations();
        }
        ArrayList<PsiNamedElement> results = new ArrayList<PsiNamedElement>();
        for (Collection<PsiNamedElement> elements : this.myNamedElements.values()) {
            results.addAll(elements);
        }
        ArrayList<PsiNamedElement> arrayList = results;
        if (arrayList == null) {
            ScopeImpl.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<PyTargetExpression> getTargetExpressions() {
        if (this.myTargetExpressions == null) {
            this.collectDeclarations();
        }
        List<PyTargetExpression> list = this.myTargetExpressions;
        if (list == null) {
            ScopeImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<String> getGlobals() {
        if (this.myGlobals == null) {
            this.collectDeclarations();
        }
        Set<String> set = this.myGlobals;
        if (set == null) {
            ScopeImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    private void collectDeclarations() {
        PyClass pyClass;
        LanguageLevel languageLevel;
        final LinkedHashMap<String, Collection<PsiNamedElement>> namedElements = new LinkedHashMap<String, Collection<PsiNamedElement>>();
        final ArrayList<PyImportedNameDefiner> importedNameDefiners = new ArrayList<PyImportedNameDefiner>();
        final ArrayList<Scope> nestedScopes = new ArrayList<Scope>();
        final HashSet<String> globals = new HashSet<String>();
        final HashSet<String> nonlocals = new HashSet<String>();
        final HashSet<String> augAssignments = new HashSet<String>();
        final ArrayList<PyTargetExpression> targetExpressions = new ArrayList<PyTargetExpression>();
        Object object = this.myFlowOwner;
        if (object instanceof PyFile) {
            PyFile pyFile = (PyFile)object;
            languageLevel = PyLanguageFacadeKt.getEffectiveLanguageLevel((PsiFile)pyFile);
        } else {
            object = this.myFlowOwner;
            if (object instanceof PyClass) {
                pyClass = (PyClass)object;
                languageLevel = PyLanguageFacadeKt.getEffectiveLanguageLevel((PsiFile)pyClass.getContainingFile());
            } else {
                languageLevel = null;
            }
        }
        pyClass = this.myFlowOwner;
        if (pyClass instanceof PyCodeFragmentWithHiddenImports) {
            PyCodeFragmentWithHiddenImports fragment = (PyCodeFragmentWithHiddenImports)pyClass;
            List<PyImportStatementBase> pseudoImports = fragment.getPseudoImports();
            for (PyImportStatementBase importStmt : pseudoImports) {
                importStmt.accept((PsiElementVisitor)new PyTypeCheckedElementVisitor(this, languageLevel){

                    public void visitPyElement(@NotNull PyElement node) {
                        if (node == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (node instanceof PyImportedNameDefiner) {
                            PyImportedNameDefiner definer = (PyImportedNameDefiner)node;
                            importedNameDefiners.add(definer);
                        }
                        super.visitPyElement(node);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/codeInsight/dataflow/scope/impl/ScopeImpl$1", "visitPyElement"));
                    }
                });
            }
        }
        this.myFlowOwner.acceptChildren((PsiElementVisitor)new PyTypeCheckedElementVisitor(this, languageLevel){

            public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                targetExpressions.add(node);
                PsiElement parent = node.getParent();
                if (!node.isQualified() && !(parent instanceof PyImportElement)) {
                    super.visitPyTargetExpression(node);
                }
            }

            public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (PyAugAssignmentStatementNavigator.getStatementByTarget((PsiElement)node) != null) {
                    augAssignments.add(node.getName());
                }
                super.visitPyReferenceExpression(node);
            }

            public void visitPyGlobalStatement(@NotNull PyGlobalStatement node) {
                if (node == null) {
                    2.$$$reportNull$$$0(2);
                }
                for (PyTargetExpression expression : node.getGlobals()) {
                    String name = expression.getReferencedName();
                    globals.add(name);
                }
                super.visitPyGlobalStatement(node);
            }

            public void visitPyNonlocalStatement(@NotNull PyNonlocalStatement node) {
                if (node == null) {
                    2.$$$reportNull$$$0(3);
                }
                for (PyTargetExpression expression : node.getVariables()) {
                    nonlocals.add(expression.getReferencedName());
                }
                super.visitPyNonlocalStatement(node);
            }

            public void visitPyFunction(@NotNull PyFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(4);
                }
                for (PyParameter parameter : node.getParameterList().getParameters()) {
                    PyExpression defaultValue = parameter.getDefaultValue();
                    if (defaultValue == null) continue;
                    defaultValue.accept((PsiElementVisitor)this);
                }
                this.visitDecorators(node.getDecoratorList());
                super.visitPyFunction(node);
            }

            public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
                if (node == null) {
                    2.$$$reportNull$$$0(5);
                }
                this.processNamedElement((PsiNamedElement)node);
            }

            public void visitPyClass(@NotNull PyClass node) {
                if (node == null) {
                    2.$$$reportNull$$$0(6);
                }
                this.visitDecorators(node.getDecoratorList());
                super.visitPyClass(node);
            }

            public void visitPyDecoratorList(@NotNull PyDecoratorList node) {
                if (node == null) {
                    2.$$$reportNull$$$0(7);
                }
            }

            public void visitPyElement(@NotNull PyElement node) {
                if (node == null) {
                    2.$$$reportNull$$$0(8);
                }
                if (node instanceof PsiNamedElement && !(node instanceof PyKeywordArgument)) {
                    this.processNamedElement((PsiNamedElement)node);
                }
                if (node instanceof PyImportedNameDefiner) {
                    importedNameDefiners.add((PyImportedNameDefiner)node);
                }
                if (node instanceof ScopeOwner) {
                    Scope scope = ControlFlowCache.getScope((ScopeOwner)node);
                    nestedScopes.add(scope);
                } else {
                    super.visitPyElement(node);
                }
            }

            private void visitDecorators(@Nullable PyDecoratorList list) {
                if (list != null) {
                    for (PyDecorator decorator : list.getDecorators()) {
                        decorator.accept((PsiElementVisitor)this);
                    }
                }
            }

            private void processNamedElement(@NotNull PsiNamedElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(9);
                }
                namedElements.computeIfAbsent(element.getName(), __ -> new LinkedHashSet()).add(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/codeInsight/dataflow/scope/impl/ScopeImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyTargetExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyGlobalStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyNonlocalStatement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyFunction";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyNamedParameter";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyClass";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyDecoratorList";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyElement";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processNamedElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myNamedElements = namedElements;
        this.myImportedNameDefiners = importedNameDefiners;
        this.myNestedScopes = nestedScopes;
        this.myGlobals = globals;
        this.myNonlocals = nonlocals;
        this.myAugAssignments = augAssignments;
        this.myTargetExpressions = targetExpressions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/dataflow/scope/impl/ScopeImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/dataflow/scope/impl/ScopeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedNameDefiners";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedElements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetExpressions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobals";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredVariable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeScopeVariables";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectGlobals";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

