/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.similarity;

import ai.grazie.nlp.similarity.TextDistance;
import ai.grazie.nlp.similarity.TextSimilarity;
import ai.grazie.utils.multiplatform.SafeJsExport;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@SafeJsExport
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u0011\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J*\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lai/grazie/nlp/similarity/Levenshtein;", "Lai/grazie/nlp/similarity/TextDistance;", "Lai/grazie/nlp/similarity/TextSimilarity;", "<init>", "()V", "WithDamerau", "Lai/grazie/nlp/similarity/Levenshtein$DamerauLevenshtein;", "distance", "", "first", "", "second", "similarity", "", "limit", "withTranspositions", "", "DamerauLevenshtein", "Matcher", "nlp-similarity"})
public final class Levenshtein
implements TextDistance,
TextSimilarity {
    @NotNull
    public static final Levenshtein INSTANCE = new Levenshtein();
    @JvmField
    @NotNull
    public static final DamerauLevenshtein WithDamerau = new DamerauLevenshtein();

    private Levenshtein() {
    }

    @Override
    public int distance(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return Levenshtein.distance$default(first, second, Integer.MAX_VALUE, false, 8, null);
    }

    @Override
    public double similarity(@NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return Levenshtein.similarity$default(first, second, Integer.MAX_VALUE, false, 8, null);
    }

    @JvmStatic
    public static final double similarity(@NotNull String first, @NotNull String second, int limit, boolean withTranspositions) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 1.0;
        }
        return 1.0 - (double)Levenshtein.distance(first, second, limit, withTranspositions) / (double)Math.max(first.length(), second.length());
    }

    public static /* synthetic */ double similarity$default(String string, String string2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return Levenshtein.similarity(string, string2, n, bl);
    }

    @JvmStatic
    public static final int distance(@NotNull String first, @NotNull String second, int limit, boolean withTranspositions) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return 0;
        }
        if (Math.abs(first.length() - second.length()) >= limit) {
            return limit;
        }
        if (((CharSequence)first).length() == 0) {
            return second.length();
        }
        if (((CharSequence)second).length() == 0) {
            return first.length();
        }
        Matcher matcher = new Matcher(second, withTranspositions);
        int n = ((CharSequence)first).length();
        for (int i = 0; i < n; ++i) {
            if (matcher.append(first.charAt(i)) < limit) continue;
            return limit;
        }
        return matcher.distance();
    }

    public static /* synthetic */ int distance$default(String string, String string2, int n, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return Levenshtein.distance(string, string2, n, bl);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lai/grazie/nlp/similarity/Levenshtein$DamerauLevenshtein;", "Lai/grazie/nlp/similarity/TextDistance;", "Lai/grazie/nlp/similarity/TextSimilarity;", "<init>", "()V", "distance", "", "first", "", "second", "similarity", "", "nlp-similarity"})
    public static final class DamerauLevenshtein
    implements TextDistance,
    TextSimilarity {
        @Override
        public int distance(@NotNull String first, @NotNull String second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            return Levenshtein.distance(first, second, Integer.MAX_VALUE, true);
        }

        @Override
        public double similarity(@NotNull String first, @NotNull String second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            return Levenshtein.similarity(first, second, Integer.MAX_VALUE, true);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0006\u0010\u001c\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/grazie/nlp/similarity/Levenshtein$Matcher;", "", "pattern", "", "withTranspositions", "", "<init>", "(Ljava/lang/CharSequence;Z)V", "getPattern", "()Ljava/lang/CharSequence;", "getWithTranspositions", "()Z", "vCur", "", "vPrev", "vPrevPrev", "matchedLength", "", "prevChar", "", "append", "c", "fillNextRow", "targetChar", "flipArrays", "", "initPrevVector", "size", "distance", "nlp-similarity"})
    public static final class Matcher {
        @NotNull
        private final CharSequence pattern;
        private final boolean withTranspositions;
        @NotNull
        private int[] vCur;
        @NotNull
        private int[] vPrev;
        @NotNull
        private int[] vPrevPrev;
        private int matchedLength;
        private char prevChar;

        public Matcher(@NotNull CharSequence pattern, boolean withTranspositions) {
            int[] nArray;
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.pattern = pattern;
            this.withTranspositions = withTranspositions;
            this.vCur = new int[this.pattern.length() + 1];
            this.vPrev = this.initPrevVector(this.pattern.length() + 1);
            if (this.withTranspositions) {
                int[] nArray2 = Arrays.copyOf(this.vPrev, this.vPrev.length);
                nArray = nArray2;
                Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
            } else {
                nArray = this.vPrev;
            }
            this.vPrevPrev = nArray;
        }

        @NotNull
        public final CharSequence getPattern() {
            return this.pattern;
        }

        public final boolean getWithTranspositions() {
            return this.withTranspositions;
        }

        public final int append(char c) {
            int minDistance = this.fillNextRow(c);
            this.prevChar = c;
            int n = this.matchedLength;
            this.matchedLength = n + 1;
            this.flipArrays();
            return minDistance;
        }

        private final int fillNextRow(char targetChar) {
            int minCur;
            this.vCur[0] = minCur = this.matchedLength + 1;
            boolean checkTranspositions = this.withTranspositions && this.matchedLength > 0;
            int n = this.pattern.length();
            for (int j = 0; j < n; ++j) {
                char patternChar = this.pattern.charAt(j);
                int cost = targetChar == patternChar ? 0 : 1;
                int cell = Math.min(this.vCur[j] + 1, Math.min(this.vPrev[j + 1] + 1, this.vPrev[j] + cost));
                if (checkTranspositions && j > 0 && this.prevChar == patternChar && targetChar == this.pattern.charAt(j - 1)) {
                    cell = Math.min(cell, this.vPrevPrev[j - 1] + cost);
                }
                this.vCur[j + 1] = cell;
                minCur = Math.min(minCur, cell);
            }
            return minCur;
        }

        private final void flipArrays() {
            int[] vTemp = null;
            if (this.withTranspositions) {
                vTemp = this.vPrevPrev;
                this.vPrevPrev = this.vPrev;
            } else {
                vTemp = this.vPrev;
            }
            this.vPrev = this.vCur;
            this.vCur = vTemp;
        }

        private final int[] initPrevVector(int size) {
            int[] v = new int[size];
            int n = v.length;
            for (int i = 0; i < n; ++i) {
                v[i] = i;
            }
            return v;
        }

        public final int distance() {
            return this.vPrev[this.pattern.length()];
        }
    }
}

