/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.restructuredtext.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.restructuredtext.psi.RestElement;
import com.intellij.restructuredtext.psi.RestReferenceTarget;
import com.intellij.restructuredtext.psi.RestTitle;
import com.intellij.restructuredtext.validation.RestElementVisitor;
import org.jetbrains.annotations.NotNull;

public class RestReference
extends RestElement {
    public RestReference(@NotNull ASTNode node) {
        if (node == null) {
            RestReference.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public String toString() {
        return "RestReference:" + this.getNode().getElementType().toString();
    }

    public String getReferenceText() {
        String text = this.getNode().getText();
        text = StringUtil.replace((String)text, (String)"\n", (String)" ");
        if ((text = text.replaceAll("\\\\([^\\\\]+)", "$1")).startsWith("`") && text.endsWith("`_")) {
            return text.substring(1, text.length() - 2);
        }
        if (text.endsWith("__")) {
            return "__";
        }
        if (text.startsWith("|") && text.endsWith("|")) {
            return text;
        }
        return text.substring(0, text.length() - 1);
    }

    @Override
    protected void acceptRestVisitor(RestElementVisitor visitor) {
        visitor.visitReference(this);
    }

    public RestElement resolve() {
        RestTitle[] titles;
        String name = this.getReferenceText();
        PsiFile file = this.getContainingFile();
        RestReferenceTarget[] elements = (RestReferenceTarget[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestReferenceTarget.class);
        if (elements != null) {
            if (name.equals("__") || name.equals("[*]") || name.equals("[#]")) {
                return this.findAnonimousTarget(file, elements);
            }
            for (RestReferenceTarget element : elements) {
                if (!element.getReferenceName().equalsIgnoreCase(name) && !element.getReferenceName(false).equalsIgnoreCase(name)) continue;
                return element;
            }
        }
        if ((titles = (RestTitle[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestTitle.class)) != null) {
            for (RestTitle element : titles) {
                if (!name.equalsIgnoreCase(element.getName())) continue;
                return element;
            }
        }
        return null;
    }

    private RestReferenceTarget findAnonimousTarget(PsiFile file, RestReferenceTarget[] targets) {
        String name = this.getReferenceText();
        RestReference[] references = (RestReference[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestReference.class);
        int refIndex = 1;
        int i = 0;
        while (!((Object)((Object)references[i])).equals((Object)this)) {
            if (references[i].getReferenceText().equals(name)) {
                ++refIndex;
            }
            ++i;
        }
        int targetIndex = 0;
        for (int j = 0; j != targets.length; ++j) {
            if (targets[j].getReferenceName().equals(name)) {
                ++targetIndex;
            }
            if (targetIndex != refIndex) continue;
            return targets[j];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/restructuredtext/psi/RestReference", "<init>"));
    }
}

