/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeAnyChangeAbstractAdapter;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.jsonSchema.JsonDependencyModificationTracker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaVfsListener
extends BulkVirtualFileListenerAdapter {
    public static final Topic<Runnable> JSON_SCHEMA_CHANGED = Topic.create((String)"JsonSchemaVfsListener.Json.Schema.Changed", Runnable.class);
    public static final Topic<Runnable> JSON_DEPS_CHANGED = Topic.create((String)"JsonSchemaVfsListener.Json.Deps.Changed", Runnable.class);

    @NotNull
    public static JsonSchemaUpdater startListening(@NotNull Project project, @NotNull JsonSchemaService service, @NotNull MessageBusConnection connection) {
        if (project == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(0);
        }
        if (service == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(2);
        }
        final JsonSchemaUpdater updater = new JsonSchemaUpdater(project, service);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new JsonSchemaVfsListener(updater));
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeAnyChangeAbstractAdapter(){

            protected void onChange(@Nullable PsiFile file) {
                if (file != null) {
                    updater.onFileChange(file.getViewProvider().getVirtualFile());
                }
            }
        }, (Disposable)service);
        JsonSchemaUpdater jsonSchemaUpdater = updater;
        if (jsonSchemaUpdater == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(3);
        }
        return jsonSchemaUpdater;
    }

    private JsonSchemaVfsListener(final @NotNull JsonSchemaUpdater updater) {
        if (updater == null) {
            JsonSchemaVfsListener.$$$reportNull$$$0(4);
        }
        super((VirtualFileListener)new VirtualFileContentsChangedAdapter(){
            @NotNull
            private final JsonSchemaUpdater myUpdater;
            {
                this.myUpdater = updater;
            }

            protected void onFileChange(@NotNull VirtualFile schemaFile) {
                if (schemaFile == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.myUpdater.onFileChange(schemaFile);
            }

            protected void onBeforeFileChange(@NotNull VirtualFile schemaFile) {
                if (schemaFile == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.myUpdater.onFileChange(schemaFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "schemaFile";
                objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBeforeFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startListening";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startListening";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static final class JsonSchemaUpdater {
        private static final int DELAY_MS = 200;
        @NotNull
        private final Project myProject;
        private final ZipperUpdater myUpdater;
        @NotNull
        private final JsonSchemaService myService;
        private final Set<VirtualFile> myDirtySchemas;
        private final Runnable myRunnable;
        private final ExecutorService myTaskExecutor;

        private JsonSchemaUpdater(@NotNull Project project, @NotNull JsonSchemaService service) {
            if (project == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(0);
            }
            if (service == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(1);
            }
            this.myDirtySchemas = ConcurrentCollectionFactory.createConcurrentSet();
            this.myTaskExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Json Vfs Updater Executor");
            Disposable disposable = (Disposable)service;
            this.myProject = project;
            this.myUpdater = new ZipperUpdater(200, Alarm.ThreadToUse.POOLED_THREAD, disposable);
            this.myService = service;
            this.myRunnable = () -> {
                if (this.myProject.isDisposed()) {
                    return;
                }
                HashSet<VirtualFile> scope = new HashSet<VirtualFile>(this.myDirtySchemas);
                if (ContainerUtil.exists(scope, f -> service.possiblyHasReference(f.getName()))) {
                    ((Runnable)this.myProject.getMessageBus().syncPublisher(JSON_DEPS_CHANGED)).run();
                    JsonDependencyModificationTracker.forProject(this.myProject).incModificationCount();
                }
                this.myDirtySchemas.removeAll(scope);
                if (scope.isEmpty()) {
                    return;
                }
                List finalScope = ContainerUtil.filter(scope, file -> this.myService.isApplicableToFile((VirtualFile)file) && ((JsonSchemaServiceImpl)this.myService).isMappedSchema((VirtualFile)file, false));
                if (finalScope.isEmpty()) {
                    return;
                }
                if (this.myProject.isDisposed()) {
                    return;
                }
                ((Runnable)this.myProject.getMessageBus().syncPublisher(JSON_SCHEMA_CHANGED)).run();
                DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)project);
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                Editor[] editors = EditorFactory.getInstance().getAllEditors();
                Arrays.stream(editors).filter(editor -> editor instanceof EditorEx && editor.getProject() == this.myProject).map(editor -> editor.getVirtualFile()).filter(file -> file != null && file.isValid()).forEach(file -> {
                    Collection<VirtualFile> schemaFiles = ((JsonSchemaServiceImpl)this.myService).getSchemasForFile((VirtualFile)file, false, true);
                    if (ContainerUtil.exists(schemaFiles, finalScope::contains)) {
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            ReadAction.run(() -> JsonSchemaUpdater.restartAnalyzer(analyzer, psiManager, file));
                        } else {
                            ReadAction.nonBlocking(() -> JsonSchemaUpdater.restartAnalyzer(analyzer, psiManager, file)).expireWith(disposable).submit((Executor)this.myTaskExecutor);
                        }
                    }
                });
            };
        }

        private static void restartAnalyzer(@NotNull DaemonCodeAnalyzer analyzer, @NotNull PsiManager psiManager, @NotNull VirtualFile file) {
            PsiFile psiFile;
            if (analyzer == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(2);
            }
            if (psiManager == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(3);
            }
            if (file == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(4);
            }
            PsiFile psiFile2 = psiFile = !psiManager.isDisposed() && file.isValid() ? psiManager.findFile(file) : null;
            if (psiFile != null) {
                analyzer.restart(psiFile, (Object)"JsonSchemaUpdater");
            }
        }

        private void onFileChange(@NotNull VirtualFile schemaFile) {
            if (schemaFile == null) {
                JsonSchemaUpdater.$$$reportNull$$$0(5);
            }
            if ("json".equals(schemaFile.getExtension())) {
                this.myDirtySchemas.add(schemaFile);
                Application app = ApplicationManager.getApplication();
                if (app.isUnitTestMode()) {
                    app.invokeLater(this.myRunnable, this.myProject.getDisposed());
                } else {
                    this.myUpdater.queue(this.myRunnable);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "analyzer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiManager";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemaFile";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/JsonSchemaVfsListener$JsonSchemaUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restartAnalyzer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFileChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

