/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LongBitmap {
    private LongBitmap() {
    }

    public static long newBitmapBetween(int startInclude, int endExclude) {
        long bitmap = 0L;
        for (int i = startInclude; i < endExclude; ++i) {
            bitmap |= 1L << i;
        }
        return bitmap;
    }

    public static long newBitmap(int value) {
        return 1L << value;
    }

    public static long getBvBitmap(long csg) {
        return (csg & -csg) - 1L;
    }

    public static boolean isSubSet(long maySub, long bigger) {
        return (bigger | maySub) == bigger;
    }

    public static boolean isOverlap(long bitmap1, long bitmap2) {
        return (bitmap1 & bitmap2) != 0L;
    }

    public static long newBitmapFromList(List<Integer> values) {
        long bitmap = 0L;
        for (int value : values) {
            bitmap |= 1L << value;
        }
        return bitmap;
    }

    public static String printBitmap(long bitmap) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        while (bitmap != 0L) {
            sb.append(Long.numberOfTrailingZeros(bitmap)).append(", ");
            bitmap &= bitmap - 1L;
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.append("}");
        return sb.toString();
    }

    public static class SubsetIterator
    implements Iterable<Long> {
        private ArrayList<Long> subsetList;
        private int index;

        public SubsetIterator(long bitmap) {
            long curBiggestSubset = bitmap;
            this.subsetList = new ArrayList();
            while (curBiggestSubset != 0L) {
                this.subsetList.add(curBiggestSubset);
                curBiggestSubset = curBiggestSubset - 1L & bitmap;
            }
            this.index = this.subsetList.size() - 1;
        }

        @Override
        public Iterator<Long> iterator() {
            return new Iterator<Long>(){

                @Override
                public boolean hasNext() {
                    return index >= 0;
                }

                @Override
                public Long next() {
                    return (Long)subsetList.get(index--);
                }
            };
        }

        public void reset() {
            this.index = this.subsetList.size() - 1;
        }
    }

    public static class ReverseIterator
    implements Iterable<Long> {
        private long bitmap;

        public ReverseIterator(long bitmap) {
            this.bitmap = bitmap;
        }

        @Override
        public Iterator<Long> iterator() {
            return new Iterator<Long>(){

                @Override
                public boolean hasNext() {
                    return bitmap != 0L;
                }

                @Override
                public Long next() {
                    long res = Long.highestOneBit(bitmap);
                    bitmap = bitmap & (res ^ 0xFFFFFFFFFFFFFFFFL);
                    return res;
                }
            };
        }
    }
}

