/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.rules;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Generated;
import org.opensearch.sql.calcite.plan.rule.OpenSearchRuleConfig;
import org.opensearch.sql.opensearch.planner.rules.SortExprIndexScanRule;

@ParametersAreNonnullByDefault
@Generated(from="SortExprIndexScanRule", generator="Immutables")
public final class ImmutableSortExprIndexScanRule {
    private ImmutableSortExprIndexScanRule() {
    }

    @CheckReturnValue
    @Generated(from="SortExprIndexScanRule.Config", generator="Immutables")
    @Immutable
    public static final class Config
    implements SortExprIndexScanRule.Config {
        @Nullable
        private final String description;
        private final RelRule.OperandTransform operandSupplier;
        private final RelBuilderFactory relBuilderFactory;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Config(Builder builder) {
            this.description = builder.description;
            if (builder.operandSupplier != null) {
                this.initShim.operandSupplier(builder.operandSupplier);
            }
            if (builder.relBuilderFactory != null) {
                this.initShim.relBuilderFactory(builder.relBuilderFactory);
            }
            this.operandSupplier = this.initShim.operandSupplier();
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.initShim = null;
        }

        private Config(@Nullable String description, RelRule.OperandTransform operandSupplier, RelBuilderFactory relBuilderFactory) {
            this.description = description;
            this.operandSupplier = operandSupplier;
            this.relBuilderFactory = relBuilderFactory;
            this.initShim = null;
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return SortExprIndexScanRule.Config.super.operandSupplier();
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return SortExprIndexScanRule.Config.super.relBuilderFactory();
        }

        @Nullable
        public String description() {
            return this.description;
        }

        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        public final Config withDescription(@Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new Config(value, this.operandSupplier, this.relBuilderFactory);
        }

        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return new Config(this.description, newValue, this.relBuilderFactory);
        }

        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return new Config(this.description, this.operandSupplier, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return Objects.equals(this.description, another.description) && this.operandSupplier.equals((Object)another.operandSupplier) && this.relBuilderFactory.equals((Object)another.relBuilderFactory);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.operandSupplier.hashCode();
            h += (h << 5) + this.relBuilderFactory.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Config").omitNullValues().add("description", (Object)this.description).add("operandSupplier", (Object)this.operandSupplier).add("relBuilderFactory", (Object)this.relBuilderFactory).toString();
        }

        public static Config copyOf(SortExprIndexScanRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SortExprIndexScanRule.Config", generator="Immutables")
        private final class InitShim {
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;

            private InitShim() {
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void operandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void relBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                return "Cannot build Config, attribute initializers form cycle " + String.valueOf(attributes);
            }
        }

        @Generated(from="SortExprIndexScanRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String description;
            @Nullable
            private RelRule.OperandTransform operandSupplier;
            @Nullable
            private RelBuilderFactory relBuilderFactory;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(OpenSearchRuleConfig instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(SortExprIndexScanRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                long bits = 0L;
                if (object instanceof RelRule.Config) {
                    instance = (RelRule.Config)object;
                    if ((bits & 1L) == 0L) {
                        this.relBuilderFactory(instance.relBuilderFactory());
                        bits |= 1L;
                    }
                    this.operandSupplier(instance.operandSupplier());
                    String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.description(descriptionValue);
                    }
                }
                if (object instanceof OpenSearchRuleConfig) {
                    instance = (OpenSearchRuleConfig)object;
                    if ((bits & 1L) == 0L) {
                        this.relBuilderFactory(instance.relBuilderFactory());
                        bits |= 1L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder description(@Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder operandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder relBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }
}

