/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SuggestContext
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, SuggestContext> {
    @Nonnull
    private final String name;
    @Nullable
    private final String path;
    @Nullable
    private final JsonData precision;
    @Nonnull
    private final String type;
    public static final JsonpDeserializer<SuggestContext> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SuggestContext::setupSuggestContextDeserializer);

    private SuggestContext(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.path = builder.path;
        this.precision = builder.precision;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static SuggestContext of(Function<Builder, ObjectBuilder<SuggestContext>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nullable
    public final String path() {
        return this.path;
    }

    @Nullable
    public final JsonData precision() {
        return this.precision;
    }

    @Nonnull
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            this.precision.serialize(generator, mapper);
        }
        generator.writeKey("type");
        generator.write(this.type);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSuggestContextDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::precision, JsonData._DESERIALIZER, "precision");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.path);
        result = 31 * result + Objects.hashCode(this.precision);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggestContext other = (SuggestContext)o;
        return this.name.equals(other.name) && Objects.equals(this.path, other.path) && Objects.equals(this.precision, other.precision) && this.type.equals(other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SuggestContext> {
        private String name;
        @Nullable
        private String path;
        @Nullable
        private JsonData precision;
        private String type;

        public Builder() {
        }

        private Builder(SuggestContext o) {
            this.name = o.name;
            this.path = o.path;
            this.precision = o.precision;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.name = o.name;
            this.path = o.path;
            this.precision = o.precision;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Nonnull
        public final Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Nonnull
        public final Builder precision(@Nullable JsonData value) {
            this.precision = value;
            return this;
        }

        @Nonnull
        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public SuggestContext build() {
            this._checkSingleUse();
            return new SuggestContext(this);
        }
    }
}

