/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.retryfailedmanagedindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.state.ClusterStateRequest;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.get.MultiGetItemResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.index.Index;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService;
import org.opensearch.indexmanagement.indexstatemanagement.IndexMetadataProvider;
import org.opensearch.indexmanagement.indexstatemanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.ISMStatusResponse;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexAction;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.managedIndex.ManagedIndexRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.retryfailedmanagedindex.RetryFailedManagedIndexRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.retryfailedmanagedindex.TransportRetryFailedManagedIndexActionKt;
import org.opensearch.indexmanagement.indexstatemanagement.util.FailedIndex;
import org.opensearch.indexmanagement.indexstatemanagement.util.ManagedIndexUtils;
import org.opensearch.indexmanagement.spi.indexstatemanagement.IndexMetadataService;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ISMIndexMetadata;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.PolicyRetryInfoMetaData;
import org.opensearch.indexmanagement.util.IndexManagementException;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B)\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/retryfailedmanagedindex/TransportRetryFailedManagedIndexAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/retryfailedmanagedindex/RetryFailedManagedIndexRequest;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/ISMStatusResponse;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexMetadataProvider", "Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "<init>", "(Lorg/opensearch/transport/client/node/NodeClient;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;)V", "getClient", "()Lorg/opensearch/transport/client/node/NodeClient;", "getIndexMetadataProvider", "()Lorg/opensearch/indexmanagement/indexstatemanagement/IndexMetadataProvider;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "listener", "Lorg/opensearch/core/action/ActionListener;", "RetryFailedManagedIndexHandler", "opensearch-index-management"})
public final class TransportRetryFailedManagedIndexAction
extends HandledTransportAction<RetryFailedManagedIndexRequest, ISMStatusResponse> {
    @NotNull
    private final NodeClient client;
    @NotNull
    private final IndexMetadataProvider indexMetadataProvider;

    @Inject
    public TransportRetryFailedManagedIndexAction(@NotNull NodeClient client, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @NotNull IndexMetadataProvider indexMetadataProvider) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indexMetadataProvider, (String)"indexMetadataProvider");
        super("cluster:admin/opendistro/ism/managedindex/retry", transportService, actionFilters, RetryFailedManagedIndexRequest::new);
        this.client = client;
        this.indexMetadataProvider = indexMetadataProvider;
    }

    @NotNull
    public final NodeClient getClient() {
        return this.client;
    }

    @NotNull
    public final IndexMetadataProvider getIndexMetadataProvider() {
        return this.indexMetadataProvider;
    }

    protected void doExecute(@NotNull Task task, @NotNull RetryFailedManagedIndexRequest request, @NotNull ActionListener<ISMStatusResponse> listener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        new RetryFailedManagedIndexHandler(this, this.client, listener, request, null, 8, null).start();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020\u001fH\u0002J\b\u0010#\u001a\u00020\u001fH\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\u00020\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00190)H\u0002J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010.\u001a\u00020\u001f2\n\u0010/\u001a\u000600j\u0002`1R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u00130\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00140\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001d0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/retryfailedmanagedindex/TransportRetryFailedManagedIndexAction$RetryFailedManagedIndexHandler;", "", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/ISMStatusResponse;", "request", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/retryfailedmanagedindex/RetryFailedManagedIndexRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "<init>", "(Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/retryfailedmanagedindex/TransportRetryFailedManagedIndexAction;Lorg/opensearch/transport/client/node/NodeClient;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/retryfailedmanagedindex/RetryFailedManagedIndexRequest;Lorg/opensearch/commons/authuser/User;)V", "failedIndices", "", "Lorg/opensearch/indexmanagement/indexstatemanagement/util/FailedIndex;", "listOfMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "listOfIndexToMetadata", "Lkotlin/Pair;", "Lorg/opensearch/core/index/Index;", "mapOfItemIdToIndex", "", "", "indicesManagedState", "", "", "indicesToRetry", "indexUuidToIndexMetadata", "Lorg/opensearch/cluster/metadata/IndexMetadata;", "start", "", "validateAndGetIndicesToRetry", "getIndicesToRetry", "getClusterState", "processResponse", "onMgetMetadataResponse", "mgetResponse", "Lorg/opensearch/action/get/MultiGetResponse;", "bulkEnableJob", "jobDocIds", "", "onEnableJobBulkResponse", "bulkResponse", "Lorg/opensearch/action/bulk/BulkResponse;", "onBulkUpdateMetadataResponse", "onFailure", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nTransportRetryFailedManagedIndexAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportRetryFailedManagedIndexAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/transport/action/retryfailedmanagedindex/TransportRetryFailedManagedIndexAction$RetryFailedManagedIndexHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,339:1\n37#2:340\n36#2,3:341\n37#2:344\n36#2,3:345\n126#3:348\n153#3,3:349\n216#3,2:354\n1869#4,2:352\n1563#4:356\n1634#4,3:357\n1563#4:360\n1634#4,3:361\n230#4,2:364\n1878#4,3:366\n1563#4:369\n1634#4,3:370\n1869#4,2:376\n1563#4:378\n1634#4,3:379\n3829#5:373\n4344#5,2:374\n*S KotlinDebug\n*F\n+ 1 TransportRetryFailedManagedIndexAction.kt\norg/opensearch/indexmanagement/indexstatemanagement/transport/action/retryfailedmanagedindex/TransportRetryFailedManagedIndexAction$RetryFailedManagedIndexHandler\n*L\n106#1:340\n106#1:341,3\n159#1:344\n159#1:345,3\n190#1:348\n190#1:349,3\n227#1:354,2\n190#1:352,2\n250#1:356\n250#1:357,3\n257#1:360\n257#1:361,3\n265#1:364,2\n291#1:366,3\n296#1:369\n296#1:370,3\n310#1:376,2\n325#1:378\n325#1:379,3\n309#1:373\n309#1:374,2\n*E\n"})
    public final class RetryFailedManagedIndexHandler {
        @NotNull
        private final NodeClient client;
        @NotNull
        private final ActionListener<ISMStatusResponse> actionListener;
        @NotNull
        private final RetryFailedManagedIndexRequest request;
        @Nullable
        private final User user;
        @NotNull
        private final List<FailedIndex> failedIndices;
        @NotNull
        private final List<ManagedIndexMetaData> listOfMetadata;
        @NotNull
        private final List<Pair<Index, ManagedIndexMetaData>> listOfIndexToMetadata;
        @NotNull
        private final Map<Integer, Index> mapOfItemIdToIndex;
        @NotNull
        private final Map<String, Boolean> indicesManagedState;
        @NotNull
        private Map<String, String> indicesToRetry;
        @NotNull
        private final Map<String, IndexMetadata> indexUuidToIndexMetadata;
        final /* synthetic */ TransportRetryFailedManagedIndexAction this$0;

        public RetryFailedManagedIndexHandler(@NotNull TransportRetryFailedManagedIndexAction this$0, @NotNull NodeClient client, @NotNull ActionListener<ISMStatusResponse> actionListener, @Nullable RetryFailedManagedIndexRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.this$0 = this$0;
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
            this.failedIndices = new ArrayList();
            this.listOfMetadata = new ArrayList();
            this.listOfIndexToMetadata = new ArrayList();
            this.mapOfItemIdToIndex = new LinkedHashMap();
            this.indicesManagedState = new LinkedHashMap();
            this.indicesToRetry = new LinkedHashMap();
            this.indexUuidToIndexMetadata = new LinkedHashMap();
        }

        public /* synthetic */ RetryFailedManagedIndexHandler(TransportRetryFailedManagedIndexAction transportRetryFailedManagedIndexAction, NodeClient nodeClient, ActionListener actionListener, RetryFailedManagedIndexRequest retryFailedManagedIndexRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = nodeClient.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"getThreadContext(...)");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            this(transportRetryFailedManagedIndexAction, nodeClient, (ActionListener<ISMStatusResponse>)actionListener, retryFailedManagedIndexRequest, user);
        }

        public final void start() {
            TransportRetryFailedManagedIndexActionKt.access$getLog$p().debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            if (this.user == null) {
                this.getIndicesToRetry();
            } else {
                this.validateAndGetIndicesToRetry();
            }
        }

        private final void validateAndGetIndicesToRetry() {
            Collection $this$toTypedArray$iv = this.request.getIndices();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            ManagedIndexRequest managedIndexRequest = (ManagedIndexRequest)new ManagedIndexRequest(new String[0]).indices(Arrays.copyOf(stringArray, stringArray.length));
            this.client.execute((ActionType)ManagedIndexAction.Companion.getINSTANCE(), (ActionRequest)managedIndexRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(this){
                final /* synthetic */ RetryFailedManagedIndexHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onResponse(AcknowledgedResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    RetryFailedManagedIndexHandler.access$getIndicesToRetry(this.this$0);
                }

                public void onFailure(Exception e) {
                    Exception exception;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ActionListener actionListener = RetryFailedManagedIndexHandler.access$getActionListener$p(this.this$0);
                    boolean bl = e instanceof OpenSearchSecurityException;
                    if (bl) {
                        exception = (Exception)((Object)new OpenSearchStatusException("User doesn't have required index permissions on one or more requested indices: " + ((OpenSearchSecurityException)((Object)e)).getLocalizedMessage(), RestStatus.FORBIDDEN, new Object[0]));
                    } else if (!bl) {
                        exception = e;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    actionListener.onFailure((Exception)((Object)IndexManagementException.Companion.wrap(exception)));
                }
            });
        }

        private final void getIndicesToRetry() {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransportRetryFailedManagedIndexAction this$0;
                final /* synthetic */ RetryFailedManagedIndexHandler this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            indexNameToMetadata = new HashMap<K, V>();
                            var12_4 = indexNameToMetadata;
                            this.L$0 = indexNameToMetadata;
                            this.L$1 = var12_4;
                            this.label = 1;
                            v0 = this.this$0.getIndexMetadataProvider().getISMIndexMetadataByType(RetryFailedManagedIndexHandler.access$getRequest$p(this.this$1).getIndexType(), RetryFailedManagedIndexHandler.access$getRequest$p(this.this$1).getIndices(), (Continuation<? super Map<String, ISMIndexMetadata>>)((Continuation)this));
                            ** if (v0 != var13_2) goto lbl15
lbl14:
                            // 1 sources

                            return var13_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl23
                        }
                        case 1: {
                            var12_4 = (Map)this.L$1;
                            indexNameToMetadata = (Map)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl23:
                                // 2 sources

                                var12_4.putAll((Map)v0);
                            }
                            catch (Exception e) {
                                v1 = RetryFailedManagedIndexHandler.access$getActionListener$p(this.this$1);
                                v2 = ExceptionsHelper.unwrapCause((Throwable)e);
                                Intrinsics.checkNotNull((Object)v2, (String)"null cannot be cast to non-null type java.lang.Exception");
                                v1.onFailure((Exception)v2);
                                return Unit.INSTANCE;
                            }
                            e = indexNameToMetadata;
                            var4_7 = this.this$1;
                            $i$f$forEach = false;
                            var6_9 = $this$forEach$iv.entrySet().iterator();
                            while (var6_9.hasNext()) {
                                var8_11 = element$iv = var6_9.next();
                                $i$a$-forEach-TransportRetryFailedManagedIndexAction$RetryFailedManagedIndexHandler$getIndicesToRetry$1$1 = false;
                                indexName = (String)var8_11.getKey();
                                indexMetadata = (ISMIndexMetadata)var8_11.getValue();
                                RetryFailedManagedIndexHandler.access$getIndicesToRetry$p(var4_7).putIfAbsent(indexMetadata.getIndexUuid(), indexName);
                            }
                            if (Intrinsics.areEqual((Object)RetryFailedManagedIndexHandler.access$getRequest$p(this.this$1).getIndexType(), (Object)"_default")) {
                                RetryFailedManagedIndexHandler.access$getClusterState(this.this$1);
                            } else {
                                RetryFailedManagedIndexHandler.access$processResponse(this.this$1);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void getClusterState() {
            IndicesOptions strictExpandIndicesOptions = IndicesOptions.strictExpand();
            ClusterStateRequest clusterStateRequest = new ClusterStateRequest();
            Collection $this$toTypedArray$iv = this.request.getIndices();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object object = thisCollection$iv.toArray(new String[0]);
            ((ClusterStateRequest)((ClusterStateRequest)clusterStateRequest.clear().indices(Arrays.copyOf(object, ((String[])object).length)).metadata(true).local(false)).clusterManagerNodeTimeout(this.request.getClusterManagerTimeout())).indicesOptions(strictExpandIndicesOptions);
            object = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            TransportRetryFailedManagedIndexAction transportRetryFailedManagedIndexAction = this.this$0;
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)object;
                boolean bl = false;
                this.client.admin().cluster().state(clusterStateRequest, (ActionListener)new ActionListener<ClusterStateResponse>(transportRetryFailedManagedIndexAction, this){
                    final /* synthetic */ TransportRetryFailedManagedIndexAction this$0;
                    final /* synthetic */ RetryFailedManagedIndexHandler this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void onResponse(ClusterStateResponse response2) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                        IndexMetadataService indexMetadataService = this.this$0.getIndexMetadataProvider().getServices().get("_default");
                        Intrinsics.checkNotNull((Object)indexMetadataService, (String)"null cannot be cast to non-null type org.opensearch.indexmanagement.indexstatemanagement.DefaultIndexMetadataService");
                        DefaultIndexMetadataService defaultIndexMetadataService = (DefaultIndexMetadataService)indexMetadataService;
                        Map map = response2.getState().getMetadata().getIndices();
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getIndices(...)");
                        Map map2 = map;
                        RetryFailedManagedIndexHandler retryFailedManagedIndexHandler = this.this$1;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> it = element$iv = iterator.next();
                            boolean bl = false;
                            V v = it.getValue();
                            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                            String indexUUID = defaultIndexMetadataService.getIndexUUID((IndexMetadata)v);
                            RetryFailedManagedIndexHandler.access$getIndexUuidToIndexMetadata$p(retryFailedManagedIndexHandler).put(indexUUID, it.getValue());
                        }
                        RetryFailedManagedIndexHandler.access$processResponse(this.this$1);
                    }

                    public void onFailure(Exception t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        ActionListener actionListener = RetryFailedManagedIndexHandler.access$getActionListener$p(this.this$1);
                        Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                        Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
                        actionListener.onFailure((Exception)throwable);
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processResponse() {
            void $this$mapTo$iv$iv;
            MultiGetRequest mReq = new MultiGetRequest();
            Map<String, String> $this$map$iv = this.indicesToRetry;
            boolean $i$f$map = false;
            Map<String, String> map = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((String)it.getKey());
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                mReq.add(".opendistro-ism-config", it);
            }
            this.client.multiGet(mReq, (ActionListener)new ActionListener<MultiGetResponse>(this){
                final /* synthetic */ RetryFailedManagedIndexHandler this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onResponse(MultiGetResponse response2) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    MultiGetItemResponse[] multiGetItemResponseArray = response2.getResponses();
                    Intrinsics.checkNotNullExpressionValue((Object)multiGetItemResponseArray, (String)"getResponses(...)");
                    MultiGetItemResponse f = (MultiGetItemResponse)ArraysKt.first((Object[])multiGetItemResponseArray);
                    if (f.isFailed() && f.getFailure().getFailure() instanceof IndexNotFoundException) {
                        void $this$forEach$iv;
                        Map map = RetryFailedManagedIndexHandler.access$getIndicesToRetry$p(this.this$0);
                        RetryFailedManagedIndexHandler retryFailedManagedIndexHandler = this.this$0;
                        boolean $i$f$forEach = false;
                        Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> entry = element$iv = iterator.next();
                            boolean bl = false;
                            String uuid = (String)entry.getKey();
                            String name = (String)entry.getValue();
                            RetryFailedManagedIndexHandler.access$getFailedIndices$p(retryFailedManagedIndexHandler).add(new FailedIndex(name, uuid, "This index is not being managed."));
                        }
                        RetryFailedManagedIndexHandler.access$getActionListener$p(this.this$0).onResponse((Object)((Object)new ISMStatusResponse(0, RetryFailedManagedIndexHandler.access$getFailedIndices$p(this.this$0))));
                        return;
                    }
                    Iterable $this$forEach$iv = (Iterable)response2;
                    RetryFailedManagedIndexHandler retryFailedManagedIndexHandler = this.this$0;
                    boolean $i$f$forEach22 = false;
                    for (T element$iv : $this$forEach$iv) {
                        MultiGetItemResponse it = (MultiGetItemResponse)element$iv;
                        boolean bl = false;
                        RetryFailedManagedIndexHandler.access$getIndicesManagedState$p(retryFailedManagedIndexHandler).put(it.getId(), it.getResponse().isExists());
                    }
                    $this$forEach$iv = MapsKt.toList((Map)RetryFailedManagedIndexHandler.access$getIndicesToRetry$p(this.this$0));
                    NodeClient nodeClient = RetryFailedManagedIndexHandler.access$getClient$p(this.this$0);
                    boolean $i$f$map = false;
                    void $i$f$forEach22 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair uuid = (Pair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((String)it.getFirst());
                    }
                    nodeClient.multiGet(OpenSearchExtensionsKt.buildMgetMetadataRequest((List)destination$iv$iv), ActionListener.wrap(arg_0 -> RetryFailedManagedIndexHandler.access$onMgetMetadataResponse(this.this$0, arg_0), this::onFailure));
                }

                public void onFailure(Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    ActionListener actionListener = RetryFailedManagedIndexHandler.access$getActionListener$p(this.this$0);
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
                    actionListener.onFailure((Exception)throwable);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void onMgetMetadataResponse(MultiGetResponse mgetResponse) {
            String indexName;
            Map<String, Pair<ManagedIndexMetaData, Exception>> metadataMap = OpenSearchExtensionsKt.mgetResponseToMap(mgetResponse);
            Object $this$forEach$iv = this.indicesToRetry;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl = false;
                String indexUuid = entry.getKey();
                indexName = entry.getValue();
                Pair<ManagedIndexMetaData, Exception> pair = metadataMap.get(ManagedIndexUtils.managedIndexMetadataID(indexUuid));
                Exception mgetFailure = pair != null ? (Exception)pair.getSecond() : null;
                Pair<ManagedIndexMetaData, Exception> pair2 = metadataMap.get(ManagedIndexUtils.managedIndexMetadataID(indexUuid));
                ManagedIndexMetaData managedIndexMetadata = pair2 != null ? (ManagedIndexMetaData)pair2.getFirst() : null;
                boolean bl2 = Intrinsics.areEqual((Object)this.indicesManagedState.get(indexUuid), (Object)false) ? this.failedIndices.add(new FailedIndex(indexName, indexUuid, "This index is not being managed.")) : (mgetFailure != null ? this.failedIndices.add(new FailedIndex(indexName, indexUuid, "Failed to get managed index metadata, " + mgetFailure)) : (managedIndexMetadata == null ? this.failedIndices.add(new FailedIndex(indexName, indexUuid, "This index has no metadata information")) : (!ManagedIndexUtils.isFailed(managedIndexMetadata) ? this.failedIndices.add(new FailedIndex(indexName, indexUuid, "This index is not in failed state.")) : this.listOfMetadata.add(managedIndexMetadata))));
            }
            if (!((Collection)this.listOfMetadata).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$forEach$iv = this.listOfMetadata;
                RetryFailedManagedIndexHandler retryFailedManagedIndexHandler = this;
                boolean $i$f$map = false;
                iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    indexName = (ManagedIndexMetaData)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getIndexUuid());
                }
                retryFailedManagedIndexHandler.bulkEnableJob((List)destination$iv$iv);
            } else {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void bulkEnableJob(List<String> jobDocIds) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = jobDocIds;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ManagedIndexUtils.updateEnableManagedIndexRequest((String)it));
            }
            List requestsToRetry = (List)destination$iv$iv;
            BulkRequest bulkRequest = new BulkRequest().add((Iterable)requestsToRetry);
            this.client.bulk(bulkRequest, ActionListener.wrap(this::onEnableJobBulkResponse, this::onFailure));
        }

        /*
         * WARNING - void declaration
         */
        private final void onEnableJobBulkResponse(BulkResponse bulkResponse) {
            Object object;
            Object $this$first$iv;
            Iterator iterator = bulkResponse.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                boolean bl;
                Object element$iv;
                Object object2;
                BulkItemResponse bulkItemResponse;
                block8: {
                    bulkItemResponse = (BulkItemResponse)iterator2.next();
                    $this$first$iv = this.listOfMetadata;
                    boolean $i$f$first = false;
                    object2 = $this$first$iv.iterator();
                    while (object2.hasNext()) {
                        element$iv = object2.next();
                        ManagedIndexMetaData it = (ManagedIndexMetaData)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getIndexUuid(), (Object)bulkItemResponse.getId())) continue;
                        break block8;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                ManagedIndexMetaData managedIndexMetaData = (ManagedIndexMetaData)element$iv;
                if (bulkItemResponse.isFailed()) {
                    String string = managedIndexMetaData.getIndex();
                    String string2 = managedIndexMetaData.getIndexUuid();
                    String string3 = bulkItemResponse.getFailureMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFailureMessage(...)");
                    bl = this.failedIndices.add(new FailedIndex(string, string2, string3));
                    continue;
                }
                $this$first$iv = new PolicyRetryInfoMetaData(false, 0);
                ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
                ActionMetaData $i$f$first = actionMetaData != null ? ActionMetaData.copy$default((ActionMetaData)actionMetaData, null, null, (int)0, (boolean)false, (int)0, null, null, (int)69, null) : null;
                object2 = this.request.getStartState();
                object = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)"Pending retry of failed managed index"));
                bl = this.listOfIndexToMetadata.add((Pair<Index, ManagedIndexMetaData>)new Pair((Object)new Index(managedIndexMetaData.getIndex(), managedIndexMetaData.getIndexUuid()), (Object)ManagedIndexMetaData.copy$default((ManagedIndexMetaData)managedIndexMetaData, null, null, null, null, null, null, null, null, (String)object2, null, (ActionMetaData)$i$f$first, null, (PolicyRetryInfoMetaData)$this$first$iv, (Map)object, null, (long)0L, (long)0L, null, (int)246527, null)));
            }
            if (!((Collection)this.listOfIndexToMetadata).isEmpty()) {
                void $this$mapTo$iv$iv;
                Iterable $this$forEachIndexed$iv = this.listOfIndexToMetadata;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    object = (Pair)item$iv;
                    int ind = n;
                    boolean bl = false;
                    Index index2 = (Index)object.component1();
                    this.mapOfItemIdToIndex.put(ind, index2);
                }
                Iterable $this$map$iv = this.listOfIndexToMetadata;
                boolean $i$f$map = false;
                $this$first$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Index index3 = (Index)pair.component1();
                    ManagedIndexMetaData metadata2 = (ManagedIndexMetaData)pair.component2();
                    XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
                    Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
                    ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                    Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                    XContentBuilder builder = metadata2.toXContent(xContentBuilder, params, true);
                    String string = index3.getUUID();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUUID(...)");
                    collection.add(new UpdateRequest(".opendistro-ism-config", ManagedIndexUtils.managedIndexMetadataID(string)).routing(index3.getUUID()).doc(builder));
                }
                List updateMetadataRequests = (List)destination$iv$iv;
                BulkRequest bulkUpdateMetadataRequest = new BulkRequest().add((Iterable)updateMetadataRequests);
                this.client.bulk(bulkUpdateMetadataRequest, ActionListener.wrap(this::onBulkUpdateMetadataResponse, this::onFailure));
            } else {
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void onBulkUpdateMetadataResponse(BulkResponse bulkResponse) {
            void $this$filterTo$iv$iv;
            BulkItemResponse[] bulkItemResponseArray = bulkResponse.getItems();
            if (bulkItemResponseArray == null) {
                bulkItemResponseArray = new BulkItemResponse[]{};
            }
            BulkItemResponse[] $this$filter$iv = bulkItemResponseArray;
            boolean $i$f$filter = false;
            BulkItemResponse[] bulkItemResponseArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.isFailed()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List failedResponses = (List)destination$iv$iv;
            Iterable $this$forEach$iv = failedResponses;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BulkItemResponse it = (BulkItemResponse)element$iv;
                boolean bl = false;
                Index index2 = this.mapOfItemIdToIndex.get(it.getItemId());
                if (index2 == null) continue;
                String string = index2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = index2.getUUID();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUUID(...)");
                this.failedIndices.add(new FailedIndex(string, string2, "Failed to update metadata for index " + index2.getName()));
            }
            BulkItemResponse[] bulkItemResponseArray3 = bulkResponse.getItems();
            if (bulkItemResponseArray3 == null) {
                bulkItemResponseArray3 = new BulkItemResponse[]{};
            }
            int updated = bulkItemResponseArray3.length - failedResponses.size();
            this.actionListener.onResponse((Object)new ISMStatusResponse(updated, this.failedIndices));
        }

        /*
         * WARNING - void declaration
         */
        public final void onFailure(@NotNull Exception e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            try {
                if (e instanceof ClusterBlockException) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = this.listOfIndexToMetadata;
                    List<FailedIndex> list = this.failedIndices;
                    boolean $i$f$map = false;
                    void var4_6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string = ((Index)it.getFirst()).getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String string2 = ((Index)it.getFirst()).getUUID();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUUID(...)");
                        collection.add(new FailedIndex(string, string2, "Failed to update due to ClusterBlockException. " + e.getMessage()));
                    }
                    list.addAll((List)destination$iv$iv);
                }
                this.actionListener.onResponse((Object)new ISMStatusResponse(0, this.failedIndices));
            }
            catch (Exception inner) {
                ExceptionsKt.addSuppressed((Throwable)inner, (Throwable)e);
                TransportRetryFailedManagedIndexActionKt.access$getLog$p().error("Failed to send failure response", (Throwable)inner);
            }
        }

        public static final /* synthetic */ void access$getIndicesToRetry(RetryFailedManagedIndexHandler $this) {
            $this.getIndicesToRetry();
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(RetryFailedManagedIndexHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ RetryFailedManagedIndexRequest access$getRequest$p(RetryFailedManagedIndexHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ void access$getClusterState(RetryFailedManagedIndexHandler $this) {
            $this.getClusterState();
        }

        public static final /* synthetic */ void access$processResponse(RetryFailedManagedIndexHandler $this) {
            $this.processResponse();
        }

        public static final /* synthetic */ Map access$getIndicesToRetry$p(RetryFailedManagedIndexHandler $this) {
            return $this.indicesToRetry;
        }

        public static final /* synthetic */ List access$getFailedIndices$p(RetryFailedManagedIndexHandler $this) {
            return $this.failedIndices;
        }

        public static final /* synthetic */ NodeClient access$getClient$p(RetryFailedManagedIndexHandler $this) {
            return $this.client;
        }

        public static final /* synthetic */ void access$onMgetMetadataResponse(RetryFailedManagedIndexHandler $this, MultiGetResponse mgetResponse) {
            $this.onMgetMetadataResponse(mgetResponse);
        }

        public static final /* synthetic */ Map access$getIndicesManagedState$p(RetryFailedManagedIndexHandler $this) {
            return $this.indicesManagedState;
        }

        public static final /* synthetic */ Map access$getIndexUuidToIndexMetadata$p(RetryFailedManagedIndexHandler $this) {
            return $this.indexUuidToIndexMetadata;
        }
    }
}

