/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.repository;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.store.IndexInput;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.single.shard.SingleShardRequest;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.inject.Singleton;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.lucene.store.InputStreamIndexInput;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.store.Store;
import org.opensearch.indices.IndicesService;
import org.opensearch.replication.action.repository.RemoteClusterRepositoryRequest;
import org.opensearch.replication.repository.RemoteClusterRestoreLeaderService;
import org.opensearch.replication.repository.RestoreContext;
import org.opensearch.replication.seqno.RemoteClusterRetentionLeaseHelper;
import org.opensearch.replication.util.ExtensionsKt;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;

@Singleton
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\b\u0010\u0012\u001a\u00020\u0010H\u0014J.\u0010\u0013\u001a\u00020\u000b\"\u0010\b\u0000\u0010\u0014*\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\nH\u0002J>\u0010\u001a\u001a\u00020\u001b\"\u0010\b\u0000\u0010\u0014*\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00182\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ0\u0010\u001f\u001a\u00020\u000b\"\u0010\b\u0000\u0010\u0014*\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\n2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0018H\u0002J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/opensearch/replication/repository/RemoteClusterRestoreLeaderService;", "Lorg/opensearch/common/lifecycle/AbstractLifecycleComponent;", "indicesService", "Lorg/opensearch/indices/IndicesService;", "nodeClient", "Lorg/opensearch/transport/client/node/NodeClient;", "<init>", "(Lorg/opensearch/indices/IndicesService;Lorg/opensearch/transport/client/node/NodeClient;)V", "onGoingRestores", "", "", "Lorg/opensearch/replication/repository/RestoreContext;", "closableResources", "", "Ljava/io/Closeable;", "doStart", "", "doStop", "doClose", "addLeaderClusterRestore", "T", "Lorg/opensearch/action/support/single/shard/SingleShardRequest;", "restoreUUID", "request", "Lorg/opensearch/replication/action/repository/RemoteClusterRepositoryRequest;", "getLeaderClusterRestore", "openInputStream", "Lorg/opensearch/common/lucene/store/InputStreamIndexInput;", "fileName", "length", "", "constructRestoreContext", "removeLeaderClusterRestore", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nRemoteClusterRestoreLeaderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteClusterRestoreLeaderService.kt\norg/opensearch/replication/repository/RemoteClusterRestoreLeaderService\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,145:1\n382#2,7:146\n*S KotlinDebug\n*F\n+ 1 RemoteClusterRestoreLeaderService.kt\norg/opensearch/replication/repository/RemoteClusterRestoreLeaderService\n*L\n60#1:146,7\n*E\n"})
public final class RemoteClusterRestoreLeaderService
extends AbstractLifecycleComponent {
    @NotNull
    private final IndicesService indicesService;
    @NotNull
    private final NodeClient nodeClient;
    @NotNull
    private final Map<String, RestoreContext> onGoingRestores;
    @NotNull
    private final List<Closeable> closableResources;

    @Inject
    public RemoteClusterRestoreLeaderService(@NotNull IndicesService indicesService, @NotNull NodeClient nodeClient) {
        Intrinsics.checkNotNullParameter((Object)indicesService, (String)"indicesService");
        Intrinsics.checkNotNullParameter((Object)nodeClient, (String)"nodeClient");
        this.indicesService = indicesService;
        this.nodeClient = nodeClient;
        this.onGoingRestores = new LinkedHashMap();
        this.closableResources = new ArrayList();
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
        IOUtils.close((Iterable)this.closableResources);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized <T extends SingleShardRequest<T>> RestoreContext addLeaderClusterRestore(@NotNull String restoreUUID, @NotNull RemoteClusterRepositoryRequest<T> request) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)restoreUUID, (String)"restoreUUID");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Map<String, RestoreContext> map = this.onGoingRestores;
        String key$iv = restoreUUID;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            RestoreContext answer$iv = this.constructRestoreContext(restoreUUID, request);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (RestoreContext)object;
    }

    private final RestoreContext getLeaderClusterRestore(String restoreUUID) {
        RestoreContext restoreContext = this.onGoingRestores.get(restoreUUID);
        if (restoreContext == null) {
            throw new IllegalStateException("missing restoreContext");
        }
        return restoreContext;
    }

    @NotNull
    public final synchronized <T extends SingleShardRequest<T>> InputStreamIndexInput openInputStream(@NotNull String restoreUUID, @NotNull RemoteClusterRepositoryRequest<T> request, @NotNull String fileName, long length) {
        Intrinsics.checkNotNullParameter((Object)restoreUUID, (String)"restoreUUID");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        IndexShard indexShard = (IndexShard)this.indicesService.getShardOrNull(request.getLeaderShardId());
        if (indexShard == null) {
            throw new OpenSearchException("Shard [" + request + ".leaderShardId] missing", new Object[0]);
        }
        IndexShard leaderIndexShard = indexShard;
        Store store = leaderIndexShard.store();
        RestoreContext restoreContext = this.getLeaderClusterRestore(restoreUUID);
        Intrinsics.checkNotNull((Object)store);
        IndexInput indexInput = restoreContext.openInput(store, fileName);
        return new InputStreamIndexInput(indexInput, length){
            final /* synthetic */ IndexInput $indexInput;
            {
                this.$indexInput = $indexInput;
                super($indexInput, $length);
            }

            public void close() throws IOException {
                Closeable[] closeableArray = new Closeable[]{this.$indexInput, () -> openInputStream.1.close$lambda$0(this)};
                IOUtils.close((Closeable[])closeableArray);
            }

            private static final void close$lambda$0(openInputStream.1 this$0) {
                super.close();
            }
        };
    }

    private final <T extends SingleShardRequest<T>> RestoreContext constructRestoreContext(String restoreUUID, RemoteClusterRepositoryRequest<T> request) {
        IndexShard indexShard = (IndexShard)this.indicesService.getShardOrNull(request.getLeaderShardId());
        if (indexShard == null) {
            throw new OpenSearchException("Shard [" + request + ".leaderShardId] missing", new Object[0]);
        }
        IndexShard leaderIndexShard = indexShard;
        RemoteClusterRetentionLeaseHelper retentionLeaseHelper = new RemoteClusterRetentionLeaseHelper(request.getFollowerCluster(), (Client)this.nodeClient);
        Closeable retentionLock = leaderIndexShard.acquireHistoryRetentionLock();
        Intrinsics.checkNotNull((Object)retentionLock);
        this.closableResources.add(retentionLock);
        GatedCloseable indexCommitRef = leaderIndexShard.acquireSafeIndexCommit();
        Store store = leaderIndexShard.store();
        Ref.ObjectRef metadataSnapshot = new Ref.ObjectRef();
        metadataSnapshot.element = Store.MetadataSnapshot.EMPTY;
        Intrinsics.checkNotNull((Object)store);
        ExtensionsKt.performOp$default(store, () -> RemoteClusterRestoreLeaderService.constructRestoreContext$lambda$1(metadataSnapshot, store, indexCommitRef), null, 2, null);
        long fromSeqNo = -1L;
        retentionLeaseHelper.addRetentionLease(request.getLeaderShardId(), fromSeqNo, request.getFollowerShardId(), 60000L);
        retentionLock.close();
        Intrinsics.checkNotNull((Object)indexCommitRef);
        Object object = metadataSnapshot.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        RestoreContext restoreContext = new RestoreContext(restoreUUID, leaderIndexShard, (GatedCloseable<IndexCommit>)indexCommitRef, (Store.MetadataSnapshot)object, fromSeqNo);
        this.onGoingRestores.put(restoreUUID, restoreContext);
        this.closableResources.add(restoreContext);
        return restoreContext;
    }

    public final synchronized void removeLeaderClusterRestore(@NotNull String restoreUUID) {
        block0: {
            RestoreContext restoreContext;
            Intrinsics.checkNotNullParameter((Object)restoreUUID, (String)"restoreUUID");
            RestoreContext restoreContext2 = restoreContext = this.onGoingRestores.remove(restoreUUID);
            if (restoreContext2 == null) break block0;
            restoreContext2.close();
        }
    }

    private static final Unit constructRestoreContext$lambda$1(Ref.ObjectRef $metadataSnapshot, Store $store, GatedCloseable $indexCommitRef) {
        $metadataSnapshot.element = $store.getMetadata((IndexCommit)$indexCommitRef.get());
        return Unit.INSTANCE;
    }
}

