/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReader;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.mapper.ContextAwareGroupingFieldType;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.script.ContextAwareGroupingScript;
import org.opensearch.script.Script;

public class ContextAwareGroupingFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "context_aware_grouping";
    public static final Mapper.TypeParser PARSER = new TypeParser();
    private final List<String> fields;
    private final Script script;
    private final ContextAwareGroupingScript compiledScript;

    protected ContextAwareGroupingFieldMapper(String simpleName, ContextAwareGroupingFieldType mappedFieldType, Builder builder) {
        super(simpleName, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        this.fields = builder.fields.getValue();
        this.script = builder.script.getValue();
        this.compiledScript = builder.compiledScript;
    }

    @Override
    public Builder getMergeBuilder() {
        return new Builder(CONTENT_TYPE, this.fields, this.script, this.compiledScript);
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new MapperParsingException("context_aware_grouping cannot be ingested in the document");
    }

    @Override
    public ContextAwareGroupingFieldType fieldType() {
        return (ContextAwareGroupingFieldType)this.mappedFieldType;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void canDeriveSource() {
    }

    @Override
    public void deriveSource(XContentBuilder builder, LeafReader leafReader, int docId) throws IOException {
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<List<String>> fields = new ParametrizedFieldMapper.Parameter<List>("fields", true, Collections::emptyList, (n, c, o) -> {
            if (!(o instanceof List)) {
                throw new MapperParsingException("Expected [fields] to be a list of strings but got [" + String.valueOf(o) + "]");
            }
            List fields = (List)o;
            if (fields.isEmpty()) {
                throw new MapperParsingException("Expected [fields] in context_aware_grouping to have one value");
            }
            if (fields.size() > 1) {
                throw new MapperParsingException("Currently [fields] in context_aware_grouping does not support multiple values");
            }
            return fields;
        }, m -> Builder.toType((FieldMapper)m).fields);
        private final ParametrizedFieldMapper.Parameter<Script> script = new ParametrizedFieldMapper.Parameter<Script>("script", true, () -> null, (n, c, o) -> {
            if (o == null) {
                return null;
            }
            Script s = Script.parse(o);
            if (!s.getLang().equals("painless")) {
                throw new MapperParsingException("context_aware_grouping only supports painless script");
            }
            return s;
        }, m -> Builder.toType((FieldMapper)m).script).acceptsNull();
        private ContextAwareGroupingScript compiledScript;

        private static ContextAwareGroupingFieldMapper toType(FieldMapper in) {
            return (ContextAwareGroupingFieldMapper)in;
        }

        protected Builder(String name) {
            super(name);
        }

        protected Builder(String name, List<String> fields, Script script, ContextAwareGroupingScript contextAwareGroupingScript) {
            super(name);
            this.fields.setValue(fields);
            this.script.setValue(script);
            this.compiledScript = contextAwareGroupingScript;
        }

        @Override
        protected List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return List.of(this.fields, this.script);
        }

        @Override
        public ParametrizedFieldMapper build(Mapper.BuilderContext context) {
            ContextAwareGroupingFieldType contextAwareGroupingFieldType = new ContextAwareGroupingFieldType(this.fields.getValue(), this.compiledScript);
            return new ContextAwareGroupingFieldMapper(this.name, contextAwareGroupingFieldType, this);
        }
    }

    private static class TypeParser
    implements Mapper.TypeParser {
        private TypeParser() {
        }

        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext context) throws MapperParsingException {
            throw new IllegalStateException("ContextAwareGroupingFieldMapper needs objbuilder to validate node");
        }

        @Override
        public Mapper.Builder<?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext context, ObjectMapper.Builder objBuilder) throws MapperParsingException {
            Builder builder = new Builder(name);
            builder.parse(name, context, node);
            if (!builder.fields.isConfigured()) {
                throw new MapperParsingException("[fields] in context_aware_grouping is required");
            }
            Set propertyFieldNames = objBuilder.mappersBuilders.stream().map(b -> ((Mapper.Builder)b).name()).collect(Collectors.toSet());
            if (!propertyFieldNames.containsAll((Collection)builder.fields.getValue())) {
                throw new MapperParsingException("[fields] should be from properties: [" + String.valueOf(propertyFieldNames) + "] but found [" + String.valueOf(builder.fields.getValue()) + "]");
            }
            Script s = builder.script.getValue();
            if (s != null) {
                ContextAwareGroupingScript.Factory factory = context.scriptService().compile(builder.script.get(), ContextAwareGroupingScript.CONTEXT);
                builder.compiledScript = factory.newInstance();
            }
            return builder;
        }
    }
}

