/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.replication.checkpoint;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.store.StoreFileMetadata;
import org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;

@ExperimentalApi
public class ReferencedSegmentsCheckpoint
extends ReplicationCheckpoint {
    private final Set<String> segmentNames;

    public ReferencedSegmentsCheckpoint(ShardId shardId, long primaryTerm, long segmentInfosVersion, long length, String codec, Map<String, StoreFileMetadata> metadataMap, Set<String> segmentNames) {
        super(shardId, primaryTerm, -1L, segmentInfosVersion, length, codec, metadataMap);
        this.segmentNames = segmentNames;
    }

    public ReferencedSegmentsCheckpoint(StreamInput in) throws IOException {
        super(in);
        this.segmentNames = in.readSet(StreamInput::readString);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringCollection(this.segmentNames);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferencedSegmentsCheckpoint that = (ReferencedSegmentsCheckpoint)o;
        return this.getPrimaryTerm() == that.getPrimaryTerm() && this.getSegmentInfosVersion() == that.getSegmentInfosVersion() && this.segmentNames.equals(that.segmentNames) && Objects.equals(this.getShardId(), that.getShardId()) && this.getCodec().equals(that.getCodec());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getShardId(), this.getPrimaryTerm(), this.getSegmentInfosVersion(), this.segmentNames);
    }

    @Override
    public String toString() {
        return "ReferencedSegmentsCheckpoint{shardId=" + String.valueOf(this.getShardId()) + ", primaryTerm=" + this.getPrimaryTerm() + ", segmentsGen=" + this.getSegmentsGen() + ", version=" + this.getSegmentInfosVersion() + ", size=" + this.getLength() + ", codec=" + this.getCodec() + ", timestamp=" + this.getCreatedTimeStamp() + ", segmentNames=" + String.valueOf(this.segmentNames) + "}";
    }

    public Set<String> getSegmentNames() {
        return this.segmentNames;
    }
}

