/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl.wrappers;

import io.smallrye.context.CleanAutoCloseable;
import io.smallrye.context.impl.CapturedContextState;
import io.smallrye.context.impl.Contextualized;
import java.util.concurrent.Callable;

public final class SlowContextualCallable<R>
implements Callable<R>,
Contextualized {
    private final CapturedContextState state;
    private final Callable<R> callable;

    public SlowContextualCallable(CapturedContextState state, Callable<R> callable) {
        this.state = state;
        this.callable = callable;
    }

    @Override
    public R call() throws Exception {
        try (CleanAutoCloseable activeState = this.state.begin();){
            R r = this.callable.call();
            return r;
        }
    }
}

