/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.infinispan.protostream.schema.ReservedNumbers;

public class SparseBitSet
implements ReservedNumbers {
    private long[] words;
    private long[] indices;
    private int size;
    private int modCount;

    public SparseBitSet() {
        this(10);
    }

    public SparseBitSet(long ... values) {
        this(values.length);
        for (long value : values) {
            this.set(value);
        }
    }

    public SparseBitSet(int capacity) {
        this.words = new long[capacity];
        this.indices = new long[capacity];
    }

    public SparseBitSet(SparseBitSet other) {
        this.words = new long[other.words.length];
        this.indices = new long[other.indices.length];
        this.size = other.size;
        this.modCount = other.modCount;
        System.arraycopy(other.words, 0, this.words, 0, other.words.length);
        System.arraycopy(other.indices, 0, this.indices, 0, other.indices.length);
    }

    public boolean set(long i) {
        if (i < 0L) {
            throw new IllegalArgumentException("i < 0: " + i);
        }
        int wordIndex = this.findWord(i);
        if (wordIndex < 0) {
            this.insert(i, -(wordIndex + 1));
            ++this.modCount;
            return true;
        }
        long bit = 1L << (int)(i & 0x3FL);
        if ((this.words[wordIndex] & bit) != 0L) {
            return false;
        }
        int n = wordIndex;
        this.words[n] = this.words[n] | bit;
        ++this.modCount;
        return true;
    }

    public boolean clear(long i) {
        if (i < 0L) {
            throw new IllegalArgumentException("i < 0: " + i);
        }
        int wordIndex = this.findWord(i);
        if (wordIndex < 0) {
            return false;
        }
        long bitIndex = i & 0x3FL;
        if ((this.words[wordIndex] & 1L << (int)bitIndex) == 0L) {
            return false;
        }
        this.removeBit(wordIndex, bitIndex);
        ++this.modCount;
        return true;
    }

    public boolean set(long i, boolean value) {
        return value ? this.set(i) : this.clear(i);
    }

    public void set(long fromIndex, long toIndex) {
        for (long i = fromIndex; i < toIndex; ++i) {
            this.set(i);
        }
    }

    @Override
    public boolean get(long i) {
        if (i < 0L) {
            throw new IllegalArgumentException("i < 0: " + i);
        }
        int wordIndex = this.findWord(i);
        return wordIndex >= 0 && (this.words[wordIndex] & 1L << (int)(i & 0x3FL)) != 0L;
    }

    public long bitCount() {
        long bitCount = 0L;
        for (int i = 0; i < this.size; ++i) {
            bitCount += (long)Long.bitCount(this.words[i]);
        }
        return bitCount;
    }

    @Override
    public int size() {
        long bitCount = this.bitCount();
        if (bitCount > Integer.MAX_VALUE) {
            throw new IllegalStateException("size > Integer.MAX_VALUE: " + bitCount);
        }
        return (int)bitCount;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int wordIndex = this.findWord(fromIndex);
        if (wordIndex < 0) {
            wordIndex = -wordIndex - 1;
            fromIndex = this.adjustBase(fromIndex, wordIndex);
        }
        while (wordIndex < this.size) {
            if ((this.words[wordIndex] & 1L << (fromIndex & 0x3F)) != 0L) {
                return fromIndex;
            }
            if (++fromIndex % 64 != 0 || (wordIndex = this.findWord(fromIndex)) >= 0) continue;
            wordIndex = -wordIndex - 1;
            fromIndex = this.adjustBase(fromIndex, wordIndex);
        }
        return -1;
    }

    private int adjustBase(int fromIndex, int wordIndex) {
        if (wordIndex < this.size) {
            fromIndex = (int)(this.indices[wordIndex] << 6);
        }
        return fromIndex;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int wordIndex = this.findWord(fromIndex);
        if (wordIndex < 0) {
            wordIndex = -wordIndex - 1;
            fromIndex = this.adjustBase(fromIndex, wordIndex);
        }
        while (wordIndex < this.size) {
            if ((this.words[wordIndex] & 1L << (fromIndex & 0x3F)) == 0L) {
                return fromIndex;
            }
            if (++fromIndex % 64 != 0 || (wordIndex = this.findWord(fromIndex)) >= 0) continue;
            wordIndex = -wordIndex - 1;
            fromIndex = this.adjustBase(fromIndex, wordIndex);
        }
        return -1;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.words[i] = 0L;
            this.indices[i] = 0L;
        }
        this.size = 0;
        ++this.modCount;
    }

    public long firstLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long firstWord = this.words[0];
        int bitIndex = 0;
        while ((firstWord & 1L << bitIndex) == 0L) {
            ++bitIndex;
        }
        return (this.indices[0] << 6) + (long)bitIndex;
    }

    public long lastLong() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long lastWord = this.words[this.size - 1];
        int bitIndex = 63;
        while ((lastWord & 1L << bitIndex) == 0L) {
            --bitIndex;
        }
        return (this.indices[this.size - 1] << 6) + (long)bitIndex;
    }

    public PrimitiveIterator.OfLong iterator() {
        return new Iter(0, 0){

            @Override
            protected boolean inRange() {
                return this.wordIndex < SparseBitSet.this.size;
            }

            @Override
            protected void step() {
                ++this.bitIndex;
                if (this.bitIndex > 63 - this.startingBit) {
                    this.bitIndex = this.startingBit;
                    ++this.wordIndex;
                }
            }
        };
    }

    public PrimitiveIterator.OfLong descendingIterator() {
        return new Iter(this.size - 1, 63){

            @Override
            protected boolean inRange() {
                return this.wordIndex >= 0;
            }

            @Override
            protected void step() {
                --this.bitIndex;
                if (this.bitIndex < 63 - this.startingBit) {
                    this.bitIndex = this.startingBit;
                    --this.wordIndex;
                }
            }
        };
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.size * 10);
        builder.append("{");
        boolean started = false;
        for (int i = 0; i < this.size; ++i) {
            long word = this.words[i];
            long index = this.indices[i];
            for (long bitIndex = 0L; bitIndex < 64L; ++bitIndex) {
                long bit = 1L << (int)bitIndex;
                if ((word & bit) == 0L) continue;
                if (started) {
                    builder.append(", ");
                } else {
                    started = true;
                }
                builder.append((index << 6) + bitIndex);
            }
        }
        builder.append("}");
        return builder.toString();
    }

    private int findWord(long x) {
        return Arrays.binarySearch(this.indices, 0, this.size, x >> 6);
    }

    private void insert(long x, int insertionPoint) {
        if (this.words.length == this.size) {
            this.words = Arrays.copyOf(this.words, this.words.length + (this.words.length >> 1));
            this.indices = Arrays.copyOf(this.indices, this.indices.length + (this.words.length >> 1));
        }
        System.arraycopy(this.words, insertionPoint, this.words, insertionPoint + 1, this.size - insertionPoint);
        System.arraycopy(this.indices, insertionPoint, this.indices, insertionPoint + 1, this.size - insertionPoint);
        this.words[insertionPoint] = 1L << (int)(x & 0x3FL);
        this.indices[insertionPoint] = x >> 6;
        ++this.size;
    }

    private void removeBit(int wordIndex, long bitIndex) {
        int n = wordIndex;
        this.words[n] = this.words[n] & (1L << (int)bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.words[wordIndex] == 0L) {
            this.removeWord(wordIndex);
        }
    }

    private void removeWord(int index) {
        System.arraycopy(this.words, index + 1, this.words, index, this.size - index - 1);
        System.arraycopy(this.indices, index + 1, this.indices, index, this.size - index - 1);
        this.words[this.size - 1] = 0L;
        this.indices[this.size - 1] = 0L;
        --this.size;
    }

    public void removeAll(ReservedNumbers that) {
        Iterator iterator = that.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            this.set(l, false);
        }
    }

    private abstract class Iter
    implements PrimitiveIterator.OfLong {
        protected int wordIndex;
        protected int bitIndex;
        protected int lastWordIndex = -1;
        protected int lastBitIndex = -1;
        protected final int startingBit;
        protected int expectedModCount;

        protected Iter(int wordIndex, int bitIndex) {
            this.expectedModCount = SparseBitSet.this.modCount;
            this.wordIndex = wordIndex;
            this.bitIndex = bitIndex;
            this.startingBit = bitIndex;
        }

        @Override
        public boolean hasNext() {
            while (this.inRange() && (SparseBitSet.this.words[this.wordIndex] & 1L << this.bitIndex) == 0L) {
                this.step();
            }
            return this.inRange();
        }

        @Override
        public long nextLong() {
            this.checkForCoModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastWordIndex = this.wordIndex;
            this.lastBitIndex = this.bitIndex;
            long next = (SparseBitSet.this.indices[this.wordIndex] << 6) + (long)this.bitIndex;
            this.step();
            return next;
        }

        @Override
        public void remove() {
            this.checkForCoModification();
            if (this.lastWordIndex < 0) {
                throw new IllegalStateException("Cannot remove before call to nextLong or after call to remove");
            }
            long previousSize = SparseBitSet.this.size;
            SparseBitSet.this.removeBit(this.lastWordIndex, this.lastBitIndex);
            if ((long)SparseBitSet.this.size < previousSize) {
                this.wordIndex = this.lastWordIndex;
                this.bitIndex = this.startingBit;
            }
            this.lastWordIndex = -1;
            this.lastBitIndex = -1;
            ++SparseBitSet.this.modCount;
            ++this.expectedModCount;
        }

        protected abstract boolean inRange();

        protected abstract void step();

        protected void checkForCoModification() {
            if (SparseBitSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

