/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.stream.Stream;

final class Tee {
    public static final int SIZE = 512;
    private final List<TeeInputStream> outputs;
    private final ArrayBlockingQueue<Buf> free;

    Tee(int outputCnt) {
        this.outputs = Stream.generate(() -> new TeeInputStream()).limit(outputCnt).toList();
        this.free = new ArrayBlockingQueue(8);
        Stream.generate(() -> new Buf()).limit(8L).forEach(this.free::add);
    }

    List<TeeInputStream> outputs() {
        return this.outputs;
    }

    void run(InputStream input) {
        while (true) {
            int res;
            Buf buf;
            try {
                buf = this.free.take();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            try {
                res = input.read(buf.data());
            }
            catch (IOException e) {
                for (TeeInputStream output : this.outputs) {
                    output.offer(e);
                }
                return;
            }
            if (res == -1) {
                for (TeeInputStream output : this.outputs) {
                    output.offerEof();
                }
                return;
            }
            buf.limit(res);
            buf.initRefCnt(1);
            for (TeeInputStream output : this.outputs) {
                output.offer(buf);
            }
            buf.release();
        }
    }

    final class Buf {
        private static final VarHandle refCntHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "refCnt", VarHandle.class, Buf.class, Integer.TYPE);
        private final byte[] data = new byte[512];
        private int limit;
        private volatile int refCnt;

        Buf() {
        }

        byte[] data() {
            return this.data;
        }

        int limit() {
            return this.limit;
        }

        void limit(int limit) {
            this.limit = limit;
        }

        void acquire() {
            refCntHandle.getAndAdd(this, 1);
        }

        void release() {
            if (refCntHandle.getAndAdd(this, -1) == 1) {
                Tee.this.free.add(this);
            }
        }

        void initRefCnt(int cnt) {
            refCntHandle.set(this, cnt);
        }

        int get(int offset, byte[] data, int off, int len) {
            int cnt = Math.min(len, this.limit - offset);
            if (cnt > 0) {
                System.arraycopy(this.data, offset, data, off, cnt);
            }
            return cnt;
        }

        int get(int offset) {
            return Byte.toUnsignedInt(this.data[offset]);
        }
    }

    class TeeInputStream
    extends InputStream {
        private final ArrayDeque<Buf> q = new ArrayDeque(8);
        private Buf buf;
        private int offset;
        private IOException error;
        private boolean eof;
        private boolean closed;

        TeeInputStream() {
        }

        private void check() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void offerEof() {
            TeeInputStream teeInputStream = this;
            synchronized (teeInputStream) {
                if (!this.eof) {
                    this.eof = true;
                    this.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void offer(IOException e) {
            TeeInputStream teeInputStream = this;
            synchronized (teeInputStream) {
                this.error = e;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean offer(Buf buf) {
            TeeInputStream teeInputStream = this;
            synchronized (teeInputStream) {
                if (this.closed || this.eof) {
                    return false;
                }
                buf.acquire();
                this.q.add(buf);
                this.notify();
                return true;
            }
        }

        private boolean fill() throws IOException {
            this.check();
            assert (Thread.holdsLock(this));
            if (this.buf != null) {
                return true;
            }
            while (true) {
                IOException error;
                if ((error = this.error) != null) {
                    this.error = null;
                    this.eof = true;
                    throw new IOException(error);
                }
                this.buf = this.q.poll();
                if (this.buf != null) {
                    this.offset = 0;
                    return true;
                }
                if (this.eof) {
                    return false;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            TeeInputStream teeInputStream = this;
            synchronized (teeInputStream) {
                if (!this.fill()) {
                    return -1;
                }
                int res = this.buf.get(this.offset++);
                if (this.offset == this.buf.limit()) {
                    this.buf.release();
                    this.buf = null;
                }
                return res;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            TeeInputStream teeInputStream = this;
            synchronized (teeInputStream) {
                while (this.fill()) {
                    int cnt = this.buf.get(this.offset, b, off, len);
                    this.offset += cnt;
                    if (this.offset == this.buf.limit()) {
                        this.buf.release();
                        this.buf = null;
                    }
                    if (cnt == 0) continue;
                    return cnt;
                }
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long n) throws IOException {
            TeeInputStream teeInputStream = this;
            synchronized (teeInputStream) {
                int rem;
                for (long cnt = 0L; cnt < n; cnt += (long)rem) {
                    if (!this.fill()) {
                        return cnt;
                    }
                    rem = this.buf.limit() - this.offset;
                    if (cnt + (long)rem <= n) {
                        this.buf.release();
                        this.buf = null;
                        continue;
                    }
                    this.offset += (int)(n - cnt);
                    break;
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            TeeInputStream teeInputStream = this;
            synchronized (teeInputStream) {
                this.check();
                return this.buf == null ? 0 : this.buf.limit() - this.offset;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            TeeInputStream teeInputStream = this;
            synchronized (teeInputStream) {
                this.q.clear();
                this.eof = true;
                this.closed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long transferTo(OutputStream out) throws IOException {
            long cnt = 0L;
            TeeInputStream teeInputStream = this;
            synchronized (teeInputStream) {
                while (this.fill()) {
                    int bytes = this.buf.limit() - this.offset;
                    out.write(this.buf.data(), this.offset, bytes);
                    this.offset += bytes;
                    cnt += (long)bytes;
                    if (this.offset != this.buf.limit()) continue;
                    this.buf.release();
                    this.buf = null;
                }
                return cnt;
            }
        }
    }
}

