/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PassivationCacheLoaderInterceptor<K, V>
extends CacheLoaderInterceptor<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    @Inject
    DataOperationOrderer orderer;

    @Override
    public CompletionStage<InternalCacheEntry<K, V>> loadAndStoreInDataContainer(InvocationContext ctx, Object key, int segment, FlagAffectedCommand cmd) {
        CompletionStage retrievalStage;
        CompletableFuture<DataOperationOrderer.Operation> future = new CompletableFuture<DataOperationOrderer.Operation>();
        CompletionStage<DataOperationOrderer.Operation> delayStage = this.orderer.orderOn(key, future);
        if (delayStage != null && !CompletionStages.isCompletedSuccessfully(delayStage)) {
            log.tracef("Found concurrent operation on key %s when attempting to load from store, waiting for its completion", key);
            retrievalStage = delayStage.thenCompose(ignore -> super.loadAndStoreInDataContainer(ctx, key, segment, cmd));
        } else {
            retrievalStage = super.loadAndStoreInDataContainer(ctx, key, segment, cmd);
        }
        return retrievalStage.whenComplete((v, t) -> this.orderer.completeOperation(key, future, DataOperationOrderer.Operation.READ));
    }
}

