/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.streams;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.kafka.clients.admin.AbstractOptions;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterStreamsGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteStreamsGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteStreamsGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteStreamsGroupsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeStreamsGroupsOptions;
import org.apache.kafka.clients.admin.DescribeStreamsGroupsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListStreamsGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListStreamsGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.StreamsGroupDescription;
import org.apache.kafka.clients.admin.StreamsGroupMemberAssignment;
import org.apache.kafka.clients.admin.StreamsGroupMemberDescription;
import org.apache.kafka.clients.admin.StreamsGroupSubtopologyDescription;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.OffsetsUtils;
import org.apache.kafka.tools.consumer.group.CsvUtils;
import org.apache.kafka.tools.streams.StreamsGroupCommandOptions;

public class StreamsGroupCommand {
    static final String MISSING_COLUMN_VALUE = "-";

    public static void main(String[] args) {
        Exit.exit((int)StreamsGroupCommand.execute(args));
    }

    public static int execute(String[] args) {
        StreamsGroupCommandOptions opts = null;
        int exitCode = 0;
        try {
            opts = new StreamsGroupCommandOptions(args);
            opts.checkArgs();
            long numberOfActions = Stream.of(opts.listOpt, opts.describeOpt, opts.resetOffsetsOpt, opts.deleteOpt, opts.deleteOffsetsOpt).filter(arg_0 -> ((OptionSet)opts.options).has(arg_0)).count();
            if (numberOfActions != 1L) {
                throw new IllegalArgumentException("Command must include exactly one action: --list, --describe, --delete, --reset-offsets, or --delete-offsets.");
            }
            StreamsGroupCommand.run(opts);
        }
        catch (IllegalArgumentException | OptionException e) {
            System.err.println(e.getMessage());
            if (opts != null) {
                try {
                    opts.parser.printHelpOn((OutputStream)System.err);
                }
                catch (IOException ex) {
                    StreamsGroupCommand.printError(e.getMessage(), Optional.of(ex));
                }
            }
            exitCode = 1;
        }
        catch (Throwable e) {
            StreamsGroupCommand.printError("Executing streams group command failed due to " + e.getMessage(), Optional.of(e));
            exitCode = 1;
        }
        return exitCode;
    }

    public static void run(StreamsGroupCommandOptions opts) throws ExecutionException, InterruptedException {
        block12: {
            try (StreamsGroupService streamsGroupService = new StreamsGroupService(opts, Map.of());){
                if (opts.options.has(opts.listOpt)) {
                    streamsGroupService.listGroups();
                    break block12;
                }
                if (opts.options.has(opts.describeOpt)) {
                    streamsGroupService.describeGroups();
                    break block12;
                }
                if (opts.options.has(opts.resetOffsetsOpt)) {
                    Map<String, Map<TopicPartition, OffsetAndMetadata>> offsetsToReset = streamsGroupService.resetOffsets();
                    if (opts.options.has(opts.exportOpt)) {
                        String exported = streamsGroupService.exportOffsetsToCsv(offsetsToReset);
                        System.out.println(exported);
                    } else {
                        StreamsGroupCommand.printOffsetsToReset(offsetsToReset);
                    }
                    break block12;
                }
                if (opts.options.has(opts.deleteOpt)) {
                    streamsGroupService.deleteGroups();
                    break block12;
                }
                if (opts.options.has(opts.deleteOffsetsOpt)) {
                    streamsGroupService.deleteOffsets();
                    break block12;
                }
                throw new IllegalArgumentException("Unknown action!");
            }
        }
    }

    static void printOffsetsToReset(Map<String, Map<TopicPartition, OffsetAndMetadata>> groupAssignmentsToReset) {
        String format = "%n%-30s %-30s %-10s %-15s";
        if (!groupAssignmentsToReset.isEmpty()) {
            System.out.printf(format, "GROUP", "TOPIC", "PARTITION", "NEW-OFFSET");
        }
        groupAssignmentsToReset.forEach((groupId, assignment) -> assignment.forEach((streamsAssignment, offsetAndMetadata) -> System.out.printf(format, groupId, streamsAssignment.topic(), streamsAssignment.partition(), offsetAndMetadata.offset())));
        System.out.println();
    }

    static Set<GroupState> groupStatesFromString(String input) {
        Set<GroupState> parsedStates = Arrays.stream(input.split(",")).map(s -> GroupState.parse((String)s.trim())).collect(Collectors.toSet());
        Set validStates = GroupState.groupStatesForType((GroupType)GroupType.STREAMS);
        if (!validStates.containsAll(parsedStates)) {
            throw new IllegalArgumentException("Invalid state list '" + input + "'. Valid states are: " + validStates.stream().map(GroupState::toString).collect(Collectors.joining(", ")));
        }
        return parsedStates;
    }

    public static void printError(String msg, Optional<Throwable> e) {
        System.out.println("\nError: " + msg);
        e.ifPresent(Throwable::printStackTrace);
    }

    static class StreamsGroupService
    implements AutoCloseable {
        final StreamsGroupCommandOptions opts;
        private final Admin adminClient;
        private final OffsetsUtils offsetsUtils;

        public StreamsGroupService(StreamsGroupCommandOptions opts, Map<String, String> configOverrides) {
            this.opts = opts;
            try {
                this.adminClient = this.createAdminClient(configOverrides);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.offsetsUtils = new OffsetsUtils(this.adminClient, opts.parser, this.getOffsetsUtilsOptions(opts));
        }

        public StreamsGroupService(StreamsGroupCommandOptions opts, Admin adminClient) {
            this.opts = opts;
            this.adminClient = adminClient;
            this.offsetsUtils = new OffsetsUtils(adminClient, opts.parser, this.getOffsetsUtilsOptions(opts));
        }

        private OffsetsUtils.OffsetsUtilsOptions getOffsetsUtilsOptions(StreamsGroupCommandOptions opts) {
            return new OffsetsUtils.OffsetsUtilsOptions(opts.options.valuesOf(opts.groupOpt), opts.options.valuesOf(opts.resetToOffsetOpt), opts.options.valuesOf(opts.resetFromFileOpt), opts.options.valuesOf(opts.resetToDatetimeOpt), (String)opts.options.valueOf(opts.resetByDurationOpt), (Long)opts.options.valueOf(opts.resetShiftByOpt), (Long)opts.options.valueOf(opts.timeoutMsOpt));
        }

        public void listGroups() throws ExecutionException, InterruptedException {
            if (this.opts.options.has(this.opts.stateOpt)) {
                String stateValue = (String)this.opts.options.valueOf(this.opts.stateOpt);
                Set<GroupState> states = stateValue == null || stateValue.isEmpty() ? Set.of() : StreamsGroupCommand.groupStatesFromString(stateValue);
                List<GroupListing> listings = this.listStreamsGroupsInStates(states);
                this.printGroupInfo(listings);
            } else {
                this.listStreamsGroups().forEach(System.out::println);
            }
        }

        List<String> listStreamsGroups() {
            try {
                ListGroupsResult result = this.adminClient.listGroups(((ListGroupsOptions)new ListGroupsOptions().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue()))).withTypes(Set.of(GroupType.STREAMS)));
                Collection listings = (Collection)result.all().get();
                return listings.stream().map(GroupListing::groupId).collect(Collectors.toList());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        List<GroupListing> listStreamsGroupsInStates(Set<GroupState> states) throws ExecutionException, InterruptedException {
            ListGroupsResult result = this.adminClient.listGroups(((ListGroupsOptions)new ListGroupsOptions().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue()))).withTypes(Set.of(GroupType.STREAMS)).inGroupStates(states));
            return new ArrayList<GroupListing>((Collection)result.all().get());
        }

        private void printGroupInfo(List<GroupListing> groups) {
            int maxGroupLen = 15;
            for (GroupListing group : groups) {
                maxGroupLen = Math.max(maxGroupLen, group.groupId().length());
            }
            System.out.printf("%" + -maxGroupLen + "s %s\n", "GROUP", "STATE");
            for (GroupListing group : groups) {
                String groupId = group.groupId();
                String state = group.groupState().orElse(GroupState.UNKNOWN).toString();
                System.out.printf("%" + -maxGroupLen + "s %s\n", groupId, state);
            }
        }

        public void describeGroups() throws ExecutionException, InterruptedException {
            ArrayList<String> groupIds;
            ArrayList<String> arrayList = groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? new ArrayList<String>(this.listStreamsGroups()) : new ArrayList(this.opts.options.valuesOf(this.opts.groupOpt));
            if (!groupIds.isEmpty()) {
                for (String groupId : groupIds) {
                    StreamsGroupDescription description = this.getDescribeGroup(groupId);
                    boolean verbose = this.opts.options.has(this.opts.verboseOpt);
                    if (this.opts.options.has(this.opts.membersOpt)) {
                        this.printMembers(description, verbose);
                        continue;
                    }
                    if (this.opts.options.has(this.opts.stateOpt)) {
                        this.printStates(description, verbose);
                        continue;
                    }
                    this.printOffsets(description, verbose);
                }
            }
        }

        StreamsGroupDescription getDescribeGroup(String group) throws ExecutionException, InterruptedException {
            DescribeStreamsGroupsResult result = this.adminClient.describeStreamsGroups(List.of(group), this.withTimeoutMs(new DescribeStreamsGroupsOptions()));
            Map descriptionMap = (Map)result.all().get();
            return (StreamsGroupDescription)descriptionMap.get(group);
        }

        private void printMembers(StreamsGroupDescription description, boolean verbose) {
            block5: {
                int groupLen = Math.max(15, description.groupId().length());
                int maxMemberIdLen = 15;
                int maxHostLen = 15;
                int maxClientIdLen = 15;
                Collection members = description.members();
                if (!StreamsGroupService.isGroupStateValid(description.groupState(), description.members().size())) break block5;
                StreamsGroupService.maybePrintEmptyGroupState(description.groupId(), description.groupState());
                for (Object member : members) {
                    maxMemberIdLen = Math.max(maxMemberIdLen, member.memberId().length());
                    maxHostLen = Math.max(maxHostLen, member.processId().length());
                    maxClientIdLen = Math.max(maxClientIdLen, member.clientId().length());
                }
                if (!verbose) {
                    String fmt = "%" + -groupLen + "s %" + -maxMemberIdLen + "s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %s\n";
                    System.out.printf(fmt, "GROUP", "MEMBER", "PROCESS", "CLIENT-ID", "ASSIGNMENTS");
                    for (StreamsGroupMemberDescription member : members) {
                        System.out.printf(fmt, description.groupId(), member.memberId(), member.processId(), member.clientId(), this.getTasksForPrinting(member.assignment(), Optional.empty()));
                    }
                } else {
                    int targetAssignmentEpochLen = 25;
                    int topologyEpochLen = 15;
                    int memberProtocolLen = 15;
                    int memberEpochLen = 15;
                    String fmt = "%" + -groupLen + "s %-25s %-15s%" + -maxMemberIdLen + "s %-15s %-15s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %s\n";
                    System.out.printf(fmt, "GROUP", "TARGET-ASSIGNMENT-EPOCH", "TOPOLOGY-EPOCH", "MEMBER", "MEMBER-PROTOCOL", "MEMBER-EPOCH", "PROCESS", "CLIENT-ID", "ASSIGNMENTS");
                    for (StreamsGroupMemberDescription member : members) {
                        System.out.printf(fmt, description.groupId(), description.targetAssignmentEpoch(), description.topologyEpoch(), member.memberId(), member.isClassic() ? "classic" : "streams", member.memberEpoch(), member.processId(), member.clientId(), this.getTasksForPrinting(member.assignment(), Optional.of(member.targetAssignment())));
                    }
                }
            }
        }

        String exportOffsetsToCsv(Map<String, Map<TopicPartition, OffsetAndMetadata>> assignments) {
            boolean isSingleGroupQuery = this.opts.options.valuesOf(this.opts.groupOpt).size() == 1;
            ObjectWriter csvWriter = isSingleGroupQuery ? CsvUtils.writerFor(CsvUtils.CsvRecordNoGroup.class) : CsvUtils.writerFor(CsvUtils.CsvRecordWithGroup.class);
            return assignments.entrySet().stream().flatMap(e -> {
                String groupId = (String)e.getKey();
                Map partitionInfo = (Map)e.getValue();
                return partitionInfo.entrySet().stream().map(e1 -> {
                    TopicPartition k = (TopicPartition)e1.getKey();
                    OffsetAndMetadata v = (OffsetAndMetadata)e1.getValue();
                    Object csvRecord = isSingleGroupQuery ? new CsvUtils.CsvRecordNoGroup(k.topic(), k.partition(), v.offset()) : new CsvUtils.CsvRecordWithGroup(groupId, k.topic(), k.partition(), v.offset());
                    try {
                        return csvWriter.writeValueAsString(csvRecord);
                    }
                    catch (JsonProcessingException err) {
                        throw new RuntimeException(err);
                    }
                });
            }).collect(Collectors.joining());
        }

        private String prepareTaskType(List<StreamsGroupMemberAssignment.TaskIds> tasks, String taskType) {
            if (tasks.isEmpty()) {
                return "";
            }
            StringBuilder builder = new StringBuilder(taskType).append(": ");
            for (StreamsGroupMemberAssignment.TaskIds taskIds : tasks) {
                builder.append(taskIds.subtopologyId()).append(":[");
                builder.append(taskIds.partitions().stream().map(String::valueOf).collect(Collectors.joining(",")));
                builder.append("]; ");
            }
            return builder.toString();
        }

        private String getTasksForPrinting(StreamsGroupMemberAssignment assignment, Optional<StreamsGroupMemberAssignment> targetAssignment) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.prepareTaskType(assignment.activeTasks(), "ACTIVE")).append(this.prepareTaskType(assignment.standbyTasks(), "STANDBY")).append(this.prepareTaskType(assignment.warmupTasks(), "WARMUP"));
            targetAssignment.ifPresent(target -> builder.append(this.prepareTaskType(target.activeTasks(), "TARGET-ACTIVE")).append(this.prepareTaskType(target.standbyTasks(), "TARGET-STANDBY")).append(this.prepareTaskType(target.warmupTasks(), "TARGET-WARMUP")));
            return builder.toString();
        }

        private void printStates(StreamsGroupDescription description, boolean verbose) {
            StreamsGroupService.maybePrintEmptyGroupState(description.groupId(), description.groupState());
            int groupLen = Math.max(15, description.groupId().length());
            String coordinator = description.coordinator().host() + ":" + description.coordinator().port() + " (" + description.coordinator().idString() + ")";
            int coordinatorLen = Math.max(25, coordinator.length());
            int stateLen = 25;
            if (!verbose) {
                String fmt = "%" + -groupLen + "s %" + -coordinatorLen + "s %-25s %s\n";
                System.out.printf(fmt, "GROUP", "COORDINATOR (ID)", "STATE", "#MEMBERS");
                System.out.printf(fmt, description.groupId(), coordinator, description.groupState().toString(), description.members().size());
            } else {
                int groupEpochLen = 15;
                int targetAssignmentEpochLen = 25;
                String fmt = "%" + -groupLen + "s %" + -coordinatorLen + "s %-25s %-15s %-25s %s\n";
                System.out.printf(fmt, "GROUP", "COORDINATOR (ID)", "STATE", "GROUP-EPOCH", "TARGET-ASSIGNMENT-EPOCH", "#MEMBERS");
                System.out.printf(fmt, description.groupId(), coordinator, description.groupState().toString(), description.groupEpoch(), description.targetAssignmentEpoch(), description.members().size());
            }
        }

        private void printOffsets(StreamsGroupDescription description, boolean verbose) throws ExecutionException, InterruptedException {
            block5: {
                Map<TopicPartition, OffsetsInfo> offsets = this.getOffsets(description);
                if (!StreamsGroupService.isGroupStateValid(description.groupState(), description.members().size())) break block5;
                StreamsGroupService.maybePrintEmptyGroupState(description.groupId(), description.groupState());
                int groupLen = Math.max(15, description.groupId().length());
                int maxTopicLen = 15;
                for (TopicPartition topicPartition : offsets.keySet()) {
                    maxTopicLen = Math.max(maxTopicLen, topicPartition.topic().length());
                }
                int maxPartitionLen = 10;
                if (!verbose) {
                    fmt = "%" + -groupLen + "s %" + -maxTopicLen + "s %-10s %s\n";
                    System.out.printf(fmt, "GROUP", "TOPIC", "PARTITION", "OFFSET-LAG");
                    for (Map.Entry<TopicPartition, OffsetsInfo> offset : offsets.entrySet()) {
                        System.out.printf(fmt, description.groupId(), offset.getKey().topic(), offset.getKey().partition(), offset.getValue().lag);
                    }
                } else {
                    fmt = "%" + -groupLen + "s %" + -maxTopicLen + "s %-10s %-15s %-15s %-15s %-15s%n";
                    System.out.printf(fmt, "GROUP", "TOPIC", "PARTITION", "CURRENT-OFFSET", "LEADER-EPOCH", "LOG-END-OFFSET", "OFFSET-LAG");
                    for (Map.Entry<TopicPartition, OffsetsInfo> offset : offsets.entrySet()) {
                        System.out.printf(fmt, description.groupId(), offset.getKey().topic(), offset.getKey().partition(), offset.getValue().currentOffset.map(Object::toString).orElse(StreamsGroupCommand.MISSING_COLUMN_VALUE), offset.getValue().leaderEpoch.map(Object::toString).orElse(StreamsGroupCommand.MISSING_COLUMN_VALUE), offset.getValue().logEndOffset, offset.getValue().lag);
                    }
                }
            }
        }

        Map<TopicPartition, OffsetsInfo> getOffsets(StreamsGroupDescription description) throws ExecutionException, InterruptedException {
            Collection members = description.members();
            HashSet<TopicPartition> allTp = new HashSet<TopicPartition>();
            for (StreamsGroupMemberDescription memberDescription : members) {
                allTp.addAll(StreamsGroupService.getTopicPartitions(memberDescription.assignment().activeTasks(), description));
            }
            HashMap<TopicPartition, OffsetSpec> earliest = new HashMap<TopicPartition, OffsetSpec>();
            HashMap<TopicPartition, OffsetSpec> latest = new HashMap<TopicPartition, OffsetSpec>();
            for (TopicPartition tp : allTp) {
                earliest.put(tp, OffsetSpec.earliest());
                latest.put(tp, OffsetSpec.latest());
            }
            Map earliestResult = (Map)this.adminClient.listOffsets(earliest, this.withTimeoutMs(new ListOffsetsOptions())).all().get();
            Map latestResult = (Map)this.adminClient.listOffsets(latest, this.withTimeoutMs(new ListOffsetsOptions())).all().get();
            Map<TopicPartition, OffsetAndMetadata> committedOffsets = this.getCommittedOffsets(description.groupId());
            HashMap<TopicPartition, OffsetsInfo> output = new HashMap<TopicPartition, OffsetsInfo>();
            for (Map.Entry tp : earliestResult.entrySet()) {
                Optional<Long> currentOffset = committedOffsets.containsKey(tp.getKey()) ? Optional.of(committedOffsets.get(tp.getKey()).offset()) : Optional.empty();
                Optional leaderEpoch = committedOffsets.containsKey(tp.getKey()) ? committedOffsets.get(tp.getKey()).leaderEpoch() : Optional.empty();
                long lag = currentOffset.map(current -> ((ListOffsetsResult.ListOffsetsResultInfo)latestResult.get(tp.getKey())).offset() - current).orElseGet(() -> ((ListOffsetsResult.ListOffsetsResultInfo)latestResult.get(tp.getKey())).offset() - ((ListOffsetsResult.ListOffsetsResultInfo)earliestResult.get(tp.getKey())).offset());
                output.put((TopicPartition)tp.getKey(), new OffsetsInfo(currentOffset, leaderEpoch, ((ListOffsetsResult.ListOffsetsResultInfo)latestResult.get(tp.getKey())).offset(), lag));
            }
            return output;
        }

        Map<TopicPartition, OffsetAndMetadata> getCommittedOffsets(String groupId) {
            try {
                Set sourceTopics = ((StreamsGroupDescription)((Map)this.adminClient.describeStreamsGroups(List.of(groupId), this.withTimeoutMs(new DescribeStreamsGroupsOptions())).all().get()).get(groupId)).subtopologies().stream().flatMap(subtopology -> subtopology.sourceTopics().stream()).collect(Collectors.toSet());
                Map allTopicPartitions = (Map)this.adminClient.listStreamsGroupOffsets(Map.of(groupId, new ListStreamsGroupOffsetsSpec()), this.withTimeoutMs(new ListStreamsGroupOffsetsOptions())).partitionsToOffsetAndMetadata(groupId).get();
                allTopicPartitions.keySet().removeIf(tp -> !sourceTopics.contains(tp.topic()));
                return allTopicPartitions;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private List<TopicPartition> filterExistingGroupTopics(String groupId, List<TopicPartition> topicPartitions) {
            try {
                Map allTopicPartitions = (Map)this.adminClient.listStreamsGroupOffsets(Map.of(groupId, new ListStreamsGroupOffsetsSpec()), this.withTimeoutMs(new ListStreamsGroupOffsetsOptions())).partitionsToOffsetAndMetadata(groupId).get();
                boolean allPresent = topicPartitions.stream().allMatch(allTopicPartitions::containsKey);
                if (!allPresent) {
                    StreamsGroupCommand.printError("One or more topics are not part of the group '" + groupId + "'.", Optional.empty());
                    return List.of();
                }
                return topicPartitions;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsets() {
            List groupIds;
            boolean dryRun = this.opts.options.has(this.opts.dryRunOpt) || !this.opts.options.has(this.opts.executeOpt);
            HashMap<String, Map<TopicPartition, OffsetAndMetadata>> result = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
            List list = groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? this.listStreamsGroups() : this.opts.options.valuesOf(this.opts.groupOpt);
            if (!groupIds.isEmpty()) {
                Map streamsGroups = this.adminClient.describeStreamsGroups((Collection)groupIds, this.withTimeoutMs(new DescribeStreamsGroupsOptions())).describedGroups();
                streamsGroups.forEach((groupId, groupDescription) -> {
                    try {
                        String state;
                        switch (state = ((StreamsGroupDescription)groupDescription.get()).groupState().toString()) {
                            case "Empty": 
                            case "Dead": {
                                List<String> internalTopics;
                                result.put((String)groupId, this.resetOffsetsForInactiveGroup((String)groupId, dryRun));
                                if (!dryRun && !(internalTopics = this.getInternalTopicsToBeDeleted((String)groupId)).isEmpty()) {
                                    try {
                                        this.adminClient.deleteTopics(internalTopics, this.withTimeoutMs(new DeleteTopicsOptions())).all().get();
                                    }
                                    catch (InterruptedException | ExecutionException e) {
                                        if (e.getCause() instanceof UnknownTopicOrPartitionException) {
                                            StreamsGroupCommand.printError("Deleting internal topics for group '" + groupId + "' failed because the topics do not exist.", Optional.empty());
                                            break;
                                        }
                                        if (e.getCause() instanceof UnsupportedVersionException) {
                                            StreamsGroupCommand.printError("Deleting internal topics is not supported by the broker version.\nInternal topics: (" + String.join((CharSequence)",", internalTopics) + ").\nUse 'kafka-topics.sh' to delete the group's internal topics.", Optional.of(e.getCause()));
                                            break;
                                        }
                                        StreamsGroupCommand.printError("Deleting internal topics for group '" + groupId + "' failed due to " + e.getMessage(), Optional.of(e));
                                    }
                                }
                                break;
                            }
                            default: {
                                StreamsGroupCommand.printError("Assignments can only be reset if the group '" + groupId + "' is inactive, but the current state is " + state + ".", Optional.empty());
                                result.put((String)groupId, Map.of());
                            }
                        }
                    }
                    catch (InterruptedException ie) {
                        throw new RuntimeException(ie);
                    }
                    catch (ExecutionException ee) {
                        if (ee.getCause() instanceof GroupIdNotFoundException) {
                            result.put((String)groupId, this.resetOffsetsForInactiveGroup((String)groupId, dryRun));
                        }
                        throw new RuntimeException(ee);
                    }
                });
            }
            return result;
        }

        private List<String> getInternalTopicsToBeDeleted(String groupId) {
            List<Object> internalTopics = new ArrayList();
            if (this.opts.options.has(this.opts.deleteAllInternalTopicsOpt)) {
                internalTopics = this.retrieveInternalTopics(List.of(groupId)).get(groupId);
            } else if (this.opts.options.has(this.opts.deleteInternalTopicOpt)) {
                internalTopics = this.opts.options.valuesOf(this.opts.deleteInternalTopicOpt);
            }
            return internalTopics;
        }

        private Map.Entry<Errors, Map<TopicPartition, Throwable>> deleteOffsets(String groupId, List<String> topics) {
            HashMap<TopicPartition, Throwable> partitionLevelResult = new HashMap<TopicPartition, Throwable>();
            HashSet<String> topicWithPartitions = new HashSet<String>();
            HashSet<String> topicWithoutPartitions = new HashSet<String>();
            for (String topic : topics) {
                if (topic.contains(":")) {
                    topicWithPartitions.add(topic);
                    continue;
                }
                topicWithoutPartitions.add(topic);
            }
            List specifiedPartitions = topicWithPartitions.stream().flatMap(this.offsetsUtils::parseTopicsWithPartitions).toList();
            DescribeTopicsResult describeTopicsResult = this.adminClient.describeTopics(topicWithoutPartitions, this.withTimeoutMs(new DescribeTopicsOptions()));
            Iterator unspecifiedPartitions = describeTopicsResult.topicNameValues().entrySet().stream().flatMap(e -> {
                String topic = (String)e.getKey();
                try {
                    return ((TopicDescription)((KafkaFuture)e.getValue()).get()).partitions().stream().map(partition -> new TopicPartition(topic, partition.partition()));
                }
                catch (InterruptedException | ExecutionException err) {
                    partitionLevelResult.put(new TopicPartition(topic, -1), err);
                    return Stream.empty();
                }
            }).iterator();
            HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(specifiedPartitions);
            unspecifiedPartitions.forEachRemaining(partitions::add);
            return this.deleteOffsets(groupId, partitions, partitionLevelResult);
        }

        private Map.Entry<Errors, Map<TopicPartition, Throwable>> deleteOffsets(String groupId, Set<TopicPartition> partitions, Map<TopicPartition, Throwable> partitionLevelResult) {
            DeleteStreamsGroupOffsetsResult deleteResult = this.adminClient.deleteStreamsGroupOffsets(groupId, partitions, this.withTimeoutMs(new DeleteStreamsGroupOffsetsOptions()));
            Errors topLevelException = Errors.NONE;
            try {
                deleteResult.all().get();
            }
            catch (InterruptedException | ExecutionException e) {
                topLevelException = Errors.forException((Throwable)e.getCause());
            }
            partitions.forEach(partition -> {
                try {
                    deleteResult.partitionResult(partition).get();
                    partitionLevelResult.put((TopicPartition)partition, (Throwable)null);
                }
                catch (InterruptedException | ExecutionException e) {
                    partitionLevelResult.put((TopicPartition)partition, e);
                }
            });
            return new AbstractMap.SimpleImmutableEntry<Errors, Map<TopicPartition, Throwable>>(topLevelException, partitionLevelResult);
        }

        Map.Entry<Errors, Map<TopicPartition, Throwable>> deleteOffsets() {
            Map.Entry<Errors, Map<TopicPartition, Throwable>> res;
            String groupId = (String)this.opts.options.valueOf(this.opts.groupOpt);
            if (this.opts.options.has(this.opts.allInputTopicsOpt)) {
                Set<TopicPartition> partitions = this.getCommittedOffsets(groupId).keySet();
                res = this.deleteOffsets(groupId, partitions, new HashMap<TopicPartition, Throwable>());
            } else if (this.opts.options.has(this.opts.inputTopicOpt)) {
                List topics = this.opts.options.valuesOf(this.opts.inputTopicOpt);
                res = this.deleteOffsets(groupId, topics);
            } else {
                CommandLineUtils.printUsageAndExit((OptionParser)this.opts.parser, (String)("Option " + String.valueOf(this.opts.deleteOffsetsOpt) + " requires either" + String.valueOf(this.opts.allInputTopicsOpt) + " or " + String.valueOf(this.opts.inputTopicOpt) + " to be specified."));
                return null;
            }
            Errors topLevelResult = res.getKey();
            Map<TopicPartition, Throwable> partitionLevelResult = res.getValue();
            switch (topLevelResult) {
                case NONE: {
                    System.out.println("Request succeeded for deleting offsets from group " + groupId + ".");
                    break;
                }
                case INVALID_GROUP_ID: 
                case GROUP_ID_NOT_FOUND: 
                case GROUP_AUTHORIZATION_FAILED: 
                case NON_EMPTY_GROUP: {
                    StreamsGroupCommand.printError(topLevelResult.message(), Optional.empty());
                    break;
                }
                case GROUP_SUBSCRIBED_TO_TOPIC: 
                case TOPIC_AUTHORIZATION_FAILED: 
                case UNKNOWN_TOPIC_OR_PARTITION: {
                    StreamsGroupCommand.printError("Encountered some partition-level error, see the follow-up details.", Optional.empty());
                    break;
                }
                default: {
                    StreamsGroupCommand.printError("Encountered some unknown error: " + String.valueOf(topLevelResult), Optional.empty());
                }
            }
            int maxTopicLen = 15;
            for (TopicPartition tp : partitionLevelResult.keySet()) {
                maxTopicLen = Math.max(maxTopicLen, tp.topic().length());
            }
            String format = "%n%" + -maxTopicLen + "s %-10s %-15s";
            System.out.printf(format, "TOPIC", "PARTITION", "STATUS");
            partitionLevelResult.entrySet().stream().sorted(Comparator.comparing(e -> ((TopicPartition)e.getKey()).topic() + ((TopicPartition)e.getKey()).partition())).forEach(e -> {
                TopicPartition tp = (TopicPartition)e.getKey();
                Throwable error = (Throwable)e.getValue();
                System.out.printf(format, tp.topic(), tp.partition() >= 0 ? Integer.valueOf(tp.partition()) : StreamsGroupCommand.MISSING_COLUMN_VALUE, error != null ? "Error: " + error.getMessage() : "Successful");
            });
            System.out.println();
            return res;
        }

        Map<String, Throwable> deleteGroups() {
            ArrayList<String> groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? new ArrayList<String>(this.listStreamsGroups()) : new ArrayList(this.opts.options.valuesOf(this.opts.groupOpt));
            Map<String, Throwable> failed = this.preAdminCallChecks(groupIds);
            groupIds.removeAll(failed.keySet());
            HashMap<String, Throwable> success = new HashMap<String, Throwable>();
            Map<Object, Object> internalTopicsToBeDeleted = new HashMap();
            Map<String, Throwable> internalTopicsDeletionFailures = new HashMap<String, Throwable>();
            if (!groupIds.isEmpty()) {
                if (this.opts.options.has(this.opts.deleteAllInternalTopicsOpt)) {
                    internalTopicsToBeDeleted = this.retrieveInternalTopics(groupIds);
                }
                Map groupsToDelete = this.adminClient.deleteStreamsGroups(groupIds, this.withTimeoutMs(new DeleteStreamsGroupsOptions())).deletedGroups();
                groupsToDelete.forEach((g, f) -> {
                    try {
                        f.get();
                        success.put((String)g, (Throwable)null);
                    }
                    catch (InterruptedException ie) {
                        failed.put((String)g, ie);
                    }
                    catch (ExecutionException e) {
                        failed.put((String)g, e.getCause());
                    }
                });
                internalTopicsDeletionFailures = this.maybeDeleteInternalTopics(success, internalTopicsToBeDeleted);
            }
            if (failed.isEmpty()) {
                System.out.println("Deletion of requested streams groups ('" + success.keySet().stream().map(Object::toString).collect(Collectors.joining("', '")) + "') was successful.");
            } else {
                StreamsGroupCommand.printError("Deletion of some streams groups failed:", Optional.empty());
                failed.forEach((group, error) -> System.out.println("* Group '" + group + "' could not be deleted due to: " + String.valueOf(error)));
                if (!success.isEmpty()) {
                    System.out.println("\nThese streams groups were deleted successfully: '" + success.keySet().stream().map(Object::toString).collect(Collectors.joining("', '")) + "'.");
                }
            }
            if (!internalTopicsToBeDeleted.keySet().isEmpty()) {
                this.printInternalTopicErrors(internalTopicsDeletionFailures, success.keySet(), internalTopicsToBeDeleted.keySet());
            }
            internalTopicsDeletionFailures.forEach((group, error) -> {
                if (!(error instanceof UnknownTopicOrPartitionException)) {
                    failed.put((String)group, (Throwable)error);
                }
            });
            failed.putAll(success);
            return failed;
        }

        private Map<String, Throwable> maybeDeleteInternalTopics(Map<String, Throwable> success, Map<String, List<String>> internalTopics) {
            HashMap<String, Throwable> internalTopicsDeletionFailures = new HashMap<String, Throwable>();
            if (!internalTopics.isEmpty() && !success.isEmpty()) {
                for (String groupId : success.keySet()) {
                    List<String> internalTopicsToDelete = internalTopics.get(groupId);
                    if (internalTopicsToDelete == null || internalTopicsToDelete.isEmpty()) continue;
                    DeleteTopicsResult deleteTopicsResult = null;
                    try {
                        deleteTopicsResult = this.adminClient.deleteTopics(internalTopicsToDelete, this.withTimeoutMs(new DeleteTopicsOptions()));
                        deleteTopicsResult.all().get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        if (deleteTopicsResult != null) {
                            deleteTopicsResult.topicNameValues().forEach((topic, future) -> {
                                try {
                                    future.get();
                                }
                                catch (Exception topicException) {
                                    System.out.println("Failed to delete internal topic: " + topic);
                                }
                            });
                        }
                        internalTopicsDeletionFailures.put(groupId, e.getCause());
                    }
                }
            }
            return internalTopicsDeletionFailures;
        }

        private Map<String, Throwable> preAdminCallChecks(List<String> groupIds) {
            List<GroupListing> streamsGroupIds = this.listDetailedStreamsGroups();
            LinkedHashSet<String> groupIdSet = new LinkedHashSet<String>(groupIds);
            HashMap<String, Throwable> failed = new HashMap<String, Throwable>();
            for (String groupId : groupIdSet) {
                Optional<GroupListing> listing = streamsGroupIds.stream().filter(item -> item.groupId().equals(groupId)).findAny();
                if (listing.isEmpty()) {
                    failed.put(groupId, new IllegalArgumentException("Group '" + groupId + "' does not exist or is not a streams group."));
                    continue;
                }
                Optional groupState = listing.get().groupState();
                groupState.ifPresent(state -> {
                    if (state == GroupState.DEAD) {
                        failed.put(groupId, new IllegalStateException("Streams group '" + groupId + "' group state is DEAD."));
                    } else if (state != GroupState.EMPTY) {
                        failed.put(groupId, (Throwable)new GroupNotEmptyException("Streams group '" + groupId + "' is not EMPTY."));
                    }
                });
            }
            return failed;
        }

        List<GroupListing> listDetailedStreamsGroups() {
            try {
                ListGroupsResult result = this.adminClient.listGroups(((ListGroupsOptions)new ListGroupsOptions().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue()))).withTypes(Set.of(GroupType.STREAMS)));
                Collection listings = (Collection)result.all().get();
                return listings.stream().toList();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private void printInternalTopicErrors(Map<String, Throwable> internalTopicsDeletionFailures, Set<String> deletedGroupIds, Set<String> groupIdsWithInternalTopics) {
            if (!deletedGroupIds.isEmpty()) {
                if (internalTopicsDeletionFailures.isEmpty()) {
                    List successfulGroups = deletedGroupIds.stream().filter(groupIdsWithInternalTopics::contains).collect(Collectors.toList());
                    System.out.println("Deletion of associated internal topics of the streams groups ('" + String.join((CharSequence)"', '", successfulGroups) + "') was successful.");
                } else {
                    System.out.println("Deletion of some associated internal topics failed:");
                    internalTopicsDeletionFailures.forEach((group, error) -> System.out.println("* Internal topics of the streams group '" + group + "' could not be deleted due to: " + String.valueOf(error)));
                }
            }
        }

        Map<String, List<String>> retrieveInternalTopics(List<String> groupIds) {
            HashMap<String, List<String>> groupToInternalTopics = new HashMap<String, List<String>>();
            try {
                Map descriptionMap = (Map)this.adminClient.describeStreamsGroups(groupIds, this.withTimeoutMs(new DescribeStreamsGroupsOptions())).all().get();
                for (StreamsGroupDescription description : descriptionMap.values()) {
                    List sourceTopics = description.subtopologies().stream().flatMap(subtopology -> subtopology.sourceTopics().stream()).toList();
                    List internalTopics = description.subtopologies().stream().flatMap(subtopology -> Stream.concat(subtopology.repartitionSourceTopics().keySet().stream(), subtopology.stateChangelogTopics().keySet().stream())).filter(topic -> !sourceTopics.contains(topic)).collect(Collectors.toList());
                    internalTopics.removeIf(topic -> {
                        if (!this.isInferredInternalTopic((String)topic, description.groupId())) {
                            StreamsGroupCommand.printError("The internal topic '" + topic + "' is not inferred as internal and thus will not be deleted with the group '" + description.groupId() + "'.", Optional.empty());
                            return true;
                        }
                        return false;
                    });
                    if (internalTopics.isEmpty()) continue;
                    groupToInternalTopics.put(description.groupId(), internalTopics);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                if (e.getCause() instanceof UnsupportedVersionException) {
                    try {
                        Set allTopics = (Set)this.adminClient.listTopics(this.withTimeoutMs(new ListTopicsOptions())).names().get();
                        List internalTopics = allTopics.stream().filter(topic -> groupIds.stream().anyMatch(groupId -> this.isInferredInternalTopic((String)topic, (String)groupId))).collect(Collectors.toList());
                        StreamsGroupCommand.printError("Retrieving internal topics is not supported by the broker version.\nInternal topics: (" + String.join((CharSequence)",", internalTopics) + ").\nUse 'kafka-topics.sh' to delete the group's internal topics.", Optional.of(e.getCause()));
                    }
                    catch (InterruptedException | ExecutionException ex) {
                        StreamsGroupCommand.printError("Retrieving internal topics is not supported by the broker version. Use 'kafka-topics.sh' to list and delete the group's internal topics.", Optional.of(e.getCause()));
                    }
                }
                StreamsGroupCommand.printError("Retrieving internal topics failed due to " + e.getMessage(), Optional.of(e));
            }
            return groupToInternalTopics;
        }

        private Map<TopicPartition, OffsetAndMetadata> resetOffsetsForInactiveGroup(String groupId, boolean dryRun) {
            try {
                Collection<TopicPartition> partitionsToReset = this.getPartitionsToReset(groupId);
                Map<TopicPartition, OffsetAndMetadata> preparedOffsets = this.prepareOffsetsToReset(groupId, partitionsToReset);
                if (!dryRun) {
                    this.adminClient.alterStreamsGroupOffsets(groupId, preparedOffsets, this.withTimeoutMs(new AlterStreamsGroupOffsetsOptions())).all().get();
                }
                return preparedOffsets;
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            catch (ExecutionException ee) {
                Throwable cause = ee.getCause();
                if (cause instanceof KafkaException) {
                    throw (KafkaException)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        private Collection<TopicPartition> getPartitionsToReset(String groupId) throws ExecutionException, InterruptedException {
            if (this.opts.options.has(this.opts.allInputTopicsOpt)) {
                return this.getCommittedOffsets(groupId).keySet();
            }
            if (this.opts.options.has(this.opts.inputTopicOpt)) {
                List topics = this.opts.options.valuesOf(this.opts.inputTopicOpt);
                List<TopicPartition> partitions = this.offsetsUtils.parseTopicPartitionsToReset(topics);
                this.offsetsUtils.checkAllTopicPartitionsValid(partitions);
                partitions = this.filterExistingGroupTopics(groupId, partitions);
                return partitions;
            }
            if (!this.opts.options.has(this.opts.resetFromFileOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.opts.parser, (String)"One of the reset scopes should be defined: --all-topics, --topic.");
            }
            return List.of();
        }

        private Map<TopicPartition, OffsetAndMetadata> prepareOffsetsToReset(String groupId, Collection<TopicPartition> partitionsToReset) {
            if (this.opts.options.has(this.opts.resetToOffsetOpt)) {
                return this.offsetsUtils.resetToOffset(partitionsToReset);
            }
            if (this.opts.options.has(this.opts.resetToEarliestOpt)) {
                return this.offsetsUtils.resetToEarliest(partitionsToReset);
            }
            if (this.opts.options.has(this.opts.resetToLatestOpt)) {
                return this.offsetsUtils.resetToLatest(partitionsToReset);
            }
            if (this.opts.options.has(this.opts.resetShiftByOpt)) {
                Map<TopicPartition, OffsetAndMetadata> currentCommittedOffsets = this.getCommittedOffsets(groupId);
                return this.offsetsUtils.resetByShiftBy(partitionsToReset, currentCommittedOffsets);
            }
            if (this.opts.options.has(this.opts.resetToDatetimeOpt)) {
                return this.offsetsUtils.resetToDateTime(partitionsToReset);
            }
            if (this.opts.options.has(this.opts.resetByDurationOpt)) {
                return this.offsetsUtils.resetByDuration(partitionsToReset);
            }
            if (this.offsetsUtils.resetPlanFromFile().isPresent()) {
                return this.offsetsUtils.resetFromFile(groupId);
            }
            if (this.opts.options.has(this.opts.resetToCurrentOpt)) {
                Map<TopicPartition, OffsetAndMetadata> currentCommittedOffsets = this.getCommittedOffsets(groupId);
                return this.offsetsUtils.resetToCurrent(partitionsToReset, currentCommittedOffsets);
            }
            CommandLineUtils.printUsageAndExit((OptionParser)this.opts.parser, (String)String.format("Option '%s' requires one of the following scenarios: %s", this.opts.resetOffsetsOpt, this.opts.allResetOffsetScenarioOpts));
            return null;
        }

        private boolean isInferredInternalTopic(String topicName, String applicationId) {
            return topicName.startsWith(applicationId + StreamsGroupCommand.MISSING_COLUMN_VALUE) && StreamsGroupService.matchesInternalTopicFormat(topicName);
        }

        public static boolean matchesInternalTopicFormat(String topicName) {
            return topicName.endsWith("-changelog") || topicName.endsWith("-repartition") || topicName.endsWith("-subscription-registration-topic") || topicName.endsWith("-subscription-response-topic") || topicName.matches(".+-KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-\\d+-topic") || topicName.matches(".+-KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-\\d+-topic");
        }

        Collection<StreamsGroupMemberDescription> collectGroupMembers(String groupId) throws Exception {
            return this.getDescribeGroup(groupId).members();
        }

        GroupState collectGroupState(String groupId) throws Exception {
            return this.getDescribeGroup(groupId).groupState();
        }

        private <T extends AbstractOptions<T>> T withTimeoutMs(T options) {
            int t = ((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue();
            return (T)options.timeoutMs(Integer.valueOf(t));
        }

        private static void maybePrintEmptyGroupState(String group, GroupState state) {
            if (state == GroupState.DEAD) {
                StreamsGroupCommand.printError("Streams group '" + group + "' does not exist.", Optional.empty());
            } else if (state == GroupState.EMPTY) {
                StreamsGroupCommand.printError("Streams group '" + group + "' has no active members.", Optional.empty());
            }
        }

        static boolean isGroupStateValid(GroupState state, int numRows) {
            return !state.equals((Object)GroupState.DEAD) && numRows > 0;
        }

        private static Set<TopicPartition> getTopicPartitions(List<StreamsGroupMemberAssignment.TaskIds> taskIds, StreamsGroupDescription description) {
            HashMap allSourceTopics = new HashMap();
            for (StreamsGroupSubtopologyDescription subtopologyDescription : description.subtopologies()) {
                ArrayList topics = new ArrayList(subtopologyDescription.sourceTopics());
                topics.addAll(subtopologyDescription.repartitionSourceTopics().keySet());
                allSourceTopics.put(subtopologyDescription.subtopologyId(), topics);
            }
            HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
            for (StreamsGroupMemberAssignment.TaskIds task : taskIds) {
                List sourceTopics = (List)allSourceTopics.get(task.subtopologyId());
                if (sourceTopics == null) {
                    throw new IllegalArgumentException("Subtopology " + task.subtopologyId() + " not found in group description!");
                }
                for (String topic : sourceTopics) {
                    for (Integer partition : task.partitions()) {
                        topicPartitions.add(new TopicPartition(topic, partition.intValue()));
                    }
                }
            }
            return topicPartitions;
        }

        @Override
        public void close() {
            this.adminClient.close();
        }

        protected Admin createAdminClient(Map<String, String> configOverrides) throws IOException {
            Properties props = this.opts.options.has(this.opts.commandConfigOpt) ? Utils.loadProps((String)((String)this.opts.options.valueOf(this.opts.commandConfigOpt))) : new Properties();
            props.put("bootstrap.servers", this.opts.options.valueOf(this.opts.bootstrapServerOpt));
            props.putAll(configOverrides);
            return Admin.create((Properties)props);
        }
    }

    public record OffsetsInfo(Optional<Long> currentOffset, Optional<Integer> leaderEpoch, Long logEndOffset, Long lag) {
    }
}

