/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.raft.DefaultExternalKRaftMetrics;
import kafka.raft.KafkaRaftManager;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRequestHandlerPoolFactory;
import kafka.server.Server$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.metrics.ControllerMetadataMetrics;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.metrics.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.image.publisher.metrics.SnapshotEmitterMetrics;
import org.apache.kafka.metadata.ListenerInfo;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.ServerSocketFactory;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.BrokerServerMetrics;
import org.apache.kafka.server.metrics.ClientTelemetryExporterPlugin;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.metrics.NodeMetrics;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0015c\u0001B)S\u0001]C\u0001\u0002\u001a\u0001\u0003\u0006\u0004%I!\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005M\"A1\u000e\u0001BC\u0002\u0013\u0005A\u000e\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003n\u0011!Y\bA!b\u0001\n\u0003a\b\"CA\u0005\u0001\t\u0005\t\u0015!\u0003~\u0011)\tY\u0001\u0001BC\u0002\u0013%\u0011Q\u0002\u0005\u000b\u00037\u0001!\u0011!Q\u0001\n\u0005=\u0001BCA\u000f\u0001\t\u0015\r\u0011\"\u0001\u0002 !Q\u0011Q\u000b\u0001\u0003\u0002\u0003\u0006I!!\t\t\u0015\u0005]\u0003A!b\u0001\n\u0003\tI\u0006\u0003\u0006\u0002b\u0001\u0011\t\u0011)A\u0005\u00037B!\"a\u0019\u0001\u0005\u000b\u0007I\u0011AA3\u0011)\ti\u0007\u0001B\u0001B\u0003%\u0011q\r\u0005\u000b\u0003_\u0002!Q1A\u0005\u0002\u0005E\u0004BCA?\u0001\t\u0005\t\u0015!\u0003\u0002t!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005\"CAK\u0001\t\u0007I\u0011BAL\u0011!\ty\n\u0001Q\u0001\n\u0005e\u0005\"CAQ\u0001\u0001\u0007I\u0011BAR\u0011%\tY\u000b\u0001a\u0001\n\u0013\ti\u000b\u0003\u0005\u0002:\u0002\u0001\u000b\u0015BAS\u0011%\tY\f\u0001a\u0001\n\u0013\t\u0019\u000bC\u0005\u0002>\u0002\u0001\r\u0011\"\u0003\u0002@\"A\u00111\u0019\u0001!B\u0013\t)\u000bC\u0005\u0002F\u0002\u0001\r\u0011\"\u0003\u0002$\"I\u0011q\u0019\u0001A\u0002\u0013%\u0011\u0011\u001a\u0005\t\u0003\u001b\u0004\u0001\u0015)\u0003\u0002&\"A\u0011q\u001a\u0001C\u0002\u0013\u0005Q\rC\u0004\u0002R\u0002\u0001\u000b\u0011\u00024\t\u0011\u0005M\u0007A1A\u0005\u0002\u0015Dq!!6\u0001A\u0003%a\rC\u0005\u0002X\u0002\u0011\r\u0011\"\u0001\u0002Z\"A\u0011\u0011\u001d\u0001!\u0002\u0013\tY\u000eC\u0005\u0002\u0016\u0001\u0001\r\u0011\"\u0001\u0002\u000e!I\u00111\u001d\u0001A\u0002\u0013\u0005\u0011Q\u001d\u0005\t\u0003S\u0004\u0001\u0015)\u0003\u0002\u0010!Y\u00111\u001f\u0001A\u0002\u0003\u0007I\u0011AA{\u0011-\u0011i\u0001\u0001a\u0001\u0002\u0004%\tAa\u0004\t\u0017\tM\u0001\u00011A\u0001B\u0003&\u0011q\u001f\u0005\f\u0005/\u0001\u0001\u0019!a\u0001\n\u0003\u0011I\u0002C\u0006\u0003&\u0001\u0001\r\u00111A\u0005\u0002\t\u001d\u0002b\u0003B\u0016\u0001\u0001\u0007\t\u0011)Q\u0005\u00057A1Ba\f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u00032!Y!\u0011\t\u0001A\u0002\u0003\u0007I\u0011\u0001B\"\u0011-\u00119\u0005\u0001a\u0001\u0002\u0003\u0006KAa\r\t\u0017\t-\u0003\u00011AA\u0002\u0013\u0005!Q\n\u0005\f\u0005+\u0002\u0001\u0019!a\u0001\n\u0003\u00119\u0006C\u0006\u0003\\\u0001\u0001\r\u0011!Q!\n\t=\u0003b\u0003B0\u0001\u0001\u0007\t\u0019!C\u0001\u0005CB1B!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003t!Y!q\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B2\u0011%\u0011Y\b\u0001b\u0001\n\u0013\u0011i\b\u0003\u0005\u0003\"\u0002\u0001\u000b\u0011\u0002B@\u0011-\u0011\u0019\u000b\u0001a\u0001\u0002\u0004%\tA!*\t\u0017\tM\u0006\u00011AA\u0002\u0013\u0005!Q\u0017\u0005\f\u0005s\u0003\u0001\u0019!A!B\u0013\u00119\u000bC\u0006\u0003>\u0002\u0001\r\u00111A\u0005\n\t}\u0006b\u0003Bd\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u0013D1B!4\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003B\"Y!\u0011\u001b\u0001A\u0002\u0003\u0007I\u0011\u0002Bj\u0011-\u0011y\u000e\u0001a\u0001\u0002\u0004%IA!9\t\u0017\t\u0015\b\u00011A\u0001B\u0003&!Q\u001b\u0005\b\u0005S\u0004A\u0011\u0001Bv\u0011\u001d\u0011i\u000f\u0001C\u0001\u0005_DqAa>\u0001\t\u0013\u0011I\u0010C\u0004\u0003|\u0002!\tA!@\t\u000f\t}\b\u0001\"\u0001\u0004\u0002!91q\u0002\u0001\u0005\u0002\tu\bbBB\t\u0001\u0011\u0005!Q \u0005\b\u0007'\u0001A\u0011BB\u000b\u0011\u001d\u0019\u0019\u0003\u0001C\u0005\u0007+Aqa!\n\u0001\t\u0003\u0019)\u0002C\u0004\u0004(\u0001!\ta!\u0006\t\u000f\r%\u0002\u0001\"\u0001\u0004\u0016!911\u0006\u0001\u0005\u0002\rU\u0001bBB\u0017\u0001\u0011\u00051Q\u0003\u0005\b\u0007_\u0001A\u0011BB\u0019\u0011\u001d\u0019\t\u0005\u0001C\u0001\u0005{Dqaa\u0011\u0001\t\u0013\u0011iP\u0001\u0007TQ\u0006\u0014X\rZ*feZ,'O\u0003\u0002T)\u000611/\u001a:wKJT\u0011!V\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001L\u0018\t\u00033rk\u0011A\u0017\u0006\u00027\u0006)1oY1mC&\u0011QL\u0017\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005$\u0016!B;uS2\u001c\u0018BA2a\u0005\u001daunZ4j]\u001e\f!c\u001d5be\u0016$7+\u001a:wKJ\u001cuN\u001c4jOV\ta\r\u0005\u0002hQ6\t!+\u0003\u0002j%\nY1*\u00194lC\u000e{gNZ5h\u0003M\u0019\b.\u0019:fIN+'O^3s\u0007>tg-[4!\u0003EiW\r^1Qe>\u00048/\u00128tK6\u0014G.Z\u000b\u0002[B\u0011a\u000e_\u0007\u0002_*\u0011\u0001/]\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c(B\u0001:t\u0003!iW\r^1eCR\f'BA+u\u0015\t)h/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0006\u0019qN]4\n\u0005e|'AF'fi\u0006\u0004&o\u001c9feRLWm]#og\u0016l'\r\\3\u0002%5,G/\u0019)s_B\u001cXI\\:f[\ndW\rI\u0001\u0005i&lW-F\u0001~!\rq\u0018QA\u0007\u0002\u007f*\u0019\u0011-!\u0001\u000b\u0007\u0005\r1/\u0001\u0004d_6lwN\\\u0005\u0004\u0003\u000fy(\u0001\u0002+j[\u0016\fQ\u0001^5nK\u0002\n\u0001bX7fiJL7m]\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0005\u0003+\t\t!A\u0004nKR\u0014\u0018nY:\n\t\u0005e\u00111\u0003\u0002\b\u001b\u0016$(/[2t\u0003%yV.\u001a;sS\u000e\u001c\b%\u0001\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3\u0016\u0005\u0005\u0005\u0002CBA\u0012\u0003c\t)$\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003W\ti#\u0001\u0003vi&d'BAA\u0018\u0003\u0011Q\u0017M^1\n\t\u0005M\u0012Q\u0005\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003CA\u001c\u0003s\ti$!\u0013\u000e\u0005\u0005%\u0012\u0002BA\u001e\u0003S\u00111!T1q!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#\u0002BA\"\u0003[\tA\u0001\\1oO&!\u0011qIA!\u0005\u001dIe\u000e^3hKJ\u0004B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\ni#A\u0002oKRLA!a\u0015\u0002N\t\t\u0012J\\3u'>\u001c7.\u001a;BI\u0012\u0014Xm]:\u0002;\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sK\u0002\n\u0001CY8piN$(/\u00199TKJ4XM]:\u0016\u0005\u0005m\u0003CBA\u001c\u0003;\nI%\u0003\u0003\u0002`\u0005%\"AC\"pY2,7\r^5p]\u0006\t\"m\\8ugR\u0014\u0018\r]*feZ,'o\u001d\u0011\u0002'\u0019\fW\u000f\u001c;IC:$G.\u001a:GC\u000e$xN]=\u0016\u0005\u0005\u001d\u0004cA4\u0002j%\u0019\u00111\u000e*\u0003'\u0019\u000bW\u000f\u001c;IC:$G.\u001a:GC\u000e$xN]=\u0002)\u0019\fW\u000f\u001c;IC:$G.\u001a:GC\u000e$xN]=!\u00035\u0019xnY6fi\u001a\u000b7\r^8ssV\u0011\u00111\u000f\t\u0005\u0003k\nI(\u0004\u0002\u0002x)\u00111k]\u0005\u0005\u0003w\n9HA\nTKJ4XM]*pG.,GOR1di>\u0014\u00180\u0001\bt_\u000e\\W\r\u001e$bGR|'/\u001f\u0011\u0002\rqJg.\u001b;?)I\t\u0019)!\"\u0002\b\u0006%\u00151RAG\u0003\u001f\u000b\t*a%\u0011\u0005\u001d\u0004\u0001\"\u00023\u0012\u0001\u00041\u0007\"B6\u0012\u0001\u0004i\u0007\"B>\u0012\u0001\u0004i\bbBA\u0006#\u0001\u0007\u0011q\u0002\u0005\b\u0003;\t\u0002\u0019AA\u0011\u0011\u001d\t9&\u0005a\u0001\u00037Bq!a\u0019\u0012\u0001\u0004\t9\u0007C\u0004\u0002pE\u0001\r!a\u001d\u0002\u00151|wmQ8oi\u0016DH/\u0006\u0002\u0002\u001aB\u0019a0a'\n\u0007\u0005uuP\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u000591\u000f^1si\u0016$WCAAS!\rI\u0016qU\u0005\u0004\u0003SS&a\u0002\"p_2,\u0017M\\\u0001\fgR\f'\u000f^3e?\u0012*\u0017\u000f\u0006\u0003\u00020\u0006U\u0006cA-\u00022&\u0019\u00111\u0017.\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003o+\u0012\u0011!a\u0001\u0003K\u000b1\u0001\u001f\u00132\u0003!\u0019H/\u0019:uK\u0012\u0004\u0013\u0001D;tK\u0012\u0014\u0015P\u0011:pW\u0016\u0014\u0018\u0001E;tK\u0012\u0014\u0015P\u0011:pW\u0016\u0014x\fJ3r)\u0011\ty+!1\t\u0013\u0005]\u0006$!AA\u0002\u0005\u0015\u0016!D;tK\u0012\u0014\u0015P\u0011:pW\u0016\u0014\b%\u0001\tvg\u0016$')_\"p]R\u0014x\u000e\u001c7fe\u0006!Ro]3e\u0005f\u001cuN\u001c;s_2dWM]0%KF$B!a,\u0002L\"I\u0011qW\u000e\u0002\u0002\u0003\u0007\u0011QU\u0001\u0012kN,GMQ=D_:$(o\u001c7mKJ\u0004\u0013\u0001\u00042s_.,'oQ8oM&<\u0017!\u00042s_.,'oQ8oM&<\u0007%\u0001\td_:$(o\u001c7mKJ\u001cuN\u001c4jO\u0006\t2m\u001c8ue>dG.\u001a:D_:4\u0017n\u001a\u0011\u00023I,\u0017/^3ti\"\u000bg\u000e\u001a7feB{w\u000e\u001c$bGR|'/_\u000b\u0003\u00037\u00042aZAo\u0013\r\tyN\u0015\u0002\u001f\u0017\u000647.\u0019*fcV,7\u000f\u001e%b]\u0012dWM\u001d)p_24\u0015m\u0019;pef\f!D]3rk\u0016\u001cH\u000fS1oI2,'\u000fU8pY\u001a\u000b7\r^8ss\u0002\n1\"\\3ue&\u001c7o\u0018\u0013fcR!\u0011qVAt\u0011%\t9\fJA\u0001\u0002\u0004\ty!\u0001\u0005nKR\u0014\u0018nY:!Q\r)\u0013Q\u001e\t\u00043\u0006=\u0018bAAy5\nAao\u001c7bi&dW-A\u0006sC\u001a$X*\u00198bO\u0016\u0014XCAA|!\u0019\tI0a@\u0003\u00045\u0011\u00111 \u0006\u0004\u0003{$\u0016\u0001\u0002:bMRLAA!\u0001\u0002|\n\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\t\u0005\u0005\u000b\u0011I!\u0004\u0002\u0003\b)!\u00111AA<\u0013\u0011\u0011YAa\u0002\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u0003=\u0011\u0018M\u001a;NC:\fw-\u001a:`I\u0015\fH\u0003BAX\u0005#A\u0011\"a.(\u0003\u0003\u0005\r!a>\u0002\u0019I\fg\r^'b]\u0006<WM\u001d\u0011)\u0007!\ni/A\u0007ce>\\WM]'fiJL7m]\u000b\u0003\u00057\u0001BA!\b\u0003\"5\u0011!q\u0004\u0006\u0005\u0003+\t9(\u0003\u0003\u0003$\t}!a\u0005\"s_.,'oU3sm\u0016\u0014X*\u001a;sS\u000e\u001c\u0018!\u00052s_.,'/T3ue&\u001c7o\u0018\u0013fcR!\u0011q\u0016B\u0015\u0011%\t9LKA\u0001\u0002\u0004\u0011Y\"\u0001\bce>\\WM]'fiJL7m\u001d\u0011)\u0007-\ni/A\fd_:$(o\u001c7mKJ\u001cVM\u001d<fe6+GO]5dgV\u0011!1\u0007\t\u0005\u0005k\u0011i$\u0004\u0002\u00038)!\u0011Q\u0003B\u001d\u0015\r\u0011Yd]\u0001\u000bG>tGO]8mY\u0016\u0014\u0018\u0002\u0002B \u0005o\u0011\u0011dQ8oiJ|G\u000e\\3s\u001b\u0016$\u0018\rZ1uC6+GO]5dg\u0006Y2m\u001c8ue>dG.\u001a:TKJ4XM]'fiJL7m]0%KF$B!a,\u0003F!I\u0011qW\u0017\u0002\u0002\u0003\u0007!1G\u0001\u0019G>tGO]8mY\u0016\u00148+\u001a:wKJlU\r\u001e:jGN\u0004\u0003f\u0001\u0018\u0002n\u0006Yan\u001c3f\u001b\u0016$(/[2t+\t\u0011y\u0005\u0005\u0003\u0003\u001e\tE\u0013\u0002\u0002B*\u0005?\u00111BT8eK6+GO]5dg\u0006yan\u001c3f\u001b\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0003\u00020\ne\u0003\"CA\\a\u0005\u0005\t\u0019\u0001B(\u00031qw\u000eZ3NKR\u0014\u0018nY:!Q\r\t\u0014Q^\u0001\u0007Y>\fG-\u001a:\u0016\u0005\t\r\u0004\u0003\u0002B3\u0005[j!Aa\u001a\u000b\t\t}#\u0011\u000e\u0006\u0004\u0005W\u001a\u0018!B5nC\u001e,\u0017\u0002\u0002B8\u0005O\u0012a\"T3uC\u0012\fG/\u0019'pC\u0012,'/\u0001\u0006m_\u0006$WM]0%KF$B!a,\u0003v!I\u0011qW\u001a\u0002\u0002\u0003\u0007!1M\u0001\bY>\fG-\u001a:!Q\r!\u0014Q^\u0001\u0018g:\f\u0007o\u001d5piN$\u0015n]1cY\u0016$'+Z1t_:,\"Aa \u0011\r\t\u0005%q\u0011BF\u001b\t\u0011\u0019I\u0003\u0003\u0003\u0006\u0006\u0015\u0012AB1u_6L7-\u0003\u0003\u0003\n\n\r%aD!u_6L7MU3gKJ,gnY3\u0011\t\t5%1\u0014\b\u0005\u0005\u001f\u00139\nE\u0002\u0003\u0012jk!Aa%\u000b\u0007\tUe+\u0001\u0004=e>|GOP\u0005\u0004\u00053S\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0003\u001e\n}%AB*ue&twMC\u0002\u0003\u001aj\u000b\u0001d\u001d8baNDw\u000e^:ESN\f'\r\\3e%\u0016\f7o\u001c8!\u0003=\u0019h.\u00199tQ>$X)\\5ui\u0016\u0014XC\u0001BT!\u0011\u0011IKa,\u000e\u0005\t-&\u0002\u0002BW\u0005S\n\u0011\u0002];cY&\u001c\b.\u001a:\n\t\tE&1\u0016\u0002\u0010':\f\u0007o\u001d5pi\u0016k\u0017\u000e\u001e;fe\u0006\u00192O\\1qg\"|G/R7jiR,'o\u0018\u0013fcR!\u0011q\u0016B\\\u0011%\t9\fOA\u0001\u0002\u0004\u00119+\u0001\tt]\u0006\u00048\u000f[8u\u000b6LG\u000f^3sA!\u001a\u0011(!<\u0002#Mt\u0017\r]:i_R<UM\\3sCR|'/\u0006\u0002\u0003BB!!\u0011\u0016Bb\u0013\u0011\u0011)Ma+\u0003#Ms\u0017\r]:i_R<UM\\3sCR|'/A\u000bt]\u0006\u00048\u000f[8u\u000f\u0016tWM]1u_J|F%Z9\u0015\t\u0005=&1\u001a\u0005\n\u0003o[\u0014\u0011!a\u0001\u0005\u0003\f!c\u001d8baNDw\u000e^$f]\u0016\u0014\u0018\r^8sA!\u001aA(!<\u0002+5,G/\u00193bi\u0006du.\u00193fe6+GO]5dgV\u0011!Q\u001b\t\u0005\u0005/\u0014Y.\u0004\u0002\u0003Z*!\u0011Q\u0003B4\u0013\u0011\u0011iN!7\u0003+5+G/\u00193bi\u0006du.\u00193fe6+GO]5dg\u0006IR.\u001a;bI\u0006$\u0018\rT8bI\u0016\u0014X*\u001a;sS\u000e\u001cx\fJ3r)\u0011\tyKa9\t\u0013\u0005]f(!AA\u0002\tU\u0017AF7fi\u0006$\u0017\r^1M_\u0006$WM]'fiJL7m\u001d\u0011)\u0007}\ni/A\u0005dYV\u001cH/\u001a:JIV\u0011!1R\u0001\u0007]>$W-\u00133\u0016\u0005\tE\bcA-\u0003t&\u0019!Q\u001f.\u0003\u0007%sG/\u0001\u0004jgV\u001bX\r\u001a\u000b\u0003\u0003K\u000bab\u001d;beR4uN\u001d\"s_.,'\u000f\u0006\u0002\u00020\u0006\u00112\u000f^1si\u001a{'oQ8oiJ|G\u000e\\3s)\u0011\tyka\u0001\t\u000f\r\u0015A\t1\u0001\u0004\b\u0005aA.[:uK:,'/\u00138g_B!1\u0011BB\u0006\u001b\u0005\t\u0018bAB\u0007c\naA*[:uK:,'/\u00138g_\u0006i1\u000f^8q\r>\u0014(I]8lKJ\f\u0011c\u001d;pa\u001a{'oQ8oiJ|G\u000e\\3s\u0003]\u0011\u0018M\u001a;NC:\fw-\u001a:GCVdG\u000fS1oI2,'/\u0006\u0002\u0004\u0018A!1\u0011DB\u0010\u001b\t\u0019YB\u0003\u0003\u0004\u001e\u0005]\u0014!\u00024bk2$\u0018\u0002BB\u0011\u00077\u0011ABR1vYRD\u0015M\u001c3mKJ\f!$\\3uC\u0012\fG/\u0019'pC\u0012,'OR1vYRD\u0015M\u001c3mKJ\fQdY8oiJ|G\u000e\\3s'R\f'\u000f^;q\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001&S:LG/[1m\u0005J|7.\u001a:NKR\fG-\u0019;b\u0019>\fGMR1vYRD\u0015M\u001c3mKJ\f\u0011EZ1uC2\fVo\u001c:v[\u000e{g\u000e\u001e:pY2,'OR1vYRD\u0015M\u001c3mKJ\fAE\\8o\r\u0006$\u0018\r\\)v_J,XnQ8oiJ|G\u000e\\3s\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001f[\u0016$\u0018\rZ1uCB+(\r\\5tQ&twMR1vYRD\u0015M\u001c3mKJ\fQa\u001d;beR$B!a,\u00044!91Q\u0007(A\u0002\r]\u0012!\u00057jgR,g.\u001a:F]\u0012\u0004x.\u001b8ugB!1\u0011HB\u001f\u001b\t\u0019YDC\u0002\u0002~NLAaa\u0010\u0004<\tIQI\u001c3q_&tGo]\u0001\u0014K:\u001cXO]3O_R\u0014\u0016M\u001a;MK\u0006$WM]\u0001\u0005gR|\u0007\u000f")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaPropertiesEnsemble metaPropsEnsemble;
    private final Time time;
    private final Metrics _metrics;
    private final CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final FaultHandlerFactory faultHandlerFactory;
    private final ServerSocketFactory socketFactory;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private final KafkaConfig controllerConfig;
    private final KafkaRequestHandlerPoolFactory requestHandlerPoolFactory;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile ControllerMetadataMetrics controllerServerMetrics;
    private volatile NodeMetrics nodeMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDisabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private volatile MetadataLoaderMetrics metadataLoaderMetrics;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaPropertiesEnsemble metaPropsEnsemble() {
        return this.metaPropsEnsemble;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public Collection<InetSocketAddress> bootstrapServers() {
        return this.bootstrapServers;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public ServerSocketFactory socketFactory() {
        return this.socketFactory;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public KafkaRequestHandlerPoolFactory requestHandlerPoolFactory() {
        return this.requestHandlerPoolFactory;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public ControllerMetadataMetrics controllerServerMetrics() {
        return this.controllerServerMetrics;
    }

    public void controllerServerMetrics_$eq(ControllerMetadataMetrics x$1) {
        this.controllerServerMetrics = x$1;
    }

    public NodeMetrics nodeMetrics() {
        return this.nodeMetrics;
    }

    public void nodeMetrics_$eq(NodeMetrics x$1) {
        this.nodeMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    private AtomicReference<String> snapshotsDisabledReason() {
        return this.snapshotsDisabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    private SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    private void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    private MetadataLoaderMetrics metadataLoaderMetrics() {
        return this.metadataLoaderMetrics;
    }

    private void metadataLoaderMetrics_$eq(MetadataLoaderMetrics x$1) {
        this.metadataLoaderMetrics = x$1;
    }

    public String clusterId() {
        return (String)this.metaPropsEnsemble().clusterId().get();
    }

    public int nodeId() {
        return this.metaPropsEnsemble().nodeId().getAsInt();
    }

    private synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker() {
        if (!this.isUsed()) {
            this.start(Endpoints.empty());
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController(ListenerInfo listenerInfo) {
        if (!this.isUsed()) {
            Endpoints endpoints = Endpoints.fromInetSocketAddresses((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)CollectionConverters$.MODULE$.MapHasAsScala(listenerInfo.listeners()).asScala().map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String listenerName = (String)x0$1._1();
                    Endpoint endpoint = (Endpoint)x0$1._2();
                    return new Tuple2((Object)ListenerName.normalised((String)listenerName), (Object)InetSocketAddress.createUnresolved(endpoint.host(), endpoint.port()));
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
            this.start(endpoints);
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
            return;
        }
    }

    private FaultHandler raftManagerFaultHandler() {
        return this.faultHandlerFactory().build("raft manager", true, () -> {});
    }

    private FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)ProcessRole.ControllerRole), () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataLoaderFaultHandler$2(x$9)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$10 -> {
                    x$10.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler controllerStartupFaultHandler() {
        return this.faultHandlerFactory().build("controller startup", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$11 -> {
                    x$11.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "controller startup fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$initialBrokerMetadataLoadFaultHandler$2(x$12)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$13 -> {
                    x$13.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler fatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$14 -> {
                    x$14.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                this.snapshotsDisabledReason().compareAndSet(null, "quorum controller fatal fault");
                return;
            }
        });
    }

    public FaultHandler nonFatalQuorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$15 -> {
                    x$15.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                Option$.MODULE$.apply((Object)this.brokerMetrics()).foreach((Function1 & Serializable)x$16 -> BoxesRunTime.boxToLong((long)SharedServer.$anonfun$metadataPublishingFaultHandler$2(x$16)));
                Option$.MODULE$.apply((Object)this.controllerServerMetrics()).foreach((Function1 & Serializable)x$17 -> {
                    x$17.incrementMetadataErrorCount();
                    return BoxedUnit.UNIT;
                });
                return;
            }
        });
    }

    private synchronized void start(Endpoints listenerEndpoints) {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<ClientTelemetryExporterPlugin>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)ProcessRole.BrokerRole)) {
                this.brokerMetrics_$eq(new BrokerServerMetrics(this.metrics()));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)ProcessRole.ControllerRole)) {
                this.controllerServerMetrics_$eq(new ControllerMetadataMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry())));
            }
            DefaultExternalKRaftMetrics externalKRaftMetrics = new DefaultExternalKRaftMetrics((Option<BrokerServerMetrics>)Option$.MODULE$.apply((Object)this.brokerMetrics()), (Option<ControllerMetadataMetrics>)Option$.MODULE$.apply((Object)this.controllerServerMetrics()));
            KafkaRaftManager<ApiMessageAndVersion> _raftManager = new KafkaRaftManager<ApiMessageAndVersion>(this.clusterId(), this.sharedServerConfig(), (Uuid)((MetaProperties)this.metaPropsEnsemble().logDirProps().get(this.metaPropsEnsemble().metadataLogDir().get())).directoryId().get(), (RecordSerde<ApiMessageAndVersion>)new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), externalKRaftMetrics, (Option<String>)new Some((Object)("kafka-" + this.sharedServerConfig().nodeId() + "-raft")), this.controllerQuorumVotersFuture(), this.bootstrapServers(), listenerEndpoints, this.raftManagerFaultHandler());
            this.raftManager_$eq(_raftManager);
            _raftManager.startup();
            this.nodeMetrics_$eq(new NodeMetrics(this.metrics(), Predef$.MODULE$.Boolean2boolean(this.controllerConfig().unstableFeatureVersionsEnabled())));
            this.metadataLoaderMetrics_$eq(this.brokerMetrics() != null ? new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), elapsedNs -> this.brokerMetrics().updateBatchProcessingTime(Predef$.MODULE$.Long2long(elapsedNs)), batchSize -> this.brokerMetrics().updateBatchSize(Predef$.MODULE$.Integer2int(batchSize)), this.brokerMetrics().lastAppliedImageProvenance()) : new MetadataLoaderMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), x$18 -> {}, x$19 -> {}, new AtomicReference<MetadataProvenance>(MetadataProvenance.EMPTY)));
            MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.nodeId()).setTime(this.time()).setThreadNamePrefix("kafka-" + this.sharedServerConfig().nodeId() + "-").setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> _raftManager.client().highWatermark()).setMetrics(this.metadataLoaderMetrics());
            this.loader_$eq(loaderBuilder.build());
            this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.nodeId()).setRaftClient(_raftManager.client()).setMetrics(new SnapshotEmitterMetrics(Optional.of(KafkaYammerMetrics.defaultRegistry()), this.time())).build());
            this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDisabledReason()).setThreadNamePrefix("kafka-" + this.sharedServerConfig().nodeId() + "-").build());
            try {
                this.loader().installPublishers(Arrays.asList(this.snapshotGenerator())).get();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable)() -> t);
                throw new RuntimeException("Unable to install metadata publishers.", t);
            }
            _raftManager.client().register((RaftClient.Listener)this.loader());
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.stop();
            throw e;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        Option$.MODULE$.apply(this.raftManager()).foreach((Function1 & Serializable)_raftManager -> {
            SharedServer.$anonfun$ensureNotRaftLeader$1(this, _raftManager);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loader().beginShutdown(), this, Level.WARN);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.snapshotGenerator().beginShutdown(), this, Level.WARN);
        }
        Utils.closeQuietly((AutoCloseable)this.loader(), (String)"loader");
        this.loader_$eq(null);
        Utils.closeQuietly((AutoCloseable)this.metadataLoaderMetrics(), (String)"metadata loader metrics");
        this.metadataLoaderMetrics_$eq(null);
        Utils.closeQuietly((AutoCloseable)this.snapshotGenerator(), (String)"snapshot generator");
        this.snapshotGenerator_$eq(null);
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftManager().shutdown(), this, Level.WARN);
            this.raftManager_$eq(null);
        }
        Utils.closeQuietly((AutoCloseable)this.controllerServerMetrics(), (String)"controller server metrics");
        this.controllerServerMetrics_$eq(null);
        Utils.closeQuietly((AutoCloseable)this.brokerMetrics(), (String)"broker metrics");
        this.brokerMetrics_$eq(null);
        Utils.closeQuietly((AutoCloseable)this.nodeMetrics(), (String)"node metrics");
        this.nodeMetrics_$eq(null);
        Utils.closeQuietly((AutoCloseable)this.metrics(), (String)"metrics");
        this.metrics_$eq(null);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, Level.WARN);
        this.started_$eq(false);
    }

    public static final /* synthetic */ long $anonfun$metadataLoaderFaultHandler$2(BrokerServerMetrics x$9) {
        return x$9.metadataLoadErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$initialBrokerMetadataLoadFaultHandler$2(BrokerServerMetrics x$12) {
        return x$12.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ long $anonfun$metadataPublishingFaultHandler$2(BrokerServerMetrics x$16) {
        return x$16.metadataApplyErrorCount().getAndIncrement();
    }

    public static final /* synthetic */ void $anonfun$ensureNotRaftLeader$1(SharedServer $this, KafkaRaftManager _raftManager) {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> _raftManager.shutdown(), $this, Level.WARN);
        $this.raftManager_$eq(null);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaPropertiesEnsemble metaPropsEnsemble, Time time, Metrics _metrics, CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, FaultHandlerFactory faultHandlerFactory, ServerSocketFactory socketFactory) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaPropsEnsemble = metaPropsEnsemble;
        this.time = time;
        this._metrics = _metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.faultHandlerFactory = faultHandlerFactory;
        this.socketFactory = socketFactory;
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(sharedServerConfig.originals()));
        KafkaYammerMetrics.INSTANCE.configure(sharedServerConfig.originals());
        this.logContext = new LogContext("[SharedServer id=" + sharedServerConfig.nodeId() + "] ");
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = new KafkaConfig(sharedServerConfig.props(), false);
        this.controllerConfig = new KafkaConfig(sharedServerConfig.props(), false);
        this.requestHandlerPoolFactory = new KafkaRequestHandlerPoolFactory();
        this.metrics = _metrics;
        this.snapshotsDisabledReason = new AtomicReference<Object>(null);
    }
}

