/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.Watchable;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jnr.constants.platform.OpenFlags;
import jnr.posix.POSIX;
import jnr.posix.util.Platform;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyDir;
import org.jruby.RubyEncoding;
import org.jruby.RubyFileStat;
import org.jruby.RubyFileTest;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.API;
import org.jruby.api.Access;
import org.jruby.api.Check;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingCapable;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;
import org.jruby.util.io.IOEncodable;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;
import org.jruby.util.io.PosixShim;

@JRubyClass(name={"File"}, parent="IO", include={"FileTest"})
public class RubyFile
extends RubyIO
implements EncodingCapable {
    static final ByteList SLASH = RubyInteger.singleCharByteList((byte)47);
    static final ByteList BACKSLASH = RubyInteger.singleCharByteList((byte)92);
    private static final byte[] CLOSED_MESSAGE = new byte[]{32, 40, 99, 108, 111, 115, 101, 100, 41};
    private static final String URI_PREFIX_STRING = "^(uri|jar|file|classpath):([^:/]{2,}:([^:/]{2,}:)?)?";
    private static final Pattern ROOT_PATTERN = Pattern.compile("^(uri|jar|file|classpath):([^:/]{2,}:([^:/]{2,}:)?)?/?/?$");
    private static final int NULL_CHAR = 0;
    static final Pattern PROTOCOL_PATTERN = Pattern.compile("^(uri|jar|file|classpath):([^:/]{2,}:([^:/]{2,}:)?)?.*");
    private static final Pattern PROTOCOL_PREFIX_PATTERN = Pattern.compile("^(uri|jar|file|classpath):([^:/]{2,}:([^:/]{2,}:)?)?");
    private static final long serialVersionUID = 1L;
    public static final int LOCK_SH = 1;
    public static final int LOCK_EX = 2;
    public static final int LOCK_NB = 4;
    public static final int LOCK_UN = 8;
    private static final int FNM_NOESCAPE = 1;
    private static final int FNM_PATHNAME = 2;
    private static final int FNM_DOTMATCH = 4;
    private static final int FNM_CASEFOLD = 8;
    private static final int FNM_EXTGLOB = 16;
    private static final int FNM_SYSCASE = Platform.IS_WINDOWS ? 8 : 0;
    private static final String[] SLASHES = new String[]{"", "/", "//"};
    private static final Pattern URI_PREFIX = Pattern.compile("^(jar:)?[a-z]{2,}:(.*)");
    @Deprecated(since="9.0.0.0")
    protected String path;

    public static RubyClass createFileClass(ThreadContext context, RubyClass IO) {
        IRubyObject separator = Create.newString(context, SLASH).freeze(context);
        IRubyObject altSeparator = File.separatorChar == '\\' ? Create.newString(context, BACKSLASH).freeze(context) : context.nil;
        IRubyObject pathSeparator = Create.newString(context, RubyInteger.singleCharByteList((byte)File.pathSeparatorChar)).freeze(context);
        RubyClass File2 = (RubyClass)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "File", IO, RubyFile::new).reifiedClass(RubyFile.class)).kindOf(new RubyModule.JavaClassKindOf(RubyFile.class))).classIndex(ClassIndex.FILE)).defineMethods(context, RubyFile.class)).defineConstant(context, "SEPARATOR", separator)).defineConstant(context, "Separator", separator)).defineConstant(context, "ALT_SEPARATOR", altSeparator)).defineConstant(context, "PATH_SEPARATOR", pathSeparator);
        File2.singletonClass(context).defineMethods(context, RubyFileTest.FileTestFileMethods.class);
        Object FileConstants = ((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)File2.defineModuleUnder(context, "Constants").defineConstant(context, "RDONLY", Convert.asFixnum(context, OpenFlags.O_RDONLY.intValue()))).defineConstant(context, "WRONLY", Convert.asFixnum(context, OpenFlags.O_WRONLY.intValue()))).defineConstant(context, "RDWR", Convert.asFixnum(context, OpenFlags.O_RDWR.intValue()))).defineConstant(context, "APPEND", Convert.asFixnum(context, OpenFlags.O_APPEND.intValue()))).defineConstant(context, "CREAT", Convert.asFixnum(context, OpenFlags.O_CREAT.intValue()))).defineConstant(context, "EXCL", Convert.asFixnum(context, OpenFlags.O_EXCL.intValue()))).defineConstant(context, "TRUNC", Convert.asFixnum(context, OpenFlags.O_TRUNC.intValue()))).defineConstant(context, "NOCTTY", Convert.asFixnum(context, OpenFlags.O_NOCTTY.intValue()))).defineConstant(context, "SHARE_DELETE", Convert.asFixnum(context, ModeFlags.SHARE_DELETE))).defineConstant(context, "FNM_NOESCAPE", Convert.asFixnum(context, 1))).defineConstant(context, "FNM_CASEFOLD", Convert.asFixnum(context, 8))).defineConstant(context, "FNM_SYSCASE", Convert.asFixnum(context, FNM_SYSCASE))).defineConstant(context, "FNM_DOTMATCH", Convert.asFixnum(context, 4))).defineConstant(context, "FNM_PATHNAME", Convert.asFixnum(context, 2))).defineConstant(context, "FNM_EXTGLOB", Convert.asFixnum(context, 16))).defineConstant(context, "LOCK_SH", Convert.asFixnum(context, 1))).defineConstant(context, "LOCK_EX", Convert.asFixnum(context, 2))).defineConstant(context, "LOCK_NB", Convert.asFixnum(context, 4))).defineConstant(context, "LOCK_UN", Convert.asFixnum(context, 8))).defineConstant(context, "NULL", Create.newString(context, RubyFile.getNullDevice()));
        if (OpenFlags.O_NONBLOCK.defined()) {
            ((RubyModule)FileConstants).defineConstant(context, "NONBLOCK", Convert.asFixnum(context, OpenFlags.O_NONBLOCK.intValue()));
        } else if (Platform.IS_WINDOWS) {
            ((RubyModule)FileConstants).defineConstant(context, "NONBLOCK", Convert.asFixnum(context, 1));
        }
        if (!OpenFlags.O_BINARY.defined()) {
            ((RubyModule)FileConstants).defineConstant(context, "BINARY", Convert.asFixnum(context, 0));
        } else {
            ((RubyModule)FileConstants).defineConstant(context, "BINARY", Convert.asFixnum(context, OpenFlags.O_BINARY.intValue()));
        }
        if (OpenFlags.O_SYNC.defined()) {
            ((RubyModule)FileConstants).defineConstant(context, "SYNC", Convert.asFixnum(context, OpenFlags.O_SYNC.intValue()));
        }
        if (OpenFlags.O_NOFOLLOW.defined()) {
            ((RubyModule)FileConstants).defineConstant(context, "NOFOLLOW", Convert.asFixnum(context, OpenFlags.O_NOFOLLOW.intValue()));
        }
        if (OpenFlags.O_TMPFILE.defined()) {
            ((RubyModule)FileConstants).defineConstant(context, "TMPFILE", Convert.asFixnum(context, OpenFlags.O_TMPFILE.intValue()));
        }
        IO.include(context, (RubyModule)FileConstants);
        if (Platform.IS_WINDOWS) {
            File2.searchMethod("readlink").setNotImplemented(true);
            File2.searchMethod("mkfifo").setNotImplemented(true);
        }
        if (!Platform.IS_BSD) {
            File2.singletonClass(context).searchMethod("lchmod").setNotImplemented(true);
        }
        return File2;
    }

    private static String getNullDevice() {
        return Platform.IS_WINDOWS ? "NUL" : "/dev/null";
    }

    public RubyFile(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    RubyFile(Ruby runtime2, String path2, final Reader reader) {
        this(runtime2, path2, new InputStream(){

            @Override
            public int read() throws IOException {
                return reader.read();
            }
        });
    }

    public RubyFile(Ruby runtime2, String path2, InputStream in) {
        super(runtime2, runtime2.getFile(), Channels.newChannel(in));
        this.setPath(path2);
    }

    public RubyFile(Ruby runtime2, String path2, FileChannel channel) {
        super(runtime2, runtime2.getFile(), channel);
        this.setPath(path2);
    }

    @Override
    protected IRubyObject rbIoClose(ThreadContext context) {
        if (this.openFile.currentLock != null) {
            try {
                this.openFile.currentLock.release();
            }
            catch (IOException e) {
                throw context.runtime.newIOError(e.getMessage());
            }
        }
        return super.rbIoClose(context);
    }

    @JRubyMethod
    public IRubyObject flock(ThreadContext context, IRubyObject operation) {
        if (Platform.IS_SOLARIS) {
            return this.callMethod(context, "flock", operation);
        }
        int op1 = Convert.toInt(context, operation);
        OpenFile fptr = this.getOpenFileChecked();
        if (fptr.isWritable()) {
            this.flushRaw(context, false);
        }
        block6: while (fptr.threadFlock(context, op1) < 0) {
            switch (fptr.errno()) {
                case EAGAIN: 
                case EACCES: 
                case EWOULDBLOCK: {
                    if ((op1 & 4) != 0) {
                        return context.fals;
                    }
                    try {
                        context.getThread().sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        context.pollThreadEvents();
                    }
                    fptr.checkClosed();
                    continue block6;
                }
                case EINTR: {
                    continue block6;
                }
            }
            throw context.runtime.newErrnoFromErrno(fptr.errno(), fptr.getPath());
        }
        return Convert.asFixnum(context, 0);
    }

    @JRubyMethod(name={"initialize"}, required=1, optional=3, checkArity=false, visibility=Visibility.PRIVATE, keywords=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject fd;
        int callInfo = context.callInfo;
        IRubyObject keywords = IRRuntimeHelpers.receiveKeywords(context, args2, false, true, false);
        int maxArgs = keywords instanceof RubyHash ? 4 : 3;
        int argc = Arity.checkArgumentCount(context, args2, 1, maxArgs);
        if (this.openFile != null) {
            throw Error.runtimeError(context, "reinitializing File");
        }
        if (argc > 0 && argc <= 3 && !(fd = TypeConverter.convertToTypeWithCheck(context, args2[0], context.runtime.getFixnum(), RubyFile.sites((ThreadContext)context).to_int_checked)).isNil()) {
            IRRuntimeHelpers.setCallInfo(context, callInfo);
            return switch (argc) {
                case 1 -> super.initialize(context, fd, block);
                case 2 -> super.initialize(context, fd, args2[1], block);
                default -> super.initialize(context, fd, args2[1], args2[2], block);
            };
        }
        return this.openFile(context, args2);
    }

    @JRubyMethod
    public IRubyObject chmod(ThreadContext context, IRubyObject arg2) {
        this.checkClosed(context);
        int mode2 = Convert.toInt(context, arg2);
        String path2 = this.getPath();
        if (!new File(path2).exists()) {
            throw context.runtime.newErrnoENOENTError(path2);
        }
        return Convert.asFixnum(context, context.runtime.getPosix().chmod(path2, mode2));
    }

    @JRubyMethod
    public IRubyObject chown(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        this.checkClosed(context);
        int owner2 = !arg1.isNil() ? Convert.toInt(context, arg1) : -1;
        int group2 = !arg2.isNil() ? Convert.toInt(context, arg2) : -1;
        String path2 = this.getPath();
        if (!new File(path2).exists()) {
            throw context.runtime.newErrnoENOENTError(path2);
        }
        return Convert.asFixnum(context, context.runtime.getPosix().chown(path2, owner2, group2));
    }

    @JRubyMethod
    public IRubyObject atime(ThreadContext context) {
        this.checkClosed(context);
        return context.runtime.newFileStat(this.getPath(), false).atime(context);
    }

    @JRubyMethod(name={"ctime"})
    public IRubyObject ctime(ThreadContext context) {
        this.checkClosed(context);
        return context.runtime.newFileStat(this.getPath(), false).ctime(context);
    }

    @JRubyMethod(name={"birthtime"})
    public IRubyObject birthtime(ThreadContext context) {
        this.checkClosed(context);
        if (!(Platform.IS_WINDOWS || Platform.IS_BSD && !Platform.IS_OPENBSD)) {
            throw context.runtime.newNotImplementedError("birthtime() function is unimplemented on this machine");
        }
        FileTime btime = RubyFile.getBirthtimeWithNIO(this.getPath());
        if (btime != null) {
            return context.runtime.newTime(btime.toMillis());
        }
        return this.ctime(context);
    }

    public static final FileTime getBirthtimeWithNIO(String pathString) {
        Path path2 = Paths.get(pathString, new String[0]);
        PosixFileAttributeView view = Files.getFileAttributeView(path2, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        try {
            if (view != null) {
                return view.readAttributes().creationTime();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @JRubyMethod
    public IRubyObject lstat(ThreadContext context) {
        this.checkClosed(context);
        return context.runtime.newFileStat(this.getPath(), true);
    }

    @JRubyMethod
    public IRubyObject mtime(ThreadContext context) {
        this.checkClosed(context);
        return ((RubyFileStat)this.stat(context)).mtime(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject path(ThreadContext context, IRubyObject self2, IRubyObject str) {
        return RubyFile.get_path(context, str);
    }

    @Override
    public IRubyObject path(ThreadContext context) {
        return super.path(context);
    }

    @JRubyMethod
    public IRubyObject truncate(ThreadContext context, IRubyObject len) {
        long pos2 = Convert.toInt(context, len);
        OpenFile fptr = this.getOpenFileChecked();
        if (!fptr.isWritable()) {
            throw context.runtime.newIOError("not opened for writing");
        }
        this.flushRaw(context, false);
        if (pos2 < 0L) {
            throw context.runtime.newErrnoEINVALError(this.openFile.getPath());
        }
        if (fptr.posix.ftruncate(fptr.fd(), pos2) < 0) {
            throw context.runtime.newErrnoFromErrno(fptr.posix.getErrno(), fptr.getPath());
        }
        return Convert.asFixnum(context, 0);
    }

    @Override
    @JRubyMethod
    public RubyString inspect(ThreadContext context) {
        String path2 = this.openFile.getPath();
        ByteList str = new ByteList((path2 == null ? 4 : path2.length()) + 8);
        str.append(35).append(60);
        str.append(((RubyString)this.getMetaClass().getRealClass().to_s(context)).getByteList());
        str.append(58).append(path2 == null ? RubyNil.nilBytes : RubyEncoding.encodeUTF8(path2));
        if (!this.openFile.isOpen()) {
            str.append(CLOSED_MESSAGE);
        }
        str.append(62);
        str.setEncoding(UTF8Encoding.INSTANCE);
        return RubyString.newStringLight(context.runtime, str);
    }

    @JRubyMethod(meta=true)
    public static RubyString basename(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        return RubyFile.basenameImpl(context, (RubyClass)recv2, path2, null);
    }

    @JRubyMethod(meta=true)
    public static RubyString basename(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject ext2) {
        return RubyFile.basenameImpl(context, (RubyClass)recv2, path2, ext2 == context.nil ? null : ext2);
    }

    @Deprecated(since="9.2.0.0")
    public static IRubyObject basename(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject ext2 = args2.length > 1 && args2[1] != context.nil ? args2[1] : null;
        return RubyFile.basenameImpl(context, (RubyClass)recv2, args2[0], ext2);
    }

    private static RubyString basenameImpl(ThreadContext context, RubyClass klass, IRubyObject path2, IRubyObject ext2) {
        char c;
        int separatorChar = RubyFile.getSeparatorChar(context, klass);
        int altSeparatorChar = RubyFile.getAltSeparatorChar(context, klass);
        RubyString origString = RubyFile.get_path(context, path2);
        Encoding origEncoding = origString.getEncoding();
        String name2 = origString.toString();
        if (name2.endsWith(".jar!/") || ROOT_PATTERN.matcher(name2).matches()) {
            return (RubyString)path2;
        }
        if (Platform.IS_WINDOWS && name2.length() > 1 && name2.charAt(1) == ':' && Character.isLetter(name2.charAt(0))) {
            switch (name2.length()) {
                case 2: {
                    return RubyString.newEmptyString(context.runtime, origString.getEncoding());
                }
                case 3: {
                    return Create.newString(context, RubyString.encodeBytelist(name2.substring(2), origEncoding));
                }
            }
            switch (name2.charAt(2)) {
                case '/': 
                case '\\': {
                    break;
                }
                default: {
                    name2 = name2.substring(2);
                }
            }
        }
        while (name2.length() > 1 && (name2.charAt(name2.length() - 1) == separatorChar || name2.charAt(name2.length() - 1) == altSeparatorChar)) {
            name2 = name2.substring(0, name2.length() - 1);
        }
        int slashCount = 0;
        int length2 = name2.length();
        for (int i2 = length2 - 1; i2 >= 0 && ((c = name2.charAt(i2)) == separatorChar || c == altSeparatorChar); --i2) {
            ++slashCount;
        }
        if (slashCount > 0 && length2 > 1) {
            name2 = name2.substring(0, name2.length() - slashCount);
        }
        int index2 = name2.lastIndexOf(separatorChar);
        if (altSeparatorChar != 0) {
            index2 = Math.max(index2, name2.lastIndexOf(altSeparatorChar));
        }
        if (!StringSupport.contentEquals(name2, separatorChar) && !StringSupport.contentEquals(name2, altSeparatorChar) && index2 != -1) {
            name2 = name2.substring(index2 + 1);
        }
        if (ext2 != null) {
            String extStr = RubyString.stringValue(ext2).toString();
            if (".*".equals(extStr)) {
                index2 = name2.lastIndexOf(46);
                if (index2 > 0) {
                    name2 = name2.substring(0, index2);
                }
            } else if (name2.endsWith(extStr)) {
                name2 = name2.substring(0, name2.length() - extStr.length());
            }
        }
        return Create.newString(context, RubyString.encodeBytelist(name2, origEncoding));
    }

    private static int getSeparatorChar(ThreadContext context, RubyClass File2) {
        RubyString sep = RubyString.stringValue(File2.getConstant(context, "SEPARATOR"));
        return sep.getByteList().get(0);
    }

    private static int getAltSeparatorChar(ThreadContext context, RubyClass File2) {
        int n;
        IRubyObject sep = File2.getConstant(context, "ALT_SEPARATOR");
        if (sep instanceof RubyString) {
            RubyString sepStr = (RubyString)sep;
            n = sepStr.getByteList().get(0);
        } else {
            n = 0;
        }
        return n;
    }

    @JRubyMethod(required=2, rest=true, checkArity=false, meta=true)
    public static IRubyObject chmod(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, -1);
        int count2 = 0;
        int mode2 = Convert.toInt(context, args2[0]);
        int i2 = 1;
        while (i2 < argc) {
            JRubyFile filename2 = RubyFile.file(args2[i2]);
            if (!filename2.exists()) {
                throw context.runtime.newErrnoENOENTError(filename2.toString());
            }
            if (0 != context.runtime.getPosix().chmod(filename2.getAbsolutePath(), mode2)) {
                throw context.runtime.newErrnoFromLastPOSIXErrno();
            }
            ++i2;
            ++count2;
        }
        return Convert.asFixnum(context, count2);
    }

    @JRubyMethod(required=2, rest=true, checkArity=false, meta=true)
    public static IRubyObject chown(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, -1);
        int count2 = 0;
        int owner2 = !args2[0].isNil() ? Convert.toInt(context, args2[0]) : -1;
        int group2 = !args2[1].isNil() ? Convert.toInt(context, args2[1]) : -1;
        for (int i2 = 2; i2 < argc; ++i2) {
            JRubyFile filename2 = RubyFile.file(args2[i2]);
            if (!filename2.exists()) {
                throw context.runtime.newErrnoENOENTError(filename2.toString());
            }
            if (0 != context.runtime.getPosix().chown(filename2.getAbsolutePath(), owner2, group2)) {
                throw context.runtime.newErrnoFromLastPOSIXErrno();
            }
            ++count2;
        }
        return Convert.asFixnum(context, count2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject dirname(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        return RubyFile.dirnameCommon(context, RubyFile.get_path(context, path2), 1);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject dirname(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject arg1) {
        return RubyFile.dirnameCommon(context, RubyFile.get_path(context, path2), Convert.toInt(context, arg1));
    }

    private static RubyString dirnameCommon(ThreadContext context, RubyString filename2, int level2) {
        return Create.newString(context, RubyFile.dirname(context, filename2.asJavaString(), level2));
    }

    public static String dirname(ThreadContext context, String filename2) {
        return RubyFile.dirname(context, filename2, 1);
    }

    public static String dirname(ThreadContext context, String filename2, int level2) {
        char endChar;
        Object result2;
        boolean startsWithDriveLetterOnWindows;
        boolean startsWithUNCOnWindows;
        int idx;
        String separator;
        char separatorChar;
        if (level2 < 0) {
            throw Error.argumentError(context, "negative level: " + level2);
        }
        RubyClass File2 = Access.fileClass(context);
        IRubyObject sep = File2.getConstant(context, "SEPARATOR");
        if (sep instanceof RubyString && ((RubyString)sep).size() == 1) {
            separatorChar = ((RubyString)sep).getByteList().charAt(0);
            separator = separatorChar == '/' ? "/" : String.valueOf(separatorChar);
        } else {
            separator = sep.toString();
            separatorChar = separator.isEmpty() ? (char)'\u0000' : separator.charAt(0);
        }
        String altSeparator = null;
        char altSeparatorChar = '\u0000';
        IRubyObject rbAltSeparator = File2.getConstantNoConstMissing(context, "ALT_SEPARATOR");
        if (rbAltSeparator != null && rbAltSeparator != context.nil && !(altSeparator = rbAltSeparator.toString()).isEmpty()) {
            altSeparatorChar = altSeparator.charAt(0);
        }
        String name2 = filename2;
        if (altSeparator != null) {
            name2 = RubyFile.replace(filename2, altSeparator, separator);
        }
        boolean startsWithSeparator = false;
        if (!name2.isEmpty()) {
            boolean bl = startsWithSeparator = name2.charAt(0) == separatorChar;
        }
        if ((idx = name2.indexOf(".jar!")) != -1 && name2.startsWith(separator, idx + 5)) {
            int start2 = name2.indexOf("!" + separator) + 1;
            String path2 = RubyFile.dirname(context, name2.substring(start2));
            if (path2.equals(".") || path2.equals(separator)) {
                path2 = "";
            }
            return name2.substring(0, start2) + path2;
        }
        if (PROTOCOL_PATTERN.matcher(name2).matches()) {
            int start3 = name2.indexOf(":" + separator) + 2;
            String path3 = RubyFile.dirname(context, name2.substring(start3));
            if (path3.equals(".")) {
                path3 = "";
            }
            return name2.substring(0, start3) + path3;
        }
        int minPathLength = 1;
        boolean trimmedSlashes = false;
        boolean bl = startsWithUNCOnWindows = Platform.IS_WINDOWS && StringSupport.startsWith(name2, separatorChar, separatorChar);
        if (startsWithUNCOnWindows) {
            minPathLength = 2;
        }
        if (startsWithDriveLetterOnWindows = RubyFile.startsWithDriveLetterOnWindows(name2)) {
            minPathLength = 3;
        }
        while (name2.length() > minPathLength && name2.charAt(name2.length() - 1) == separatorChar) {
            trimmedSlashes = true;
            name2 = name2.substring(0, name2.length() - 1);
        }
        if (startsWithDriveLetterOnWindows && name2.length() == 2) {
            result2 = trimmedSlashes ? filename2.substring(0, 3) : filename2.substring(0, 2) + ".";
        } else {
            int index2 = name2.lastIndexOf(separator);
            if (index2 == -1) {
                if (startsWithDriveLetterOnWindows) {
                    return filename2.substring(0, 2) + ".";
                }
                return level2 == 0 ? name2 : ".";
            }
            if (index2 == 0) {
                return filename2.substring(0, 1);
            }
            if (startsWithDriveLetterOnWindows && index2 == 2) {
                ++index2;
            }
            if (startsWithUNCOnWindows) {
                index2 = filename2.length();
                List<String> split2 = StringSupport.split(name2, separatorChar);
                int pathSectionCount = 0;
                for (int i2 = 0; i2 < split2.size(); ++i2) {
                    if (split2.get(i2).isEmpty()) continue;
                    ++pathSectionCount;
                }
                if (pathSectionCount > 2) {
                    index2 = name2.lastIndexOf(separator);
                }
            }
            result2 = filename2.substring(0, index2);
            for (int i3 = level2 - 1; i3 > 0; --i3) {
                int _index = ((String)result2).lastIndexOf(separator);
                if (_index == 0) {
                    result2 = separator;
                    break;
                }
                if (_index == -1) continue;
                result2 = ((String)result2).substring(0, _index);
            }
        }
        if (startsWithSeparator && ((String)result2).length() > minPathLength) {
            while (((String)result2).length() > minPathLength && (((String)result2).charAt(minPathLength) == separatorChar || altSeparator != null && ((String)result2).charAt(minPathLength) == altSeparatorChar)) {
                result2 = ((String)result2).substring(1, ((String)result2).length());
            }
        }
        while (((String)result2).length() > minPathLength && ((endChar = ((String)result2).charAt(((String)result2).length() - 1)) == separatorChar || altSeparator != null && endChar == altSeparatorChar)) {
            result2 = ((String)result2).substring(0, ((String)result2).length() - 1);
        }
        return result2;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject extname(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        String filename2 = RubyFile.basename(context, recv2, arg2).toString();
        int dotIndex = filename2.indexOf(46);
        if (dotIndex < 0) {
            return Create.newEmptyString(context);
        }
        int length2 = filename2.length();
        if (dotIndex == length2 - 1 && length2 != 1) {
            return Create.newString(context, filename2.substring(dotIndex));
        }
        int e = dotIndex;
        ++e;
        while (e < length2) {
            if (filename2.charAt(e) != '.') {
                --e;
                break;
            }
            ++e;
        }
        if (e == length2) {
            return Create.newEmptyString(context);
        }
        for (int i2 = e; i2 < length2; ++i2) {
            char c = filename2.charAt(i2);
            if (c != '.' && c != ' ') continue;
            e = i2;
        }
        return e == 0 ? Create.newEmptyString(context) : Create.newString(context, filename2.substring(e));
    }

    @JRubyMethod(name={"expand_path"}, meta=true)
    public static IRubyObject expand_path(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        return RubyFile.expandPathInternal(context, path2, true, false);
    }

    @JRubyMethod(name={"expand_path"}, meta=true)
    public static IRubyObject expand_path(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject wd) {
        return RubyFile.expandPathInternal(context, path2, wd, true, false);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject absolute_path(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        return RubyFile.expandPathInternal(context, path2, false, false);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject absolute_path(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject dir) {
        return RubyFile.expandPathInternal(context, path2, dir, false, false);
    }

    @JRubyMethod(name={"absolute_path?"}, meta=true)
    public static IRubyObject absolute_path_p(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyString file2 = RubyFile.get_path(context, arg2);
        return Convert.asBoolean(context, RubyFile.isJRubyAbsolutePath(file2.asJavaString()));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject realdirpath(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        return RubyFile.expandPathInternal(context, path2, false, true);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject realdirpath(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject dir) {
        return RubyFile.expandPathInternal(context, path2, dir, false, true);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject realpath(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        return RubyFile.realPathCommon(context, RubyFile.get_path(context, path2), null);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject realpath(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject cwd) {
        return RubyFile.realPathCommon(context, RubyFile.get_path(context, path2), RubyFile.get_path(context, cwd));
    }

    private static RubyString realPathCommon(ThreadContext context, RubyString file2, RubyString cwd) {
        if (!RubyFileTest.exist(context, file2 = RubyFile.expandPathInternal(context, file2, cwd, false, true))) {
            throw context.runtime.newErrnoENOENTError(file2.toString());
        }
        return file2;
    }

    @JRubyMethod(name={"fnmatch", "fnmatch?"}, meta=true)
    public static IRubyObject fnmatch(ThreadContext context, IRubyObject recv2, IRubyObject _pattern, IRubyObject _path) {
        return RubyFile.fnmatchCommon(context, _pattern, _path, 0);
    }

    @JRubyMethod(name={"fnmatch", "fnmatch?"}, meta=true)
    public static IRubyObject fnmatch(ThreadContext context, IRubyObject recv2, IRubyObject _pattern, IRubyObject _path, IRubyObject _flags) {
        return RubyFile.fnmatchCommon(context, _pattern, _path, Convert.toInt(context, _flags));
    }

    private static RubyBoolean fnmatchCommon(ThreadContext context, IRubyObject _path, IRubyObject _pattern, int flags2) {
        boolean braces_match = false;
        boolean extglob = (flags2 & 0x10) != 0;
        ByteList pattern = Check.checkEmbeddedNulls(context, _path.convertToString()).getByteList();
        ByteList path2 = Check.checkEmbeddedNulls(context, RubyFile.get_path(context, _pattern)).getByteList();
        if (extglob) {
            String spattern = _path.asJavaString();
            ArrayList<String> patterns = Dir.braces(spattern, flags2, new ArrayList<String>());
            boolean matches = false;
            for (int i2 = 0; i2 < patterns.size(); ++i2) {
                matches |= RubyFile.dir_fnmatch(new ByteList(patterns.get(i2).getBytes()), path2, flags2);
            }
            braces_match = matches;
        }
        return braces_match || RubyFile.dir_fnmatch(pattern, path2, flags2) ? context.tru : context.fals;
    }

    private static boolean dir_fnmatch(ByteList pattern, ByteList path2, int flags2) {
        return Dir.fnmatch(pattern.getUnsafeBytes(), pattern.getBegin(), pattern.getBegin() + pattern.getRealSize(), path2.getUnsafeBytes(), path2.getBegin(), path2.getBegin() + path2.getRealSize(), flags2, path2.getEncoding()) == 0;
    }

    @JRubyMethod(name={"ftype"}, meta=true)
    public static IRubyObject ftype(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return context.runtime.newFileStat(RubyFile.get_path(context, filename2).toString(), true).ftype(context);
    }

    @JRubyMethod(rest=true, meta=true)
    public static RubyString join(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return RubyFile.doJoin(context, recv2, args2);
    }

    @JRubyMethod(name={"lstat"}, meta=true)
    public static IRubyObject lstat(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return context.runtime.newFileStat(RubyFile.get_path(context, filename2).toString(), true);
    }

    @JRubyMethod(name={"stat"}, meta=true)
    public static IRubyObject stat(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return context.runtime.newFileStat(RubyFile.get_path(context, filename2).toString(), false);
    }

    @JRubyMethod(name={"atime"}, meta=true)
    public static IRubyObject atime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return context.runtime.newFileStat(RubyFile.get_path(context, filename2).toString(), false).atime(context);
    }

    @JRubyMethod(name={"ctime"}, meta=true)
    public static IRubyObject ctime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return context.runtime.newFileStat(RubyFile.get_path(context, filename2).toString(), false).ctime(context);
    }

    @JRubyMethod(name={"birthtime"}, meta=true)
    public static IRubyObject birthtime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return context.runtime.newFileStat(RubyFile.get_path(context, filename2).toString(), false).birthtime(context);
    }

    @JRubyMethod(required=1, rest=true, checkArity=false, meta=true)
    public static IRubyObject lchmod(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, -1);
        int count2 = 0;
        int mode2 = Convert.toInt(context, args2[0]);
        int i2 = 1;
        while (i2 < argc) {
            JRubyFile file2 = RubyFile.file(args2[i2]);
            if (context.runtime.getPosix().lchmod(file2.toString(), mode2) != 0) {
                throw context.runtime.newErrnoFromLastPOSIXErrno();
            }
            ++i2;
            ++count2;
        }
        return Convert.asFixnum(context, count2);
    }

    @JRubyMethod(required=2, rest=true, checkArity=false, meta=true)
    public static IRubyObject lchown(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, -1);
        int owner2 = !args2[0].isNil() ? Convert.toInt(context, args2[0]) : -1;
        int group2 = !args2[1].isNil() ? Convert.toInt(context, args2[1]) : -1;
        int count2 = 0;
        for (int i2 = 2; i2 < argc; ++i2) {
            JRubyFile file2 = RubyFile.file(args2[i2]);
            if (0 != context.runtime.getPosix().lchown(file2.toString(), owner2, group2)) {
                throw context.runtime.newErrnoFromLastPOSIXErrno();
            }
            ++count2;
        }
        return Convert.asFixnum(context, count2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject link(ThreadContext context, IRubyObject recv2, IRubyObject from, IRubyObject to) {
        Ruby runtime2 = context.runtime;
        String fromStr = RubyFile.file(from).toString();
        String toStr = RubyFile.file(to).toString();
        int ret = runtime2.getPosix().link(fromStr, toStr);
        if (ret != 0) {
            if (runtime2.getPosix().isNative()) {
                throw runtime2.newErrnoFromInt(runtime2.getPosix().errno(), String.format("(%s, %s)", fromStr, toStr));
            }
            throw runtime2.newErrnoEEXISTError(fromStr + " or " + toStr);
        }
        return Convert.asFixnum(context, ret);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject mtime(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return context.runtime.newFileStat(RubyFile.get_path(context, filename2).toString(), false).mtime(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject rename(ThreadContext context, IRubyObject recv2, IRubyObject oldName, IRubyObject newName) {
        RubyString oldNameString = RubyFile.get_path(context, oldName);
        RubyString newNameString = RubyFile.get_path(context, newName);
        String newNameJavaString = newNameString.toString();
        String oldNameJavaString = oldNameString.toString();
        String cwd = context.runtime.getCurrentDirectory();
        JRubyFile oldFile = JRubyFile.create(cwd, oldNameJavaString);
        JRubyFile newFile = JRubyFile.create(cwd, newNameJavaString);
        boolean isOldSymlink = RubyFileTest.symlink_p(context, recv2, oldNameString).isTrue();
        if (!oldFile.exists() && !isOldSymlink || !newFile.getParentFile().exists()) {
            throw context.runtime.newErrnoENOENTError(oldNameJavaString + " or " + newNameJavaString);
        }
        JRubyFile dest = JRubyFile.create(cwd, newNameJavaString);
        if (oldFile.renameTo(dest)) {
            return Convert.asFixnum(context, 0);
        }
        if (newFile.exists()) {
            context.runtime.getPosix().chmod(newNameJavaString, 438);
            newFile.delete();
        }
        Path oldPath = Paths.get(oldFile.toURI());
        Path destPath = Paths.get(dest.getAbsolutePath(), new String[0]);
        try {
            Files.move(oldPath, destPath, StandardCopyOption.ATOMIC_MOVE);
            return Convert.asFixnum(context, 0);
        }
        catch (IOException ioe) {
            throw Helpers.newIOErrorFromException(context.runtime, ioe);
        }
    }

    @JRubyMethod(meta=true)
    public static RubyArray split(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        RubyString filename2 = RubyFile.get_path(context, arg2);
        return Create.newArray(context, RubyFile.dirname(context, recv2, filename2), (IRubyObject)RubyFile.basename(context, recv2, filename2));
    }

    @JRubyMethod(meta=true)
    public static IRubyObject symlink(ThreadContext context, IRubyObject recv2, IRubyObject from, IRubyObject to) {
        Ruby runtime2 = context.runtime;
        RubyString fromStr = RubyFile.get_path(context, from);
        RubyString toStr = RubyFile.get_path(context, to);
        String tovalue = toStr.toString();
        tovalue = JRubyFile.create(runtime2.getCurrentDirectory(), tovalue).getAbsolutePath();
        try {
            if (runtime2.getPosix().symlink(fromStr.toString(), tovalue) == -1) {
                if (runtime2.getPosix().isNative()) {
                    throw runtime2.newErrnoFromInt(runtime2.getPosix().errno(), String.format("(%s, %s)", fromStr, toStr));
                }
                throw runtime2.newErrnoEEXISTError(String.format("(%s, %s)", fromStr, toStr));
            }
        }
        catch (UnsatisfiedLinkError ule) {
            throw runtime2.newNotImplementedError("symlink() function is unimplemented on this machine");
        }
        return Convert.asFixnum(context, 0);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject readlink(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        Ruby runtime2 = context.runtime;
        if (Platform.IS_WINDOWS) {
            throw runtime2.newNotImplementedError("readlink");
        }
        JRubyFile link2 = RubyFile.file(path2);
        try {
            String realPath = runtime2.getPosix().readlink(link2.toString());
            if (realPath == null) {
                throw runtime2.newErrnoFromLastPOSIXErrno();
            }
            return RubyString.newString(runtime2, realPath, Access.encodingService(context).getFileSystemEncoding());
        }
        catch (IOException e) {
            throw runtime2.newIOError(e.getMessage());
        }
    }

    @Deprecated(since="10.0.0.0")
    public static IRubyObject truncate19(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2) {
        return RubyFile.truncate(context, recv2, path2, length2);
    }

    @JRubyMethod(name={"truncate"}, meta=true)
    public static IRubyObject truncate(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject length2) {
        return RubyFile.truncateCommon(context, recv2, RubyFile.get_path(context, path2), length2);
    }

    @JRubyMethod(meta=true, optional=1, checkArity=false)
    public static IRubyObject umask(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        int oldMask = argc == 0 ? PosixShim.umask(context.runtime.getPosix()) : PosixShim.umask(context.runtime.getPosix(), Convert.toInt(context, args2[0]));
        return Convert.asFixnum(context, oldMask);
    }

    @JRubyMethod(required=2, rest=true, checkArity=false, meta=true)
    public static IRubyObject lutime(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, -1);
        Ruby runtime2 = context.runtime;
        long[] atimeval = null;
        long[] mtimeval = null;
        if (args2[0] != context.nil || args2[1] != context.nil) {
            atimeval = RubyFile.convertTimespecToTimeval(RubyFile.extractTimespec(context, args2[0]));
            mtimeval = RubyFile.convertTimespecToTimeval(RubyFile.extractTimespec(context, args2[1]));
        }
        int j = argc;
        for (int i2 = 2; i2 < j; ++i2) {
            String filename2 = RubyFile.get_path(context, args2[i2]).toString();
            JRubyFile fileToTouch = JRubyFile.create(runtime2.getCurrentDirectory(), filename2);
            if (!fileToTouch.exists()) {
                throw runtime2.newErrnoENOENTError(filename2);
            }
            int result2 = runtime2.getPosix().lutimes(fileToTouch.getAbsolutePath(), atimeval, mtimeval);
            if (result2 != -1) continue;
            throw runtime2.newErrnoFromInt(runtime2.getPosix().errno());
        }
        return Convert.asFixnum(context, argc - 2);
    }

    @JRubyMethod(required=2, rest=true, checkArity=false, meta=true)
    public static IRubyObject utime(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, -1);
        Ruby runtime2 = context.runtime;
        long[] atimespec = null;
        long[] mtimespec = null;
        if (args2[0] != context.nil || args2[1] != context.nil) {
            atimespec = RubyFile.extractTimespec(context, args2[0]);
            mtimespec = RubyFile.extractTimespec(context, args2[1]);
        }
        int j = argc;
        for (int i2 = 2; i2 < j; ++i2) {
            int result2;
            String filename2 = RubyFile.get_path(context, args2[i2]).toString();
            JRubyFile fileToTouch = JRubyFile.create(runtime2.getCurrentDirectory(), filename2);
            if (!fileToTouch.exists()) {
                throw runtime2.newErrnoENOENTError(filename2);
            }
            try {
                result2 = runtime2.getPosix().utimensat(0, fileToTouch.getAbsolutePath(), atimespec, mtimespec, 0);
            }
            catch (NotImplementedError re) {
                result2 = runtime2.getPosix().utimes(fileToTouch.getAbsolutePath(), RubyFile.convertTimespecToTimeval(atimespec), RubyFile.convertTimespecToTimeval(mtimespec));
            }
            if (result2 != -1) continue;
            throw runtime2.newErrnoFromInt(runtime2.getPosix().errno());
        }
        return Convert.asFixnum(context, argc - 2);
    }

    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject delete(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            String filename2 = RubyFile.get_path(context, args2[i2]).toString();
            JRubyFile file2 = JRubyFile.create(context.runtime.getCurrentDirectory(), filename2);
            if (!file2.exists() && !RubyFile.isSymlink(context, file2)) {
                throw context.runtime.newErrnoENOENTError(filename2);
            }
            if (file2.isDirectory() && !RubyFile.isSymlink(context, file2)) {
                throw context.runtime.newErrnoEISDirError(filename2);
            }
            if (file2.delete()) continue;
            throw context.runtime.newErrnoEACCESError(filename2);
        }
        return Convert.asFixnum(context, args2.length);
    }

    private static boolean isSymlink(ThreadContext context, JRubyFile file2) {
        return FileResource.wrap(context.runtime.getPosix(), file2).isSymLink();
    }

    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject unlink(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        POSIX posix = context.runtime.getPosix();
        if (!posix.isNative() || Platform.IS_WINDOWS) {
            return RubyFile.delete(context, recv2, args2);
        }
        String cwd = context.runtime.getCurrentDirectory();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            String path2 = RubyFile.get_path(context, args2[i2]).toString();
            String toUnlink = JRubyFile.create(cwd, path2).getAbsolutePath();
            if (posix.unlink(toUnlink) >= 0) continue;
            throw context.runtime.newErrnoFromInt(posix.errno(), path2);
        }
        return Convert.asFixnum(context, args2.length);
    }

    public static IRubyObject unlink(ThreadContext context, IRubyObject ... args2) {
        return RubyFile.unlink(context, (IRubyObject)Access.fileClass(context), args2);
    }

    @JRubyMethod
    public IRubyObject size(ThreadContext context) {
        return Convert.asFixnum(context, this.getSize(context));
    }

    final long getSize(ThreadContext context) {
        OpenFile fptr = this.getOpenFileChecked();
        if ((fptr.getMode() & 2) != 0) {
            this.flushRaw(context, false);
        }
        return fptr.posix.size(fptr.fd());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject mkfifo(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
        if (Platform.IS_WINDOWS) {
            throw context.runtime.newNotImplementedError("mkfifo");
        }
        return RubyFile.mkfifo(context, RubyFile.get_path(context, path2), 438);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject mkfifo(ThreadContext context, IRubyObject recv2, IRubyObject path2, IRubyObject mode2) {
        if (Platform.IS_WINDOWS) {
            throw context.runtime.newNotImplementedError("mkfifo");
        }
        return RubyFile.mkfifo(context, RubyFile.get_path(context, path2), Convert.toInt(context, mode2));
    }

    public static IRubyObject mkfifo(ThreadContext context, RubyString path2, int mode2) {
        Ruby runtime2 = context.runtime;
        String decodedPath = JRubyFile.createResource(runtime2, path2.toString()).absolutePath();
        if (runtime2.getPosix().mkfifo(decodedPath, mode2) != 0) {
            throw runtime2.newErrnoFromInt(runtime2.getPosix().errno(), decodedPath);
        }
        return RubyFixnum.zero(runtime2);
    }

    @Override
    public Encoding getEncoding() {
        return null;
    }

    @Override
    public void setEncoding(Encoding encoding2) {
    }

    protected IRubyObject openFile(ThreadContext context, IRubyObject[] args2) {
        API.ModeAndPermission pm = new API.ModeAndPermission(null, null);
        IRubyObject options2 = context.nil;
        switch (args2.length) {
            case 1: {
                break;
            }
            case 2: {
                IRubyObject test2 = TypeConverter.checkHashType(context.runtime, args2[1]);
                if (test2 instanceof RubyHash) {
                    options2 = test2;
                    break;
                }
                EncodingUtils.vmode(pm, args2[1]);
                break;
            }
            case 3: {
                IRubyObject test2 = TypeConverter.checkHashType(context.runtime, args2[2]);
                if (test2 instanceof RubyHash) {
                    options2 = test2;
                } else {
                    EncodingUtils.vperm(pm, args2[2]);
                }
                EncodingUtils.vmode(pm, args2[1]);
                break;
            }
            case 4: {
                if (!args2[3].isNil() && (options2 = TypeConverter.convertToTypeWithCheck(context, args2[3], Access.hashClass(context), RubyFile.sites((ThreadContext)context).to_hash_checked)).isNil()) {
                    throw Error.argumentError(context, 4, 1, 3);
                }
                EncodingUtils.vperm(pm, args2[2]);
                EncodingUtils.vmode(pm, args2[1]);
            }
        }
        int[] oflags_p = new int[]{0};
        int[] fmode_p = new int[]{0};
        IOEncodable.ConvConfig convconfig = new IOEncodable.ConvConfig();
        EncodingUtils.extractModeEncoding(context, (IOEncodable)convconfig, pm, options2, oflags_p, fmode_p);
        int perm = EncodingUtils.vperm(pm) != null && !EncodingUtils.vperm(pm).isNil() ? Convert.toInt(context, EncodingUtils.vperm(pm)) : 438;
        return this.fileOpenGeneric(context, args2[0], oflags_p[0], fmode_p[0], convconfig, perm);
    }

    public IRubyObject fileOpenGeneric(ThreadContext context, IRubyObject filename2, int oflags, int fmode, IOEncodable convConfig, int perm) {
        Ruby runtime2 = context.runtime;
        if (convConfig == null) {
            convConfig = new IOEncodable.ConvConfig();
            EncodingUtils.ioExtIntToEncs(context, convConfig, null, null, fmode);
            convConfig.setEcflags(0);
            convConfig.setEcopts(context.nil);
        }
        int[] fmode_p = new int[]{fmode};
        EncodingUtils.validateEncodingBinmode(context, fmode_p, convConfig.getEcflags(), convConfig);
        OpenFile fptr = this.MakeOpenFile();
        fptr.setMode(fmode_p[0]);
        fptr.encs.copy(convConfig);
        fptr.setPath(RubyFile.adjustRootPathOnWindows(runtime2, RubyFile.getDecodedPath(context, filename2), runtime2.getCurrentDirectory()));
        fptr.setFD(RubyFile.sysopen(runtime2, fptr.getPath(), oflags, perm));
        fptr.checkTTY();
        if ((fmode_p[0] & 0x100000) != 0) {
            EncodingUtils.ioSetEncodingByBOM(context, this);
        }
        return this;
    }

    public static String getAdjustedPath(ThreadContext context, IRubyObject fileOrPath) {
        return RubyFile.getAdjustedPath(context, fileOrPath, context.runtime.getCurrentDirectory());
    }

    public static String getAdjustedPath(ThreadContext context, IRubyObject fileOrPath, String currentDirectory) {
        Ruby runtime2 = context.runtime;
        return RubyFile.adjustRootPathOnWindows(runtime2, RubyFile.getDecodedPath(context, fileOrPath), currentDirectory);
    }

    public static RubyString get_path(ThreadContext context, IRubyObject path2) {
        if (path2 instanceof RubyString) {
            return Check.checkEmbeddedNulls(context, path2);
        }
        JavaSites.FileSites sites = RubyFile.sites(context);
        if (sites.respond_to_to_path.respondsTo(context, path2, path2, true)) {
            path2 = sites.to_path.call(context, path2, path2);
        }
        return RubyFile.filePathConvert(context, path2.convertToString());
    }

    protected static RubyString filePathConvert(ThreadContext context, RubyString path2) {
        Check.checkEmbeddedNulls(context, path2);
        if (!Platform.IS_WINDOWS) {
            EncodingService encodingService = Access.encodingService(context);
            Encoding pathEncoding = path2.getEncoding();
            if (context.runtime.getDefaultInternalEncoding() != null && pathEncoding != encodingService.getUSAsciiEncoding() && pathEncoding != encodingService.getAscii8bitEncoding() && pathEncoding != encodingService.getFileSystemEncoding() && !path2.isAsciiOnly()) {
                path2 = EncodingUtils.strConvEnc(context, path2, pathEncoding, encodingService.getFileSystemEncoding());
            }
        }
        return path2;
    }

    public static FileResource fileResource(ThreadContext context, IRubyObject pathOrFile) {
        return JRubyFile.createResource(context.runtime, RubyFile.getDecodedPath(context, pathOrFile));
    }

    @Deprecated(since="9.4-")
    public static FileResource fileResource(IRubyObject pathOrFile) {
        return RubyFile.fileResource(((RubyBasicObject)pathOrFile).getCurrentContext(), pathOrFile);
    }

    private static String getDecodedPath(ThreadContext context, IRubyObject pathOrFile) {
        String decodedPath;
        if (pathOrFile instanceof RubyFile) {
            decodedPath = ((RubyFile)pathOrFile).getPath();
        } else if (pathOrFile instanceof RubyIO) {
            decodedPath = ((RubyIO)pathOrFile).openFile.getPath();
        } else {
            RubyString path2 = RubyFile.get_path(context, pathOrFile);
            if (path2.getEncoding() == ASCIIEncoding.INSTANCE) {
                ByteList pathBL = path2.getByteList();
                decodedPath = new String(pathBL.unsafeBytes(), pathBL.begin(), pathBL.realSize());
            } else {
                decodedPath = path2.toString();
            }
        }
        return decodedPath;
    }

    @Deprecated(since="1.7.11")
    public static JRubyFile file(IRubyObject pathOrFile) {
        return RubyFile.fileResource(((RubyBasicObject)pathOrFile).getCurrentContext(), pathOrFile).unwrap(JRubyFile.class);
    }

    @Override
    public String toString() {
        return "RubyFile(" + this.openFile.getPath() + ", " + this.openFile.getMode() + ")";
    }

    private static ZipEntry getFileEntry(ZipFile jar, String path2, String prefixForNoEntry) throws IOException {
        ZipEntry entry = jar.getEntry(path2);
        if (entry == null) {
            path2 = new File(path2).getCanonicalPath().substring(prefixForNoEntry.length() + 1);
            entry = jar.getEntry(StringSupport.replaceAll(path2, "\\\\", "/").toString());
        }
        return entry;
    }

    @Deprecated(since="9.1.11.0")
    public static ZipEntry getDirOrFileEntry(String jar, String path2) throws IOException {
        return RubyFile.getDirOrFileEntry(new JarFile(jar), path2);
    }

    @Deprecated(since="9.2.0.0")
    public static ZipEntry getDirOrFileEntry(ZipFile jar, String path2) throws IOException {
        String dirPath = path2 + "/";
        ZipEntry entry = jar.getEntry(dirPath);
        if (entry == null) {
            if (dirPath.length() == 1) {
                return new ZipEntry(dirPath);
            }
            String prefix = new File(".").getCanonicalPath();
            entry = jar.getEntry(new File(dirPath).getCanonicalPath().substring(prefix.length() + 1).replaceAll("\\\\", "/"));
            if (entry == null) {
                Enumeration<? extends ZipEntry> entries2 = jar.entries();
                while (entries2.hasMoreElements()) {
                    String zipEntry = entries2.nextElement().getName();
                    if (!zipEntry.startsWith(dirPath)) continue;
                    return new ZipEntry(dirPath);
                }
            }
            if (entry == null) {
                entry = RubyFile.getFileEntry(jar, path2, prefix);
            }
        }
        return entry;
    }

    private static boolean isAbsolutePath(String path2) {
        return path2 != null && path2.length() > 1 && path2.charAt(0) == '/' || RubyFile.startsWithDriveLetterOnWindows(path2);
    }

    private static boolean isJRubyAbsolutePath(String path2) {
        return RubyFile.isAbsolutePath(path2) || path2.startsWith("classpath:/") || path2.startsWith("classpath:uri:/") || path2.startsWith("uri:/") || path2.startsWith("uri:classloader:/") || path2.startsWith("uri:file:/") || path2.startsWith("file:/") || path2.contains(".jar!/");
    }

    private static boolean isWindowsDriveLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static boolean startsWithDriveLetterOnWindows(String path2) {
        return RubyFile.startsWithDriveLetterOnWindows((CharSequence)path2);
    }

    static boolean startsWithDriveLetterOnWindows(CharSequence path2) {
        return path2 != null && Platform.IS_WINDOWS && (path2.length() > 1 && path2.charAt(0) == '/' ? path2.length() > 2 && RubyFile.isWindowsDriveLetter(path2.charAt(1)) && path2.charAt(2) == ':' : path2.length() > 1 && RubyFile.isWindowsDriveLetter(path2.charAt(0)) && path2.charAt(1) == ':');
    }

    static String adjustRootPathOnWindows(Ruby runtime2, String path2, String dir) {
        if (path2 == null || !Platform.IS_WINDOWS) {
            return path2;
        }
        if (StringSupport.startsWith((CharSequence)path2, '/') && (((String)path2).length() <= 2 || ((String)path2).charAt(2) != ':') || StringSupport.startsWith((CharSequence)path2, '\\')) {
            if (((String)path2).length() > 1 && (((String)path2).charAt(1) == '/' || ((String)path2).charAt(1) == '\\')) {
                return path2;
            }
            if (!RubyFile.startsWithDriveLetterOnWindows(dir)) {
                dir = runtime2.getCurrentDirectory();
            }
            if (dir.length() >= 2) {
                path2 = dir.substring(0, 2) + (String)path2;
            }
        } else if (RubyFile.startsWithDriveLetterOnWindows((String)path2) && ((String)path2).length() == 2) {
            path2 = (String)path2 + "/";
        }
        return path2;
    }

    private static long[] extractTimespec(ThreadContext context, IRubyObject value2) {
        long[] timespec = new long[2];
        if (value2 instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)value2;
            timespec[0] = Platform.IS_32_BIT ? (long)flote.asInt(context) : flote.asLong(context);
            double fraction = flote.asDouble(context) % 1.0;
            timespec[1] = (long)(fraction * 1.0E9 + 0.5);
        } else if (value2 instanceof RubyNumeric) {
            RubyNumeric numeric = (RubyNumeric)value2;
            timespec[0] = Platform.IS_32_BIT ? (long)numeric.asInt(context) : numeric.asLong(context);
            timespec[1] = 0L;
        } else {
            RubyTime t;
            RubyTime time = value2 instanceof RubyTime ? (t = (RubyTime)value2) : (RubyTime)TypeConverter.convertToType(context, value2, Access.timeClass(context), RubyFile.sites((ThreadContext)context).to_time_checked, true);
            timespec[0] = Platform.IS_32_BIT ? (long)time.to_i(context).asInt(context) : time.to_i(context).asLong(context);
            timespec[1] = Platform.IS_32_BIT ? (long)time.nsec(context).asInt(context) : time.nsec(context).asLong(context);
        }
        return timespec;
    }

    private static long[] convertTimespecToTimeval(long[] timespec) {
        if (timespec == null) {
            return null;
        }
        long[] timeval = new long[]{timespec[0], timespec[1] / 1000L};
        return timeval;
    }

    private void checkClosed(ThreadContext context) {
        this.openFile.checkClosed();
    }

    private static RubyString expandPathInternal(ThreadContext context, IRubyObject arg0, boolean expandUser, boolean canonicalize) {
        return RubyFile.expandPathInternal(context, arg0, null, expandUser, canonicalize);
    }

    private static RubyString expandPathInternal(ThreadContext context, IRubyObject _path, IRubyObject _wd, boolean expandUser, boolean canonicalize) {
        RubyString path2 = RubyFile.get_path(context, _path);
        RubyString wd = null;
        if (_wd != null && _wd != context.nil && !(_wd instanceof RubyHash)) {
            wd = RubyFile.get_path(context, _wd);
        }
        return RubyFile.expandPathInternal(context, path2, wd, expandUser, canonicalize);
    }

    static RubyString expandPathInternal(ThreadContext context, RubyString path2, RubyString wd, boolean expandUser, boolean canonicalize) {
        String cwd;
        String relativePath;
        ByteList wdByteList;
        boolean useISO = false;
        ByteList pathByteList = path2.getByteList();
        ByteList byteList = wdByteList = wd == null ? null : wd.getByteList();
        if (pathByteList.getEncoding() == ASCIIEncoding.INSTANCE || wd != null && wd.getByteList().getEncoding() == ASCIIEncoding.INSTANCE) {
            useISO = true;
            relativePath = RubyEncoding.decodeRaw(pathByteList);
            cwd = wd == null ? null : RubyEncoding.decodeRaw(wdByteList);
        } else {
            relativePath = path2.toString();
            cwd = wd == null ? null : wd.toString();
        }
        Encoding[] enc = new Encoding[]{path2.getEncoding()};
        String expanded = RubyFile.expandPath(context, relativePath, enc, cwd, expandUser, canonicalize);
        ByteList expandedByteList = useISO ? new ByteList(expanded.getBytes(StandardCharsets.ISO_8859_1), enc[0], false) : new ByteList(expanded.getBytes(enc[0].getCharset()), enc[0], false);
        return Create.newString(context, expandedByteList);
    }

    public static String expandPath(ThreadContext context, String relativePath, Encoding[] enc, String cwd, boolean expandUser, boolean canonicalize) {
        CharSequence realPath;
        String absolutePath;
        JRubyFile pathFile;
        Ruby runtime2 = context.runtime;
        Encoding fsenc = Access.encodingService(context).getFileSystemEncoding();
        if (Platform.IS_WINDOWS && ("NUL:".equalsIgnoreCase(relativePath) || "NUL".equalsIgnoreCase(relativePath))) {
            enc[0] = fsenc;
            return StringSupport.concat("//./", relativePath.substring(0, 3));
        }
        Object preFix = "";
        if (relativePath.startsWith("file:")) {
            preFix = "file:";
            relativePath = relativePath.substring(5);
        }
        String postFix = "";
        Matcher protocol2 = PROTOCOL_PREFIX_PATTERN.matcher(relativePath);
        if (relativePath.contains(".jar!/")) {
            if (protocol2.find()) {
                preFix = protocol2.group();
                int extra = 0;
                if (relativePath.contains("file://")) {
                    extra = 2;
                    preFix = (String)preFix + "//";
                }
                relativePath = relativePath.substring(protocol2.end() + extra);
            }
            int index2 = relativePath.indexOf("!/");
            postFix = relativePath.substring(index2);
            relativePath = relativePath.substring(0, index2);
        } else if (protocol2.find()) {
            boolean classloaderURI;
            preFix = protocol2.group();
            int offset2 = protocol2.end();
            String extra = "";
            int index3 = relativePath.indexOf("file://");
            boolean bl = classloaderURI = ((String)preFix).equals("uri:classloader:") || ((String)preFix).equals("classpath:");
            if (index3 >= 0) {
                if (relativePath.length() > (index3 += 7) && relativePath.charAt(index3) == '/') {
                    offset2 += 2;
                    extra = "//";
                } else {
                    ++offset2;
                    extra = "/";
                }
            } else if (classloaderURI && relativePath.startsWith("//", offset2)) {
                ++offset2;
            }
            relativePath = relativePath.substring(offset2);
            if (classloaderURI) {
                String fakePrefix = Platform.IS_WINDOWS ? "C:/FAKEPATH_PREFIX__" : "/FAKEPATH_PREFIX__";
                relativePath = RubyFile.canonicalizePath(fakePrefix + "/" + relativePath).substring(fakePrefix.length());
            } else {
                relativePath = RubyFile.canonicalizePath(relativePath);
            }
            if (Platform.IS_WINDOWS) {
                if (!((String)preFix).contains("file:") && RubyFile.startsWithDriveLetterOnWindows(relativePath)) {
                    relativePath = relativePath.substring(2);
                }
                if (classloaderURI) {
                    relativePath = relativePath.replace('\\', '/');
                }
            }
            return RubyFile.concatStrings((String)preFix, extra, relativePath);
        }
        String[] uriParts = RubyFile.splitURI(relativePath);
        if (expandUser && StringSupport.startsWith((CharSequence)relativePath, '~')) {
            enc[0] = fsenc;
            relativePath = RubyFile.expandUserPath(context, relativePath, true);
        }
        if (uriParts != null) {
            if (uriParts[0].equals("classpath:")) {
                return RubyFile.concatStrings((String)preFix, relativePath, postFix);
            }
            relativePath = uriParts[1];
        }
        if (cwd != null) {
            enc[0] = fsenc;
            if (!cwd.startsWith("uri:")) {
                boolean startsWithSlashNotOnWindows;
                if (expandUser) {
                    cwd = RubyFile.expandUserPath(context, cwd, true);
                }
                String[] cwdURIParts = RubyFile.splitURI(cwd);
                if (uriParts == null && cwdURIParts != null) {
                    uriParts = cwdURIParts;
                    cwd = cwdURIParts[1];
                }
                boolean bl = startsWithSlashNotOnWindows = (cwd = RubyFile.adjustRootPathOnWindows(runtime2, cwd, null)) != null && !Platform.IS_WINDOWS && !cwd.isEmpty() && cwd.charAt(0) == '/';
                if (!startsWithSlashNotOnWindows && !RubyFile.startsWithDriveLetterOnWindows(cwd)) {
                    if (cwd.length() == 0) {
                        cwd = ".";
                    }
                    cwd = JRubyFile.create(runtime2.getCurrentDirectory(), cwd).getAbsolutePath();
                }
            }
        } else {
            cwd = runtime2.getCurrentDirectory();
        }
        assert (cwd != null);
        String padSlashes = "";
        if (uriParts != null) {
            padSlashes = uriParts[0];
        } else if (!Platform.IS_WINDOWS) {
            padSlashes = !relativePath.isEmpty() && relativePath.charAt(0) == '/' ? RubyFile.countSlashes(relativePath) : RubyFile.countSlashes(cwd);
        }
        if (relativePath.isEmpty()) {
            pathFile = JRubyFile.create(relativePath, cwd);
        } else {
            relativePath = RubyFile.adjustRootPathOnWindows(runtime2, relativePath, cwd);
            pathFile = JRubyFile.create(cwd, relativePath);
        }
        CharSequence canonicalPath = null;
        if (Platform.IS_WINDOWS && uriParts != null && "classpath:".equals(uriParts[0]) && (absolutePath = pathFile.getAbsolutePath()).length() >= 2 && absolutePath.charAt(1) == ':') {
            canonicalPath = RubyFile.canonicalize(null, absolutePath.substring(2));
        }
        if (canonicalPath == null) {
            canonicalPath = RubyFile.canonicalize(null, pathFile.getAbsolutePath());
        }
        if (padSlashes.isEmpty()) {
            realPath = canonicalPath;
        } else {
            realPath = StringSupport.concat((CharSequence)padSlashes, canonicalPath);
            if (((String)preFix).length() > 0 && padSlashes.startsWith("file:")) {
                realPath = realPath.toString().substring(5);
            }
        }
        if (canonicalize) {
            realPath = RubyFile.canonicalNormalized(realPath);
        }
        if (postFix.contains("..")) {
            postFix = RubyFile.adjustPostFixDotDot(postFix);
        }
        return RubyFile.concatStrings((String)preFix, realPath, postFix);
    }

    private static String canonicalNormalized(CharSequence realPath) {
        String path2 = realPath.toString();
        try {
            return JRubyFile.normalizeSeps(new File(path2).getCanonicalPath());
        }
        catch (IOException ioe) {
            return path2;
        }
    }

    private static String adjustPostFixDotDot(String postFix) {
        postFix = "!" + RubyFile.canonicalizePath(((String)postFix).substring(1));
        if (Platform.IS_WINDOWS && RubyFile.startsWithDriveLetterOnWindows(((String)(postFix = ((String)postFix).replace('\\', '/'))).substring(1))) {
            postFix = "!" + ((String)postFix).substring(3);
        }
        return postFix;
    }

    private static String concatStrings(String s1, CharSequence s2, String s3) {
        return new StringBuilder(s1.length() + s2.length() + s3.length()).append(s1).append(s2).append(s3).toString();
    }

    private static String canonicalizePath(String path2) {
        try {
            return new File(path2).getCanonicalPath();
        }
        catch (IOException ignore) {
            return path2;
        }
    }

    public static String[] splitURI(String path2) {
        Matcher m = URI_PREFIX.matcher(path2);
        if (m.find()) {
            if (m.group(2).length() == 0) {
                return new String[]{path2, ""};
            }
            String pathWithoutJarPrefix = m.group(1) != null ? path2.substring(4) : path2;
            try {
                URI u = new URI(pathWithoutJarPrefix);
                String pathPart = u.getPath();
                return new String[]{path2.substring(0, path2.indexOf(pathPart)), pathPart};
            }
            catch (Exception e) {
                try {
                    URL u = new URL(pathWithoutJarPrefix);
                    String pathPart = u.getPath();
                    return new String[]{path2.substring(0, path2.indexOf(pathPart)), pathPart};
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String expandUserPath(ThreadContext context, String path2) {
        return RubyFile.expandUserPath(context, path2, false);
    }

    public static String expandUserPath(ThreadContext context, String path2, boolean raiseOnRelativePath) {
        int pathLength = ((String)path2).length();
        if (StringSupport.startsWith((CharSequence)path2, '~')) {
            int userEnd = ((String)path2).indexOf(47);
            if (userEnd == -1) {
                if (pathLength == 1) {
                    path2 = RubyDir.getHomeDirectoryPath(context, RubyFile.checkHome(context)).toString();
                    if (raiseOnRelativePath && !RubyFile.isAbsolutePath((String)path2)) {
                        throw Error.argumentError(context, "non-absolute home");
                    }
                } else {
                    userEnd = pathLength;
                }
            }
            if (userEnd == 1) {
                path2 = RubyDir.getHomeDirectoryPath(context, RubyFile.checkHome(context)).toString() + ((String)path2).substring(1);
                if (raiseOnRelativePath && !RubyFile.isAbsolutePath((String)path2)) {
                    throw Error.argumentError(context, "non-absolute home");
                }
            } else if (userEnd > 1) {
                String user = ((String)path2).substring(1, userEnd);
                IRubyObject dir = RubyDir.getHomeDirectoryPath(context, user);
                if (dir.isNil()) {
                    throw Error.argumentError(context, "user " + user + " does not exist");
                }
                path2 = String.valueOf(dir) + (pathLength == userEnd ? "" : ((String)path2).substring(userEnd));
                if (raiseOnRelativePath && !RubyFile.isAbsolutePath((String)path2)) {
                    throw Error.argumentError(context, "non-absolute home of " + user);
                }
            }
        }
        return path2;
    }

    private static String countSlashes(String stringToCheck) {
        int slashCount = 0;
        int len = stringToCheck.length();
        if (len > 0 && stringToCheck.charAt(0) == '/' && len > 1 && stringToCheck.charAt(1) == '/') {
            ++slashCount;
            for (int i2 = 2; i2 < len && stringToCheck.charAt(i2) == '/'; ++i2) {
                ++slashCount;
            }
        }
        if (slashCount < SLASHES.length) {
            return SLASHES[slashCount];
        }
        char[] slashes = new char[slashCount];
        for (int i3 = 0; i3 < slashCount; ++i3) {
            slashes[i3] = 47;
        }
        return new String(slashes);
    }

    public static String canonicalize(String path2) {
        CharSequence canonical = RubyFile.canonicalize(null, path2);
        return canonical == null ? null : canonical.toString();
    }

    private static CharSequence canonicalize(CharSequence canonicalPath, String remaining) {
        String child;
        if (remaining == null) {
            if (canonicalPath == null) {
                return null;
            }
            if (canonicalPath.length() == 0) {
                return "/";
            }
            if (RubyFile.startsWithDriveLetterOnWindows(canonicalPath) && canonicalPath.length() == 2) {
                return RubyFile.appendSlash(canonicalPath);
            }
            return canonicalPath;
        }
        int slash = remaining.indexOf(47);
        if (slash == -1) {
            child = remaining;
            remaining = null;
        } else {
            child = remaining.substring(0, slash);
            remaining = remaining.substring(slash + 1);
        }
        Object path2 = canonicalPath;
        if (child.equals(".")) {
            if (slash == -1 && canonicalPath != null && canonicalPath.length() == 0) {
                path2 = RubyFile.appendSlash(canonicalPath);
            }
        } else if (child.equals("..")) {
            if (canonicalPath == null) {
                throw new IllegalArgumentException("Cannot have .. at the start of an absolute path");
            }
            String canonicalPathString = canonicalPath.toString();
            int lastDir = canonicalPathString.lastIndexOf(47);
            if (lastDir == -1) {
                if (!RubyFile.startsWithDriveLetterOnWindows(canonicalPath) && !RubyFile.isLocalURI(canonicalPathString)) {
                    path2 = "";
                }
            } else {
                path2 = canonicalPath.subSequence(0, lastDir);
            }
        } else if (canonicalPath == null) {
            path2 = child;
        } else {
            int length2 = canonicalPath.length();
            String canonPathString = canonicalPath.toString();
            path2 = canonPathString.length() > 0 && canonicalPath.charAt(length2 - 1) == '/' && canonPathString.startsWith("uri:classloader:") ? String.valueOf(canonicalPath) + child : String.valueOf(canonicalPath) + "/" + child;
        }
        return RubyFile.canonicalize((CharSequence)path2, remaining);
    }

    private static boolean isLocalURI(String canonicalPathString) {
        return StringSupport.startsWith((CharSequence)"classpath:", canonicalPathString) || StringSupport.startsWith((CharSequence)"classloader:", canonicalPathString) || StringSupport.startsWith((CharSequence)"uri:classloader:", canonicalPathString) || StringSupport.startsWith((CharSequence)"file:", canonicalPathString) || StringSupport.startsWith((CharSequence)"jar:file", canonicalPathString);
    }

    private static StringBuilder appendSlash(CharSequence canonicalPath) {
        return new StringBuilder(canonicalPath.length() + 1).append(canonicalPath).append('/');
    }

    private static RubyString checkHome(ThreadContext context) {
        IRubyObject home2 = context.runtime.getENV().fastARef(Create.newSharedString(context, RubyDir.HOME));
        if (home2 == null || home2 == context.nil || ((RubyString)home2).size() == 0) {
            throw Error.argumentError(context, "couldn't find HOME environment -- expanding '~'");
        }
        return (RubyString)home2;
    }

    @Override
    public <T> T toJava(Class<T> target2) {
        if (target2 == File.class) {
            String path2 = this.getPath();
            return (T)(path2 == null ? null : new File(path2));
        }
        if (target2 == Path.class || target2 == Watchable.class) {
            String path3 = this.getPath();
            return (T)(path3 == null ? null : FileSystems.getDefault().getPath(path3, new String[0]));
        }
        return super.toJava(target2);
    }

    private static RubyString doJoin(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        String separator = Access.fileClass(context).getConstant(context, "SEPARATOR").toString();
        RubyArray argsAry = RubyArray.newArrayMayCopy(context.runtime, args2);
        StringBuilder buffer = new StringBuilder(24);
        RubyFile.joinImpl(buffer, separator, context, recv2, argsAry);
        return Create.newString(context, buffer.toString());
    }

    private static boolean joinImpl(StringBuilder buffer, String separator, ThreadContext context, IRubyObject recv2, RubyArray args2) {
        for (int i2 = 0; i2 < args2.size(); ++i2) {
            boolean leadingDelimiter;
            String element;
            Object arg2 = args2.eltInternal(i2);
            if (arg2 instanceof RubyString) {
                element = arg2.convertToString().toString();
            } else if (arg2 instanceof RubyArray) {
                RubyArray ary = (RubyArray)arg2;
                if (context.runtime.isInspecting(arg2)) {
                    throw Error.argumentError(context, "recursive array");
                }
                element = RubyFile.joinImplInspecting(separator, context, recv2, args2, ary).toString();
            } else {
                element = RubyFile.get_path(context, arg2).toString();
            }
            int trailingDelimiterIndex = RubyFile.chomp(buffer);
            boolean trailingDelimiter = trailingDelimiterIndex != -1;
            boolean bl = leadingDelimiter = element.length() > 0 && RubyFile.isDirSeparator(element.charAt(0));
            if (i2 > 0) {
                if (leadingDelimiter) {
                    if (trailingDelimiter) {
                        buffer.delete(trailingDelimiterIndex, buffer.length());
                    }
                } else if (!trailingDelimiter) {
                    buffer.append(separator);
                }
            }
            buffer.append(element);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder joinImplInspecting(String separator, ThreadContext context, IRubyObject recv2, RubyArray parent, RubyArray array2) {
        Ruby runtime2 = context.runtime;
        StringBuilder buffer = new StringBuilder(24);
        if (runtime2.isInspecting(parent)) {
            RubyFile.joinImpl(buffer, separator, context, recv2, array2);
            return buffer;
        }
        try {
            runtime2.registerInspecting(parent);
            RubyFile.joinImpl(buffer, separator, context, recv2, array2);
            StringBuilder stringBuilder = buffer;
            return stringBuilder;
        }
        finally {
            runtime2.unregisterInspecting(parent);
        }
    }

    private static boolean isDirSeparator(char c) {
        return c == '/' || Platform.IS_WINDOWS && c == '\\';
    }

    private static int chomp(StringBuilder buffer) {
        boolean found = false;
        for (int lastIndex = buffer.length() - 1; lastIndex >= 0; --lastIndex) {
            if (!RubyFile.isDirSeparator(buffer.charAt(lastIndex))) {
                if (!found) break;
                return lastIndex + 1;
            }
            found = true;
        }
        return found ? 0 : -1;
    }

    private static String replace(String str, CharSequence target2, CharSequence replace2) {
        if (target2.length() == 1 && replace2.length() == 1) {
            return str.replace(target2.charAt(0), replace2.charAt(0));
        }
        return str.replace(target2, replace2);
    }

    private static IRubyObject truncateCommon(ThreadContext context, IRubyObject recv2, IRubyObject arg1, IRubyObject arg2) {
        File testFile;
        RubyString filename2 = arg1.convertToString();
        Ruby runtime2 = context.runtime;
        RubyInteger newLength = Convert.toInteger(context, arg2);
        File childFile = new File(filename2.toString());
        String filenameString = Helpers.decodeByteList(runtime2, filename2.getByteList());
        File file2 = testFile = childFile.isAbsolute() ? childFile : new File(runtime2.getCurrentDirectory(), filenameString);
        if (!testFile.exists()) {
            throw runtime2.newErrnoENOENTError(filenameString);
        }
        if (newLength.asLong(context) < 0L) {
            throw runtime2.newErrnoEINVALError(filenameString);
        }
        IRubyObject[] args2 = new IRubyObject[]{filename2, Create.newString(context, "r+")};
        RubyFile file3 = (RubyFile)RubyFile.open(context, recv2, args2, Block.NULL_BLOCK);
        file3.truncate(context, newLength);
        file3.close();
        return Convert.asFixnum(context, 0);
    }

    private static JavaSites.FileSites sites(ThreadContext context) {
        return context.sites.File;
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject dirname(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return switch (args2.length) {
            case 1 -> RubyFile.dirname(context, recv2, args2[0]);
            case 2 -> RubyFile.dirname(context, recv2, args2[0], args2[1]);
            default -> throw Error.argumentError(context, args2.length, 1, 2);
        };
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject expand_path(ThreadContext context, IRubyObject recv2, IRubyObject ... args2) {
        return switch (args2.length) {
            case 1 -> RubyFile.expand_path(context, recv2, args2[0]);
            case 2 -> RubyFile.expand_path(context, recv2, args2[0], args2[1]);
            default -> throw Error.argumentError(context, args2.length, 1, 2);
        };
    }

    @Deprecated(since="9.4.6.0")
    private static RubyString expandPathInternal(ThreadContext context, IRubyObject[] args2, boolean expandUser, boolean canonicalize) {
        return switch (args2.length) {
            case 1 -> RubyFile.expandPathInternal(context, args2[0], null, expandUser, canonicalize);
            case 2 -> RubyFile.expandPathInternal(context, args2[0], args2[1], expandUser, canonicalize);
            default -> throw Error.argumentError(context, args2.length, 1, 2);
        };
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject absolute_path(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                RubyFile.absolute_path(context, recv2, args2[0]);
            }
            case 2: {
                RubyFile.absolute_path(context, recv2, args2[0], args2[1]);
            }
        }
        throw Error.argumentError(context, args2.length, 1, 2);
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject realdirpath(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                RubyFile.realdirpath(context, recv2, args2[0]);
            }
            case 2: {
                RubyFile.realdirpath(context, recv2, args2[0], args2[1]);
            }
        }
        throw Error.argumentError(context, args2.length, 1, 2);
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject realpath(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        RubyString file2 = RubyFile.expandPathInternal(context, args2, false, true);
        if (!RubyFileTest.exist(context, file2)) {
            throw context.runtime.newErrnoENOENTError(file2.toString());
        }
        return file2;
    }

    @Deprecated(since="9.4.6.0")
    public static IRubyObject fnmatch(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return switch (args2.length) {
            case 2 -> RubyFile.fnmatch(context, recv2, args2[0], args2[1]);
            case 3 -> RubyFile.fnmatch(context, recv2, args2[0], args2[1], args2[2]);
            default -> throw Error.argumentError(context, args2.length, 2, 3);
        };
    }
}

