/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

public class XmlVaspReader
extends XmlReader {
    private SB data;
    private String name;
    private int ac;
    private int iAtom;
    private boolean isE_wo_entrp = false;
    private boolean isE_fr_energy = false;
    private String enthalpy = null;
    private String gibbsEnergy = null;
    boolean haveUnitCell = false;
    String[] atomNames;
    String[] atomSyms;
    String atomName;
    String atomSym;
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;

    @Override
    protected void processXml(XmlReader parent, Object saxReader) throws Exception {
        parent.doProcessLines = true;
        this.processXml2(parent, saxReader);
    }

    @Override
    public void processStartElement(String localName, String nodeName) {
        if (this.debugging) {
            Logger.debug("xmlvasp: start " + localName);
        }
        if (!this.parent.continuing) {
            return;
        }
        if ("calculation".equals(localName)) {
            this.enthalpy = null;
            this.gibbsEnergy = null;
            return;
        }
        if ("i".equals(localName)) {
            String s = (String)this.atts.get("name");
            if (s.charAt(0) != 'e') {
                return;
            }
            this.isE_wo_entrp = s.equals("e_wo_entrp");
            this.isE_fr_energy = s.equals("e_fr_energy");
            this.setKeepChars(this.isE_wo_entrp || this.isE_fr_energy);
            return;
        }
        if ("structure".equals(localName)) {
            if (!this.parent.doGetModel(++this.parent.modelNumber, null)) {
                this.parent.checkLastModel();
                return;
            }
            this.parent.setFractionalCoordinates(true);
            this.asc.doFixPeriodic = true;
            this.asc.newAtomSet();
            if (this.enthalpy != null) {
                this.asc.setCurrentModelInfo("enthalpy", Double.valueOf(this.enthalpy));
            }
            if (this.gibbsEnergy != null) {
                this.asc.setAtomSetEnergy("" + this.gibbsEnergy, this.parseFloatStr(this.gibbsEnergy));
                this.asc.setCurrentModelInfo("gibbsEnergy", Double.valueOf(this.gibbsEnergy));
            }
            if (this.enthalpy != null && this.gibbsEnergy != null) {
                this.asc.setAtomSetName("Enthalpy = " + this.enthalpy + " eV Gibbs Energy = " + this.gibbsEnergy + " eV");
            }
            return;
        }
        if (!this.parent.doProcessLines) {
            return;
        }
        if ("v".equals(localName)) {
            this.setKeepChars(this.data != null);
            return;
        }
        if ("c".equals(localName)) {
            this.setKeepChars(this.iAtom < this.ac);
            return;
        }
        if ("varray".equals(localName)) {
            this.name = (String)this.atts.get("name");
            if (this.name != null && PT.isOneOf(this.name, ";basis;positions;forces;")) {
                this.data = new SB();
            }
            return;
        }
        if ("atoms".equals(localName)) {
            this.setKeepChars(true);
            return;
        }
    }

    @Override
    void processEndElement(String localName) {
        if (this.debugging) {
            Logger.debug("xmlvasp: end " + localName);
        }
        if (this.parent.doProcessLines) {
            if (this.isE_wo_entrp) {
                this.isE_wo_entrp = false;
                this.enthalpy = this.chars.toString().trim();
            } else if (this.isE_fr_energy) {
                this.isE_fr_energy = false;
                this.gibbsEnergy = this.chars.toString().trim();
            } else if ("v".equals(localName) && this.data != null) {
                this.data.append(this.chars.toString());
            } else if ("c".equals(localName)) {
                if (this.iAtom < this.ac) {
                    if (this.atomName == null) {
                        this.atomName = this.atomSym = this.chars.toString().trim();
                    } else {
                        this.atomNames[this.iAtom++] = this.atomName + this.chars.toString().trim();
                        this.atomName = null;
                    }
                }
            } else if ("atoms".equals(localName)) {
                this.ac = this.parseIntStr(this.chars.toString());
                this.atomNames = new String[this.ac];
                this.atomSyms = new String[this.ac];
                this.iAtom = 0;
            } else if ("varray".equals(localName) && this.data != null) {
                if (this.name != null) {
                    if ("basis".equals(this.name) && !this.haveUnitCell) {
                        this.haveUnitCell = true;
                        float[] ijk = XmlVaspReader.getTokensFloat(this.data.toString(), null, 9);
                        V3 va = V3.new3(ijk[0], ijk[1], ijk[2]);
                        V3 vb = V3.new3(ijk[3], ijk[4], ijk[5]);
                        V3 vc = V3.new3(ijk[6], ijk[7], ijk[8]);
                        this.a = va.length();
                        this.b = vb.length();
                        this.c = vc.length();
                        va.normalize();
                        vb.normalize();
                        vc.normalize();
                        this.alpha = (float)(Math.acos(vb.dot(vc)) * 180.0 / Math.PI);
                        this.beta = (float)(Math.acos(va.dot(vc)) * 180.0 / Math.PI);
                        this.gamma = (float)(Math.acos(va.dot(vb)) * 180.0 / Math.PI);
                    } else if ("positions".equals(this.name)) {
                        this.parent.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
                        float[] fdata = new float[this.ac * 3];
                        XmlVaspReader.getTokensFloat(this.data.toString(), fdata, this.ac * 3);
                        int fpt = 0;
                        for (int i = 0; i < this.ac; ++i) {
                            Atom atom = this.asc.addNewAtom();
                            this.parent.setAtomCoordXYZ(atom, fdata[fpt++], fdata[fpt++], fdata[fpt++]);
                            atom.elementSymbol = this.atomSyms[i];
                            atom.atomName = this.atomNames[i];
                        }
                    } else if ("forces".equals(this.name)) {
                        float[] fdata = new float[this.ac * 3];
                        XmlVaspReader.getTokensFloat(this.data.toString(), fdata, this.ac * 3);
                        int fpt = 0;
                        int i0 = this.asc.getLastAtomSetAtomIndex();
                        for (int i = 0; i < this.ac; ++i) {
                            this.asc.addVibrationVector(i0 + i, fdata[fpt++], fdata[fpt++], fdata[fpt++]);
                        }
                    }
                }
                this.data = null;
            } else if ("structure".equals(localName)) {
                try {
                    this.parent.applySymmetryAndSetTrajectory();
                }
                catch (Exception exception) {}
            } else {
                return;
            }
        }
        this.setKeepChars(false);
    }
}

