/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrGdkMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/findUsages/PropertyMethodReferenceSearchExecutor;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "intellij.groovy.psi"})
public final class PropertyMethodReferenceSearchExecutor
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public PropertyMethodReferenceSearchExecutor() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        String propertyName;
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiMethod psiMethod = queryParameters.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"getMethod(...)");
        PsiMethod method = psiMethod;
        if (GdkMethodUtil.isCategoryMethod(method, null, null, PsiSubstitutor.EMPTY)) {
            GrGdkMethod grGdkMethod = GrGdkMethodImpl.createGdkMethod(method, false, null);
            Intrinsics.checkNotNullExpressionValue((Object)grGdkMethod, (String)"createGdkMethod(...)");
            GrGdkMethod cat = grGdkMethod;
            v2 = GroovyPropertyUtils.getPropertyName(cat);
        } else {
            v2 = propertyName = GroovyPropertyUtils.getPropertyName(method);
        }
        if (propertyName == null) {
            return;
        }
        PsiMethod[] psiMethodArray = new PsiMethod[]{method};
        SearchScope onlyGroovyFiles = GroovyScopeUtil.restrictScopeToGroovyFiles(queryParameters.getEffectiveSearchScope(), GroovyScopeUtil.getEffectiveScope(psiMethodArray));
        queryParameters.getOptimizer().searchWord(propertyName, onlyGroovyFiles, (short)1, true, (PsiElement)method);
        if (!GroovyPropertyUtils.isPropertyName(propertyName)) {
            SearchRequestCollector searchRequestCollector = queryParameters.getOptimizer();
            String string = StringUtil.decapitalize((String)propertyName);
            Intrinsics.checkNotNull((Object)string);
            searchRequestCollector.searchWord(string, onlyGroovyFiles, (short)1, true, (PsiElement)method);
        }
    }
}

