/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public abstract class NSObject
implements StructConverter {
    protected DataConverter converter = BigEndianDataConverter.INSTANCE;

    public abstract String getType();

    public abstract String toString();

    protected void addHeader(Structure structure, int size) {
        if (size < 15) {
            structure.add(BYTE, "objectDescriptor", null);
        } else if (size < 255) {
            structure.add(BYTE, "objectDescriptor", null);
            structure.add(BYTE, "indicator", null);
            structure.add(BYTE, "length", null);
        } else if (size < 65535) {
            structure.add(BYTE, "objectDescriptor", null);
            structure.add(BYTE, "indicator", null);
            structure.add(WORD, "length", null);
        } else {
            throw new RuntimeException("unexpected size in " + this.getClass().getName());
        }
    }

    public void markup(Data objectData, Program program, TaskMonitor monitor) throws CancelledException {
    }

    protected long getValue(Data component) {
        try {
            byte[] bytes = component.getBytes();
            BigInteger bi = new BigInteger(bytes);
            return bi.longValue();
        }
        catch (MemoryAccessException memoryAccessException) {
            return -1L;
        }
    }
}

