/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.provider;

import docking.widgets.table.constraint.AtLeastDateColumnConstraint;
import docking.widgets.table.constraint.AtMostDateColumnConstraint;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnConstraintProvider;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.InDateRangeColumnConstraint;
import docking.widgets.table.constraint.NotInDateRangeColumnConstraint;
import docking.widgets.table.constraint.provider.EditorProvider;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import docking.widgets.table.constrainteditor.DateRangeConstraintEditor;
import docking.widgets.table.constrainteditor.DateValueConstraintEditor;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class DateColumnConstraintProvider
implements ColumnConstraintProvider {
    public static final LocalDate DEFAULT_DATE = new Date(Long.MAX_VALUE).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();

    @Override
    public Collection<ColumnConstraint<?>> getColumnConstraints() {
        ArrayList list = new ArrayList();
        list.add(new AtLeastDateColumnConstraint(DEFAULT_DATE, new LocalDateEditorProvider()));
        list.add(new AtMostDateColumnConstraint(DEFAULT_DATE, new LocalDateEditorProvider()));
        list.add(new InDateRangeColumnConstraint(DEFAULT_DATE, DEFAULT_DATE, new LocalDateRangeEditorProvider()));
        list.add(new NotInDateRangeColumnConstraint(DEFAULT_DATE, DEFAULT_DATE, new LocalDateRangeEditorProvider()));
        return list;
    }

    static class LocalDateEditorProvider
    implements EditorProvider<LocalDate> {
        LocalDateEditorProvider() {
        }

        @Override
        public ColumnConstraintEditor<LocalDate> getEditor(ColumnConstraint<LocalDate> columnConstraint, ColumnData<LocalDate> columnDataSource) {
            return new DateValueConstraintEditor(columnConstraint);
        }

        @Override
        public LocalDate parseValue(String value, Object dataSource) {
            return LocalDate.parse(value, DateValueConstraintEditor.LOCAL_DATE_FORMAT);
        }

        @Override
        public String toString(LocalDate value) {
            return value.format(DateValueConstraintEditor.LOCAL_DATE_FORMAT);
        }
    }

    static class LocalDateRangeEditorProvider
    extends LocalDateEditorProvider {
        LocalDateRangeEditorProvider() {
        }

        @Override
        public ColumnConstraintEditor<LocalDate> getEditor(ColumnConstraint<LocalDate> columnConstraint, ColumnData<LocalDate> columnDataSource) {
            return new DateRangeConstraintEditor(columnConstraint);
        }
    }
}

