/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.unixaout;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class UnixAoutHeader
implements StructConverter {
    private BinaryReader reader;
    private long binarySize;
    private AoutType exeType;
    private boolean machineTypeValid;
    private String languageSpec;
    private String compilerSpec = "default";
    private long pageSize;
    private boolean isNetBSD = false;
    private boolean isSparc = false;
    private long a_magic;
    private long a_text;
    private long a_data;
    private long a_bss;
    private long a_syms;
    private long a_entry;
    private long a_trsize;
    private long a_drsize;
    private long strSize;
    private long txtOffset;
    private long datOffset;
    private long txtRelOffset;
    private long datRelOffset;
    private long symOffset;
    private long strOffset;
    private long txtAddr;
    private long txtEndAddr;
    private long datAddr;
    private long bssAddr;
    private static final int SIZE_OF_EXEC_HEADER = 32;
    private static final int SIZE_OF_LONG_EXEC_HEADER = 1024;

    public UnixAoutHeader(ByteProvider provider, boolean isLittleEndian) throws IOException {
        this.reader = new BinaryReader(provider, isLittleEndian);
        this.a_magic = this.reader.readNextUnsignedInt();
        this.a_text = this.reader.readNextUnsignedInt();
        this.a_data = this.reader.readNextUnsignedInt();
        this.a_bss = this.reader.readNextUnsignedInt();
        this.a_syms = this.reader.readNextUnsignedInt();
        this.a_entry = this.reader.readNextUnsignedInt();
        this.a_trsize = this.reader.readNextUnsignedInt();
        this.a_drsize = this.reader.readNextUnsignedInt();
        this.binarySize = this.reader.length();
        this.setExecutableType(this.a_magic);
        if (this.exeType == AoutType.UNKNOWN && isLittleEndian) {
            this.a_magic = Integer.reverseBytes((int)this.a_magic);
            this.setExecutableType(this.a_magic);
        }
        this.checkMachineTypeValidity(isLittleEndian);
        this.determineTextOffset();
        this.datOffset = this.txtOffset + this.a_text;
        this.txtRelOffset = this.datOffset + this.a_data;
        this.datRelOffset = this.txtRelOffset + this.a_trsize;
        this.symOffset = this.datRelOffset + this.a_drsize;
        this.strOffset = this.symOffset + this.a_syms;
        this.strSize = 0L;
        if (this.strOffset != 0L && this.strOffset + 4L <= this.binarySize) {
            this.strSize = this.reader.readUnsignedInt(this.strOffset);
        }
        this.determineTextAddr();
        this.txtEndAddr = this.txtAddr + this.a_text;
        this.datAddr = this.exeType == AoutType.OMAGIC ? this.txtEndAddr : this.segmentRound(this.txtEndAddr);
        this.bssAddr = this.datAddr + this.a_data;
    }

    public BinaryReader getReader() {
        return this.reader;
    }

    public String getLanguageSpec() {
        return this.languageSpec;
    }

    public String getCompilerSpec() {
        return this.compilerSpec;
    }

    public AoutType getExecutableType() {
        return this.exeType;
    }

    public boolean isValid() {
        return this.isMachineTypeValid() && this.exeType != AoutType.UNKNOWN && this.areOffsetsValid();
    }

    public long getTextSize() {
        return this.a_text;
    }

    public long getDataSize() {
        return this.a_data;
    }

    public long getBssSize() {
        return this.a_bss;
    }

    public long getSymSize() {
        return this.a_syms;
    }

    public long getStrSize() {
        return this.strSize;
    }

    public long getEntryPoint() {
        return this.a_entry;
    }

    public long getTextRelocSize() {
        return this.a_trsize;
    }

    public long getDataRelocSize() {
        return this.a_drsize;
    }

    public long getTextOffset() {
        return this.txtOffset;
    }

    public long getDataOffset() {
        return this.datOffset;
    }

    public long getTextRelocOffset() {
        return this.txtRelOffset;
    }

    public long getDataRelocOffset() {
        return this.datRelOffset;
    }

    public long getSymOffset() {
        return this.symOffset;
    }

    public long getStrOffset() {
        return this.strOffset;
    }

    public long getTextAddr() {
        return this.txtAddr;
    }

    public long getDataAddr() {
        return this.datAddr;
    }

    public long getBssAddr() {
        return this.bssAddr;
    }

    private void checkMachineTypeValidity(boolean readingAsLittleEndian) {
        String[] languageTokens;
        this.machineTypeValid = true;
        this.pageSize = 4096L;
        short machtype = (short)(this.a_magic >> 16 & 0xFFL);
        String readEndianness = readingAsLittleEndian ? "LE" : "BE";
        switch (machtype) {
            case 1: {
                this.languageSpec = "68000:BE:32:MC68010";
                break;
            }
            case 2: {
                this.languageSpec = "68000:BE:32:MC68020";
                break;
            }
            case 135: {
                this.pageSize = 8192L;
            }
            case 136: {
                this.isNetBSD = true;
                this.languageSpec = "68000:BE:32:default";
                break;
            }
            case 138: {
                this.isNetBSD = true;
            }
            case 3: 
            case 131: {
                this.isSparc = true;
                this.pageSize = 8192L;
                this.languageSpec = "sparc:BE:32:default";
                break;
            }
            case 156: {
                this.isNetBSD = true;
                this.isSparc = true;
                this.languageSpec = "sparc:BE:64:default";
                break;
            }
            case 139: {
                this.isNetBSD = true;
            }
            case 4: 
            case 151: 
            case 152: {
                this.languageSpec = "MIPS:LE:32:default";
                break;
            }
            case 142: {
                this.languageSpec = "MIPS:BE:32:default";
                break;
            }
            case 137: {
                this.isNetBSD = true;
            }
            case 64: 
            case 69: {
                this.languageSpec = "UNKNOWN:LE:32:default";
                break;
            }
            case 134: {
                this.isNetBSD = true;
            }
            case 100: 
            case 102: {
                this.compilerSpec = "gcc";
                this.languageSpec = "x86:LE:32:default";
                break;
            }
            case 157: {
                this.compilerSpec = "gcc";
                this.languageSpec = "x86:LE:64:default";
                break;
            }
            case 143: {
                this.isNetBSD = true;
            }
            case 103: {
                this.languageSpec = "ARM:" + readEndianness + ":32:default";
                break;
            }
            case 183: {
                this.languageSpec = "AARCH64:" + readEndianness + ":64:default";
                break;
            }
            case 184: {
                this.languageSpec = "UNKNOWN:BE:32:default";
                break;
            }
            case 185: {
                this.languageSpec = "RISCV:LE:32:default";
                break;
            }
            case 154: {
                this.languageSpec = "pa-risc:BE:32:default";
                break;
            }
            case 149: {
                this.isNetBSD = true;
                this.languageSpec = "PowerPC:" + readEndianness + ":32:default";
                break;
            }
            case 148: {
                this.languageSpec = "PowerPC:" + readEndianness + ":64:default";
                break;
            }
            case 145: 
            case 158: {
                this.languageSpec = "SuperH:BE:32:default";
                break;
            }
            case 155: {
                this.languageSpec = "SuperH:BE:64:default";
                break;
            }
            case 140: {
                this.pageSize = 512L;
            }
            case 150: {
                this.isNetBSD = true;
                this.languageSpec = "UNKNOWN:LE:32:default";
                break;
            }
            case 255: {
                this.languageSpec = "UNKNOWN:LE:32:default";
                break;
            }
            case 141: {
                this.isNetBSD = true;
            }
            case 159: {
                this.languageSpec = "UNKNOWN:" + readEndianness + ":64:default";
                break;
            }
            case 101: 
            case 153: {
                this.languageSpec = "UNKNOWN:" + readEndianness + ":32:default";
                break;
            }
            case 0: {
                this.languageSpec = "UNKNOWN:" + readEndianness + ":32:default";
                break;
            }
            default: {
                this.machineTypeValid = false;
            }
        }
        if (this.machineTypeValid && ((languageTokens = this.languageSpec.split(":")).length < 2 || !languageTokens[1].equalsIgnoreCase(readEndianness))) {
            this.machineTypeValid = false;
        }
    }

    private boolean isMachineTypeValid() {
        return this.machineTypeValid;
    }

    private void setExecutableType(long magic) {
        this.exeType = switch ((short)(magic & 0xFFFFL)) {
            case 273 -> AoutType.CMAGIC;
            case 264 -> AoutType.NMAGIC;
            case 263 -> AoutType.OMAGIC;
            case 204 -> AoutType.QMAGIC;
            case 267 -> AoutType.ZMAGIC;
            default -> AoutType.UNKNOWN;
        };
    }

    private void determineTextOffset() {
        boolean isLinuxStyle = false;
        long fixedContentSize = this.a_text + this.a_data + this.a_syms + this.a_trsize + this.a_drsize;
        if (this.reader.isValidIndex(1024L + fixedContentSize)) {
            try {
                long stringTableLength = this.reader.readUnsignedInt(1024L + fixedContentSize);
                long longHeaderExpectedFileSize = 1024L + fixedContentSize + stringTableLength;
                if (this.binarySize == longHeaderExpectedFileSize) {
                    isLinuxStyle = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.txtOffset = isLinuxStyle && this.exeType == AoutType.ZMAGIC ? 1024L : (this.exeType == AoutType.QMAGIC || this.exeType == AoutType.ZMAGIC ? 0L : 32L);
    }

    private void determineTextAddr() {
        this.txtAddr = this.isSparc && this.exeType == AoutType.NMAGIC || this.isNetBSD || this.exeType == AoutType.QMAGIC ? this.pageSize : 0L;
    }

    private boolean areOffsetsValid() {
        boolean status = !(this.a_text != 0L && (this.txtOffset >= this.binarySize || this.a_data != 0L && this.datOffset >= this.binarySize || this.a_trsize != 0L && this.txtRelOffset >= this.binarySize || this.a_drsize != 0L && this.datRelOffset >= this.binarySize || this.a_syms != 0L && this.symOffset >= this.binarySize));
        return status;
    }

    private long segmentRound(long addr) {
        long mask = this.pageSize - 1L;
        long rounded = addr + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        return rounded;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(new CategoryPath("/AOUT"), "exec", 0);
        struct.add(DWORD, "a_midmag", "magic (network byte order)");
        struct.add(DWORD, "a_text", "the size of the text segment in bytes");
        struct.add(DWORD, "a_data", "the size of the data segment in bytes");
        struct.add(DWORD, "a_bss", "the number of bytes in the bss segment");
        struct.add(DWORD, "a_syms", "the size in bytes of the symbol table section");
        struct.add(DWORD, "a_entry", "the address of the entry point");
        struct.add(DWORD, "a_trsize", "the size in bytes of the text relocation table");
        struct.add(DWORD, "a_drsize", "the size in bytes of the data relocation table");
        return struct;
    }

    public void markup(Program program, Address headerAddress) throws CodeUnitInsertionException, DuplicateNameException, IOException {
        Listing listing = program.getListing();
        listing.createData(headerAddress, this.toDataType());
    }

    public static enum AoutType {
        OMAGIC,
        NMAGIC,
        ZMAGIC,
        QMAGIC,
        CMAGIC,
        UNKNOWN;

    }
}

