/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnionDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomExportEntry
implements StructConverter {
    public static final int SIZE = 20;
    private int next;
    private String name;
    private int value;
    private int info;
    private int type;
    private boolean isTpRelative;
    private int reserved1;
    private short moduleIndex;

    public SomExportEntry(BinaryReader reader, long stringTableLoc) throws IOException {
        this.next = reader.readNextInt();
        int nameIndex = reader.readNextInt();
        this.name = nameIndex != -1 ? reader.readAsciiString(stringTableLoc + (long)nameIndex) : null;
        this.value = reader.readNextInt();
        this.info = reader.readNextInt();
        this.type = reader.readNextUnsignedByte();
        int bitfield = reader.readNextUnsignedByte();
        this.reserved1 = bitfield & 0x7F;
        this.isTpRelative = (bitfield >> 7 & 1) != 0;
        this.moduleIndex = reader.readNextShort();
    }

    public int getNext() {
        return this.next;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public int getInfo() {
        return this.info;
    }

    public int getType() {
        return this.type;
    }

    public boolean isTpRelative() {
        return this.isTpRelative;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public short getModuleIndex() {
        return this.moduleIndex;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType miscInfoStruct = new StructureDataType("misc_info", 4);
        miscInfoStruct.setPackingEnabled(true);
        miscInfoStruct.add(WORD, "version", "months since January, 1990");
        try {
            miscInfoStruct.addBitField(WORD, 6, "reserved2", null);
            miscInfoStruct.addBitField(WORD, 10, "arg_reloc", "parameter relocation bits (5*2)");
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        miscInfoStruct.setCategoryPath(new CategoryPath("/SOM"));
        UnionDataType infoUnion = new UnionDataType("info");
        infoUnion.add(DWORD, "size", "storage request area size in bytes");
        infoUnion.add((DataType)miscInfoStruct, "misc", "version, etc. N/A to storage requests");
        infoUnion.setCategoryPath(new CategoryPath("/SOM"));
        StructureDataType struct = new StructureDataType("export_entry", 20);
        struct.setPackingEnabled(true);
        struct.add(DWORD, "next", "index of next export entry in hash chain");
        struct.add(DWORD, "name", "offset within string table");
        struct.add(DWORD, "value", "offset of symbol (subject to relocation)");
        struct.add((DataType)infoUnion, "info", null);
        struct.add(BYTE, "type", "symbol type");
        try {
            struct.addBitField(BYTE, 1, "is_tp_relative", "TLS export");
            struct.addBitField(BYTE, 7, "reserved1", "reserved");
        }
        catch (InvalidDataTypeException e) {
            throw new IOException(e);
        }
        struct.add(WORD, "module_index", "index of module defining symbol");
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

