/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.CoffSymbolAux;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CoffSymbolAuxSection
implements CoffSymbolAux {
    private int sectionLength;
    private short relocationCount;
    private short lineNumberCount;
    private byte[] unused;

    CoffSymbolAuxSection(BinaryReader reader) throws IOException {
        this.sectionLength = reader.readNextInt();
        this.relocationCount = reader.readNextShort();
        this.lineNumberCount = reader.readNextShort();
        this.unused = reader.readNextByteArray(10);
    }

    public int getSectionLength() {
        return this.sectionLength;
    }

    public short getRelocationCount() {
        return this.relocationCount;
    }

    public short getLineNumberCount() {
        return this.lineNumberCount;
    }

    public byte[] getUnused() {
        return this.unused;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this);
    }
}

