/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingType;
import docking.action.ToolBarData;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.OptionDialogBuilder;
import ghidra.app.cmd.refs.RemoveReferenceCmd;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.FunctionXrefsTableModel;
import ghidra.app.util.query.TableService;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.ThunkReference;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.ProgramEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import ghidra.util.table.ReferencesFromTableModel;
import ghidra.util.table.field.ReferenceEndpoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import resources.Icons;
import resources.ResourceManager;

public class XReferenceUtils {
    private static final String X_REFS_TO = "XRefs to ";
    private static final int ALL_REFS = -1;
    private static OptionDialog promptToDeleteXrefsDialog;

    public static final List<Reference> getXReferences(CodeUnit cu, int max) {
        Program program = cu.getProgram();
        if (program == null) {
            Collections.emptyList();
        }
        ArrayList<Reference> xrefs = new ArrayList<Reference>();
        Address minAddress = cu.getMinAddress();
        ReferenceIterator it = program.getReferenceManager().getReferencesTo(minAddress);
        while (it.hasNext() && xrefs.size() - max != 0) {
            Reference ref = it.next();
            xrefs.add(ref);
        }
        Function function = program.getFunctionManager().getFunctionAt(minAddress);
        if (function == null) {
            return xrefs;
        }
        Address[] thunkAddrs = function.getFunctionThunkAddresses(false);
        if (thunkAddrs != null) {
            for (Address thunkAddr : thunkAddrs) {
                xrefs.add((Reference)new ThunkReference(thunkAddr, function.getEntryPoint()));
            }
        }
        return xrefs;
    }

    public static List<Reference> getOffcutXReferences(CodeUnit cu, int max) {
        Program program = cu.getProgram();
        if (program == null) {
            return Collections.emptyList();
        }
        if (cu.getLength() <= 1) {
            return Collections.emptyList();
        }
        ArrayList<Reference> offcuts = new ArrayList<Reference>();
        ReferenceManager refMgr = program.getReferenceManager();
        AddressSet set = new AddressSet(cu.getMinAddress().add(1L), cu.getMaxAddress());
        AddressIterator it = refMgr.getReferenceDestinationIterator((AddressSetView)set, true);
        while (it.hasNext()) {
            Address addr = it.next();
            ReferenceIterator refIter = refMgr.getReferencesTo(addr);
            while (refIter.hasNext() && offcuts.size() - max != 0) {
                Reference ref = refIter.next();
                offcuts.add(ref);
            }
        }
        return offcuts;
    }

    public static void getVariableRefs(Variable var, List<Reference> xrefs, List<Reference> offcuts) {
        XReferenceUtils.getVariableRefs(var, xrefs, offcuts, -1);
    }

    public static void getVariableRefs(Variable var, List<Reference> xrefs, List<Reference> offcuts, int max) {
        Address addr = var.getMinAddress();
        if (addr == null) {
            return;
        }
        Program program = var.getFunction().getProgram();
        ReferenceManager refMgr = program.getReferenceManager();
        Reference[] refs = refMgr.getReferencesTo(var);
        int total = 0;
        for (Reference vref : refs) {
            if (total++ - max == 0) break;
            if (addr.equals((Object)vref.getToAddress())) {
                xrefs.add(vref);
                continue;
            }
            offcuts.add(vref);
        }
    }

    public static Set<Reference> getAllXrefs(ProgramLocation location) {
        Data cu = DataUtilities.getDataAtLocation((ProgramLocation)location);
        if (cu == null) {
            Address toAddress = location.getAddress();
            Listing listing = location.getProgram().getListing();
            cu = listing.getCodeUnitContaining(toAddress);
        }
        if (cu == null) {
            return Collections.emptySet();
        }
        List<Reference> xrefs = XReferenceUtils.getXReferences((CodeUnit)cu, -1);
        List<Reference> offcuts = XReferenceUtils.getOffcutXReferences((CodeUnit)cu, -1);
        HashSet<Reference> set = new HashSet<Reference>();
        set.addAll(xrefs);
        set.addAll(offcuts);
        return set;
    }

    @Deprecated(since="12.0", forRemoval=true)
    public static void showXrefs(Navigatable navigatable, ServiceProvider serviceProvider, TableService service, ProgramLocation location, Collection<Reference> xrefs) {
        XReferenceUtils.showXrefs(navigatable, serviceProvider, service, location, () -> xrefs);
    }

    public static void showXrefs(Navigatable navigatable, ServiceProvider serviceProvider, TableService service, ProgramLocation location, Supplier<Collection<Reference>> xrefs) {
        Address address = location.getAddress();
        Program program = location.getProgram();
        FunctionManager fm = program.getFunctionManager();
        Function function = fm.getFunctionAt(address);
        ReferencesFromTableModel model = function == null ? new ReferencesFromTableModel(xrefs, serviceProvider, program) : new FunctionXrefsTableModel(function, xrefs, serviceProvider, program);
        String title = XReferenceUtils.generateXRefTitle(location);
        TableComponentProvider<ReferenceEndpoint> provider = service.showTable(title, "Xrefs", model, "Xrefs", navigatable);
        provider.installRemoveItemsAction();
        XReferenceUtils.installRefreshAction(provider, model);
        if (function != null) {
            XReferenceUtils.installShowThunksAction(provider, model);
        }
        DeleteXrefsAction deleteAction = new DeleteXrefsAction(provider, model, program);
        provider.addLocalAction((DockingActionIf)deleteAction);
    }

    private static void installShowThunksAction(TableComponentProvider<ReferenceEndpoint> provider, ReferencesFromTableModel model) {
        String actionName = "Show Thunk Xrefs";
        ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(actionName, provider.getActionOwner()).toolBarIcon((Icon)ResourceManager.loadImage((String)"images/ThunkFunction.gif"))).toolBarGroup("A")).helpLocation(new HelpLocation("CodeBrowserPlugin", actionName))).selected(false).onAction(c -> ((FunctionXrefsTableModel)model).toggleShowAllThunkXRefs())).buildAndInstallLocal(provider);
    }

    private static void installRefreshAction(TableComponentProvider<ReferenceEndpoint> provider, final ReferencesFromTableModel model) {
        final ImageIcon REFRESH_NOT_NEEDED_ICON = ResourceManager.getDisabledIcon((Icon)Icons.REFRESH_ICON, (int)60);
        DockingAction refreshAction = new DockingAction("Refresh", provider.getActionOwner()){

            public void actionPerformed(ActionContext context) {
                this.getToolBarData().setIcon(REFRESH_NOT_NEEDED_ICON);
                model.reload();
            }
        };
        HelpLocation hl = new HelpLocation("CodeBrowserPlugin", refreshAction.getName());
        refreshAction.setHelpLocation(hl);
        refreshAction.setToolBarData(new ToolBarData((Icon)REFRESH_NOT_NEEDED_ICON, "A"));
        refreshAction.setDescription("<html>Push at any time to refresh the current table of references.<br>This button is highlighted when the data <i>may</i> be stale.<br>");
        DomainObjectListener listener = ((DomainObjectListenerBuilder)new DomainObjectListenerBuilder((Object)model).any(new EventType[]{DomainObjectEvent.RESTORED, ProgramEvent.REFERENCE_ADDED, ProgramEvent.REFERENCE_REMOVED}).call(() -> refreshAction.getToolBarData().setIcon(Icons.REFRESH_ICON))).build();
        provider.setProgramListener(listener);
        provider.addLocalAction((DockingActionIf)refreshAction);
    }

    private static void deleteXrefs(PluginTool tool, Program program, ReferencesFromTableModel tableModel, int[] rows) {
        int choice;
        if (promptToDeleteXrefsDialog == null) {
            promptToDeleteXrefsDialog = new OptionDialogBuilder("Delete Xrefs?", "Do you wish to permanently delete the selected xrefs?").addOption("Delete").addCancel().addDontShowAgainOption().build();
        }
        if ((choice = promptToDeleteXrefsDialog.show()) != 1) {
            return;
        }
        ArrayList<ReferenceEndpoint> deletedRowObjects = new ArrayList<ReferenceEndpoint>();
        CompoundCmd compoundCmd = new CompoundCmd("Delete References");
        for (int row : rows) {
            ReferenceEndpoint endpoint = (ReferenceEndpoint)tableModel.getRowObject(row);
            Reference ref = endpoint.getReference();
            RefType type = ref.getReferenceType();
            if (type == RefType.THUNK) continue;
            deletedRowObjects.add(endpoint);
            RemoveReferenceCmd cmd = new RemoveReferenceCmd(ref);
            compoundCmd.add((Command)cmd);
        }
        tool.execute((Command)compoundCmd, (DomainObject)program);
        deletedRowObjects.forEach(ro -> tableModel.removeObject(ro));
    }

    private static String generateXRefTitle(ProgramLocation location) {
        Program program = location.getProgram();
        FunctionManager functionManager = program.getFunctionManager();
        Address address = location.getAddress();
        if (location instanceof VariableLocation) {
            VariableLocation vl = (VariableLocation)location;
            String name = vl.getVariable().getName();
            Function f = functionManager.getFunctionContaining(vl.getFunctionAddress());
            return X_REFS_TO + name + (String)(f == null ? "" : " in " + f.getName());
        }
        if (location instanceof FunctionLocation) {
            FunctionLocation fl = (FunctionLocation)location;
            Function f = functionManager.getFunctionContaining(fl.getFunctionAddress());
            if (f != null) {
                return X_REFS_TO + f.getName();
            }
        } else {
            Function f = functionManager.getFunctionAt(address);
            if (f != null) {
                return X_REFS_TO + f.getName();
            }
        }
        return X_REFS_TO + String.valueOf(location.getAddress());
    }

    private static class DeleteXrefsAction
    extends DockingAction {
        private TableComponentProvider<ReferenceEndpoint> provider;
        private Program program;
        private ReferencesFromTableModel tableModel;

        public DeleteXrefsAction(TableComponentProvider<ReferenceEndpoint> provider, ReferencesFromTableModel tableModel, Program program) {
            super("Delete Reference", provider.getActionOwner(), KeyBindingType.SHARED);
            this.provider = provider;
            this.tableModel = tableModel;
            this.program = program;
            this.setToolBarData(new ToolBarData(Icons.DELETE_ICON, "A"));
            this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", this.getName()));
        }

        public boolean isEnabledForContext(ActionContext c) {
            Object object = c.getContextObject();
            if (!(object instanceof JTable)) {
                return false;
            }
            JTable table = (JTable)object;
            if (this.tableModel.isBusy()) {
                return false;
            }
            return this.hasNonThunkRefs(table);
        }

        private boolean hasNonThunkRefs(JTable table) {
            int[] rows;
            for (int row : rows = table.getSelectedRows()) {
                ReferenceEndpoint rowObject = (ReferenceEndpoint)this.tableModel.getRowObject(row);
                Reference ref = rowObject.getReference();
                RefType type = ref.getReferenceType();
                if (type == RefType.THUNK) continue;
                return true;
            }
            return false;
        }

        public void actionPerformed(ActionContext c) {
            Object object = c.getContextObject();
            JTable table = (JTable)object;
            int[] rows = table.getSelectedRows();
            PluginTool tool = this.provider.getTool();
            XReferenceUtils.deleteXrefs(tool, this.program, this.tableModel, rows);
        }
    }
}

