/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import ghidra.app.plugin.core.data.AbstractSettingsDialog;
import ghidra.app.plugin.core.data.DataSettingsDialog;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.StringSettingsDefinition;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.TypeDef;
import ghidra.util.HelpLocation;

public class DataTypeSettingsDialog
extends AbstractSettingsDialog {
    private DataType dataType;
    private DataTypeComponent dtc;

    public DataTypeSettingsDialog(DataType dataType, SettingsDefinition[] settingsDefinitions) {
        super(DataTypeSettingsDialog.constructTitle(null, dataType, true), settingsDefinitions, dataType.getDefaultSettings());
        DataTypeSettingsDialog.checkDataType(dataType);
        this.dataType = dataType;
        this.setHelpLocation(new HelpLocation("DataPlugin", "Default_Settings"));
    }

    DataTypeSettingsDialog(DataTypeComponent dtc) {
        super(DataTypeSettingsDialog.constructTitle(dtc, dtc.getDataType(), true), DataSettingsDialog.getAllowedDataInstanceSettingsDefinitions(dtc.getDataType()), dtc.getDefaultSettings());
        DataTypeSettingsDialog.checkDataType(dtc.getParent());
        this.dtc = dtc;
        this.dataType = dtc.getDataType();
        this.setHelpLocation(new HelpLocation("DataPlugin", "SettingsOnStructureComponents"));
    }

    private static void checkDataType(DataType dt) {
        long id;
        DataTypeManager dtm = dt.getDataTypeManager();
        if (dtm instanceof BuiltInDataTypeManager) {
            throw new IllegalArgumentException("Unsupported use for datatype from BuiltInDataTypeManager");
        }
        if (dtm instanceof DataTypeManagerDB && (id = dtm.getID(dt)) > 0L && dt == dtm.getDataType(id)) {
            return;
        }
        throw new IllegalArgumentException("Invalid data type instance");
    }

    @Override
    public void dispose() {
        super.dispose();
        this.dataType = null;
        this.dtc = null;
    }

    static String constructTitle(DataTypeComponent dtc, DataType dataType, boolean isDefault) {
        StringBuffer nameBuf = new StringBuffer();
        if (isDefault) {
            nameBuf.append("Default ");
        }
        String name = dataType.getDisplayName();
        if (dtc == null) {
            name = DataTypeSettingsDialog.getSettingsBaseType(dataType).getDisplayName();
        }
        nameBuf.append(name);
        nameBuf.append(" Settings");
        if (dtc != null) {
            nameBuf.append(" (");
            nameBuf.append(dtc.getParent().getDisplayName());
            nameBuf.append('.');
            String fname = dtc.getFieldName();
            if (fname == null) {
                fname = dtc.getDefaultFieldName();
            }
            nameBuf.append(fname);
            nameBuf.append(')');
        }
        return nameBuf.toString();
    }

    private static DataType getSettingsBaseType(DataType dt) {
        while (true) {
            if (dt instanceof TypeDef) {
                DataType baseDt = ((TypeDef)dt).getBaseDataType();
                if (!(baseDt instanceof Array)) break;
                dt = baseDt;
                continue;
            }
            if (!(dt instanceof Array)) break;
            dt = ((Array)dt).getDataType();
        }
        return dt;
    }

    private Settings getOriginalSettings() {
        if (this.dtc != null) {
            return this.dtc.getDefaultSettings();
        }
        return this.dataType.getDefaultSettings();
    }

    @Override
    protected String[] getSuggestedValues(StringSettingsDefinition settingsDefinition) {
        if (settingsDefinition.supportsSuggestedValues()) {
            return settingsDefinition.getSuggestedValues(this.getOriginalSettings());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void applySettings() {
        DataTypeManager dtm = this.dataType.getDataTypeManager();
        int txId = dtm.startTransaction(this.getTitle());
        try {
            Settings originalSettings = this.getOriginalSettings();
            Settings modifiedSettings = this.getSettings();
            for (SettingsDefinition settingsDef : this.getSettingsDefinitions()) {
                settingsDef.copySetting(modifiedSettings, originalSettings);
            }
        }
        finally {
            dtm.endTransaction(txId, true);
        }
    }
}

